/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.blockrenderer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.util.Unit;

public class AsyncRenderer
implements ReloadInstance {
    private final CompletableFuture<Unit> allAsyncCompleted = new CompletableFuture();
    private final CompletableFuture<List<Void>> resultListFuture;
    private final Set<CompletableFuture<Void>> taskSet;
    private final List<CompletableFuture<Void>> sourceFurtures;
    private final int taskCount;
    private final AtomicInteger asyncScheduled = new AtomicInteger();
    private final AtomicInteger asyncCompleted = new AtomicInteger();

    public AsyncRenderer(List<CompletableFuture<Void>> futures) {
        this.sourceFurtures = futures;
        this.taskCount = futures.size();
        this.taskSet = new HashSet<CompletableFuture<Void>>(futures);
        this.asyncScheduled.incrementAndGet();
        CompletableFuture<Unit> alsoWaitedFor = CompletableFuture.completedFuture(Unit.INSTANCE);
        alsoWaitedFor.thenRun(this.asyncCompleted::incrementAndGet);
        ArrayList<CompletionStage> list = new ArrayList<CompletionStage>();
        CompletionStage<Object> waitFor = alsoWaitedFor;
        for (CompletableFuture<Void> future : futures) {
            CompletableFuture<Unit> finalWaitFor = waitFor;
            CompletionStage stateFuture = future.thenCompose(backgroundResult -> {
                Minecraft.m_91087_().execute(() -> {
                    this.taskSet.remove(future);
                    if (this.taskSet.isEmpty()) {
                        this.allAsyncCompleted.complete(Unit.INSTANCE);
                    }
                });
                return this.allAsyncCompleted.thenCombine(finalWaitFor, (unit, instance) -> null);
            });
            list.add(stateFuture);
            waitFor = stateFuture;
        }
        this.resultListFuture = Util.m_137567_(list);
    }

    public void cancel() {
        for (CompletableFuture<Void> future : this.sourceFurtures) {
            if (future.isDone()) continue;
            future.cancel(false);
        }
        this.resultListFuture.cancel(false);
    }

    @Nonnull
    public CompletableFuture<Unit> m_7237_() {
        return this.resultListFuture.thenApply(result -> Unit.INSTANCE);
    }

    public float m_7750_() {
        int remaining = this.taskCount - this.taskSet.size();
        float completed = 2 * this.asyncCompleted.get() + remaining;
        float total = 2 * this.asyncScheduled.get() + this.taskCount;
        return completed / total;
    }

    public boolean asyncPartDone() {
        return this.allAsyncCompleted.isDone();
    }

    public boolean fullyDone() {
        return this.resultListFuture.isDone();
    }

    public void m_7748_() {
        if (this.resultListFuture.isCompletedExceptionally()) {
            this.resultListFuture.join();
        }
    }
}

