/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.blockrenderer;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.unascribed.blockrenderer.BlockRenderer;
import com.unascribed.blockrenderer.EntityRenderTask;
import com.unascribed.blockrenderer.GuiConfigureRender;
import com.unascribed.blockrenderer.ItemRenderTask;
import com.unascribed.blockrenderer.RenderProgressGui;
import com.unascribed.blockrenderer.RenderTask;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.registries.ForgeRegistries;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;

public class ClientRenderHandler {
    private static final ScheduledExecutorService SCHEDULER = new ScheduledThreadPoolExecutor(0);
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    protected KeyMapping bind = new KeyMapping("key.blockrenderer.render", 96, "key.blockrenderer.category");
    protected boolean down = false;
    protected String pendingBulkRender;
    protected int pendingBulkRenderSize;
    protected boolean pendingBulkItems;
    protected boolean pendingBulkEntities;
    protected boolean pendingBulkStructures;
    private float oldZLevel;

    public ClientRenderHandler() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::onFrameStart);
    }

    public void onFrameStart(TickEvent.RenderTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.m_91087_();
            Overlay loadingGui = mc.m_91265_();
            if (loadingGui instanceof RenderProgressGui && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)256)) {
                ((RenderProgressGui)loadingGui).cancel();
                return;
            }
            if (this.pendingBulkRender != null) {
                this.bulkRender(this.pendingBulkRender, this.pendingBulkRenderSize, this.pendingBulkItems, this.pendingBulkEntities, this.pendingBulkStructures);
                this.pendingBulkRender = null;
            }
            if (ClientRenderHandler.isKeyDown(this.bind)) {
                if (!this.down) {
                    this.down = true;
                    if (mc.f_91073_ == null) {
                        mc.f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"msg.blockrenderer.no_world"));
                        return;
                    }
                    Slot hovered = null;
                    Screen currentScreen = mc.f_91080_;
                    if (currentScreen instanceof ChatScreen) {
                        return;
                    }
                    if (currentScreen instanceof AbstractContainerScreen) {
                        hovered = ((AbstractContainerScreen)currentScreen).getSlotUnderMouse();
                    }
                    if (Screen.m_96637_()) {
                        String modId = null;
                        if (hovered != null && hovered.m_6657_()) {
                            modId = hovered.m_7993_().m_41720_().m_204114_().m_205785_().m_135782_().m_135827_();
                        }
                        mc.m_91152_((Screen)new GuiConfigureRender(mc.f_91080_, modId));
                    } else if (currentScreen instanceof AbstractContainerScreen) {
                        if (hovered == null) {
                            mc.f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"msg.blockrenderer.slot.absent"));
                        } else {
                            ItemStack stack = hovered.m_7993_();
                            if (stack.m_41619_()) {
                                mc.f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"msg.blockrenderer.slot.empty"));
                            } else {
                                int size = 512;
                                if (Screen.m_96638_()) {
                                    size = (int)(16.0 * mc.m_91268_().m_85449_());
                                }
                                mc.f_91065_.m_93076_().m_93785_(this.render(mc, new ItemRenderTask(stack), size, new File("renders/items"), false));
                            }
                        }
                    } else {
                        mc.f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"msg.blockrenderer.not_container"));
                    }
                }
            } else {
                this.down = false;
            }
        }
    }

    private void bulkRender(String modidSpec, int size, boolean items, boolean entities, boolean structures) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new PauseScreen(true));
        HashSet modIds = Sets.newHashSet();
        for (String string : modidSpec.split(",")) {
            modIds.add(string.trim());
        }
        ArrayList<RenderTask> toRender = new ArrayList<RenderTask>();
        NonNullList li = NonNullList.m_122779_();
        boolean wildcard = modIds.contains("*");
        if (items) {
            for (Map.Entry entry : ForgeRegistries.ITEMS.getEntries()) {
                if (!wildcard && !modIds.contains(((ResourceKey)entry.getKey()).m_135782_().m_135827_())) continue;
                li.clear();
                Item item = (Item)entry.getValue();
                li.add((Object)item.m_7968_());
                for (ItemStack is : li) {
                    toRender.add(new ItemRenderTask(is));
                }
            }
        }
        if (entities) {
            for (Map.Entry entry : ForgeRegistries.ENTITY_TYPES.getEntries()) {
                if (!wildcard && !modIds.contains(((ResourceKey)entry.getKey()).m_135782_().m_135827_())) continue;
                li.clear();
                EntityType entityType = (EntityType)entry.getValue();
                try {
                    Entity e = entityType.m_20615_((Level)mc.f_91073_);
                    if (e == null) continue;
                    toRender.add(new EntityRenderTask(e));
                }
                catch (Throwable t) {
                    BlockRenderer.log.warn("Failed to get renderable entity for {}", (Object)((ResourceKey)entry.getKey()).m_211136_());
                }
            }
        }
        File file = new File("renders/" + dateFormat.format(new Date()) + "_" + ClientRenderHandler.sanitize(modidSpec) + "/");
        RenderProgressGui progressBar = new RenderProgressGui(mc, toRender.size(), Joiner.on((String)", ").join((Iterable)modIds));
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        List batchedLists = Lists.partition(toRender, (int)10);
        int batchedCount = batchedLists.size();
        for (int batchIndex = 0; batchIndex < batchedCount; ++batchIndex) {
            futures.add(this.createFuture((List)batchedLists.get(batchIndex), size, file, false, batchIndex + 1, progressBar));
        }
        progressBar.setFutures(futures);
        mc.m_91150_((Overlay)progressBar);
    }

    private GuiGraphics setUpRenderState(Minecraft mc, int desiredSize) {
        Window window = mc.m_91268_();
        int size = Math.min(Math.min(window.m_85442_(), window.m_85441_()), desiredSize);
        GuiGraphics graphics = new GuiGraphics(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_());
        RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.getProjectionMatrix().identity().setOrtho(0.0f, (float)window.m_85441_(), (float)window.m_85442_(), 0.0f, 1000.0f, 3000.0f);
        PoseStack stack = RenderSystem.getModelViewStack();
        stack.m_85836_();
        stack.m_166856_();
        stack.m_252880_(0.0f, 0.0f, -2000.0f);
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
        PoseStack posestack1 = graphics.m_280168_();
        float scale = (float)size / 16.0f;
        posestack1.m_252880_(0.0f, 0.0f, -(scale * 100.0f));
        posestack1.m_85841_(scale, scale, scale);
        posestack1.m_252880_(0.0f, 0.0f, -50.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        return graphics;
    }

    private void tearDownRenderState() {
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.getModelViewStack().m_85849_();
    }

    private Component render(Minecraft mc, RenderTask task, int size, File folder, boolean includeDateInFilename) {
        GuiGraphics graphics = this.setUpRenderState(mc, size);
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
        try {
            task.render(graphics, size);
        }
        catch (Throwable t) {
            BlockRenderer.log.warn("Failed to render " + task.getId(), t);
            return Component.m_237115_((String)"msg.blockrenderer.render.fail");
        }
        BufferedImage image = ClientRenderHandler.readPixels(size, size);
        this.tearDownRenderState();
        File file = ClientRenderHandler.saveImage(image, task, folder, includeDateInFilename);
        return Component.m_237110_((String)"msg.blockrenderer.render.success", (Object[])new Object[]{file.getPath()});
    }

    private CompletableFuture<Void> createFuture(List<RenderTask> tasks, int size, File folder, boolean includeDateInFilename, int tickDelay, RenderProgressGui progressBar) {
        Object gameExecutor = tickDelay == 0 ? Minecraft.m_91087_() : r -> SCHEDULER.schedule(() -> Minecraft.m_91087_().execute(r), (long)tickDelay * 50L, TimeUnit.MILLISECONDS);
        return CompletableFuture.supplyAsync(() -> {
            GuiGraphics stack = this.setUpRenderState(Minecraft.m_91087_(), size);
            ArrayList<Pair> images = new ArrayList<Pair>();
            for (RenderTask task : tasks) {
                RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
                task.render(stack, size);
                images.add(Pair.of((Object)task, (Object)ClientRenderHandler.readPixels(size, size)));
                progressBar.update(task);
            }
            this.tearDownRenderState();
            return images;
        }, (Executor)gameExecutor).thenAcceptAsync(images -> {
            int types = 0;
            if (this.pendingBulkItems) {
                ++types;
            }
            if (this.pendingBulkEntities) {
                ++types;
            }
            if (this.pendingBulkStructures) {
                ++types;
            }
            for (Pair image : images) {
                ClientRenderHandler.saveImage((BufferedImage)image.getSecond(), (RenderTask)image.getFirst(), types > 1 ? new File(folder, ((RenderTask)image.getFirst()).getCategory()) : folder, includeDateInFilename);
            }
        }, (Executor)Util.m_183991_());
    }

    private static File saveImage(BufferedImage image, RenderTask task, File folder, boolean includeDateInFilename) {
        try {
            String fileName = ClientRenderHandler.getFilename(task.getItemStack());
            File f = new File(folder, fileName + ".png");
            int i = 2;
            while (f.exists()) {
                f = new File(folder, fileName + "_" + i + ".png");
                ++i;
            }
            Files.createParentDirs((File)f);
            f.createNewFile();
            ImageIO.write((RenderedImage)image, "PNG", f);
            return f;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getFilename(ItemStack itemStack) {
        String outName = itemStack.m_41720_().m_204114_().m_205785_().m_135782_().m_135827_() + "_" + itemStack.m_41720_().m_204114_().m_205785_().m_135782_().m_135815_();
        return outName.toUpperCase().replace("MINECRAFT_", "") + "_0";
    }

    private static String sanitize(String str) {
        return str.replaceAll("[^A-Za-z0-9-_ ]", "_");
    }

    private static BufferedImage readPixels(int width, int height) {
        ByteBuffer buf = BufferUtils.createByteBuffer((int)(width * height * 4));
        RenderSystem.readPixels((int)0, (int)(Minecraft.m_91087_().m_91268_().m_85442_() - height), (int)width, (int)height, (int)32993, (int)5121, (ByteBuffer)buf);
        BufferedImage img = new BufferedImage(width, height, 2);
        int[] pixels = new int[width * height];
        buf.asIntBuffer().get(pixels);
        for (int y = 0; y < height; ++y) {
            img.setRGB(0, height - 1 - y, width, 1, pixels, y * width, width);
        }
        return img;
    }

    private static boolean isKeyDown(KeyMapping keyBinding) {
        InputConstants.Key key = keyBinding.getKey();
        int keyCode = key.m_84873_();
        if (keyCode != InputConstants.f_84822_.m_84873_()) {
            long windowHandle = Minecraft.m_91087_().m_91268_().m_85439_();
            try {
                if (key.m_84868_() == InputConstants.Type.KEYSYM) {
                    return InputConstants.m_84830_((long)windowHandle, (int)keyCode);
                }
                if (key.m_84868_() == InputConstants.Type.MOUSE) {
                    return GLFW.glfwGetMouseButton((long)windowHandle, (int)keyCode) == 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

