/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.blockrenderer;

import com.google.common.base.Strings;
import com.unascribed.blockrenderer.BlockRenderer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class GuiConfigureRender
extends Screen {
    private final String prefill;
    private final Screen old;
    private EditBox text;
    private Slider slider;
    private double sliderValue;
    private boolean fixSliderMax;

    public GuiConfigureRender(Screen old, String prefill) {
        super((Component)Component.m_237119_());
        this.old = old;
        this.prefill = Strings.nullToEmpty((String)prefill);
        this.sliderValue = 512.0;
    }

    public void m_6574_(@Nonnull Minecraft minecraft, int width, int height) {
        String oldText = this.text.m_94155_();
        this.m_6575_(minecraft, width, height);
        this.text.m_94144_(oldText);
        this.fixSliderMax = true;
    }

    public void m_7856_() {
        this.text = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 6 + 50, 200, 20, (Component)Component.m_237119_());
        this.text.m_94199_(4096);
        this.text.m_94144_(this.prefill);
        this.m_7787_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.blockrenderer.cancel"), button -> this.f_96541_.m_91152_(this.old)).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 6 + 120, 98, 20).m_253136_());
        this.m_7787_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.blockrenderer.render"), button -> this.render()).m_252987_(this.f_96543_ / 2 + 2, this.f_96544_ / 6 + 120, 98, 20).m_253136_());
        this.slider = (Slider)this.m_7787_((GuiEventListener)new Slider(this.f_96543_ / 2 - 100, this.f_96544_ / 6 + 80, 200, 20, (Component)Component.m_237115_((String)"gui.blockrenderer.render_size"), this.sliderValue, 16.0, this.getSliderMax()));
        this.text.m_93692_(true);
        this.text.m_94190_(false);
    }

    private int getSliderMax() {
        return Math.min(2048, Math.min(this.f_96541_.m_91268_().m_85441_(), this.f_96541_.m_91268_().m_85442_()));
    }

    private int round(double value) {
        int minSize;
        int val = (int)value;
        int nearestPowerOfTwo = (int)Math.pow(2.0, Math.ceil(Math.log(val) / Math.log(2.0)));
        if (nearestPowerOfTwo < (minSize = Math.min(this.f_96541_.m_91268_().m_85442_(), this.f_96541_.m_91268_().m_85441_())) && Math.abs(val - nearestPowerOfTwo) < 32) {
            val = nearestPowerOfTwo;
        }
        return Math.min(val, minSize);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        if (this.text.m_94155_().isEmpty()) {
            this.text.m_94167_(I18n.m_118938_((String)"gui.blockrenderer.namespace", (Object[])new Object[0]));
        } else {
            this.text.m_94167_("");
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280653_(this.f_96541_.f_91062_, (Component)Component.m_237115_((String)"gui.blockrenderer.configure"), this.f_96543_ / 2, this.f_96544_ / 6, -1);
        int displayWidth = this.f_96541_.m_91268_().m_85441_();
        int displayHeight = this.f_96541_.m_91268_().m_85442_();
        boolean widthCap = displayWidth < 2048;
        boolean heightCap = displayHeight < 2048;
        String translationKey = null;
        if (widthCap && heightCap) {
            translationKey = displayWidth > displayHeight ? "gui.blockrenderer.capped_height" : (displayWidth == displayHeight ? "gui.blockrenderer.capped_both" : "gui.blockrenderer.capped_width");
        } else if (widthCap) {
            translationKey = "gui.blockrenderer.capped_width";
        } else if (heightCap) {
            translationKey = "gui.blockrenderer.capped_height";
        }
        if (translationKey != null) {
            guiGraphics.m_280653_(this.f_96541_.f_91062_, (Component)Component.m_237110_((String)translationKey, (Object[])new Object[]{Math.min(displayHeight, displayWidth)}), this.f_96543_ / 2, this.f_96544_ / 6 + 104, 0xFFFFFF);
        }
        this.text.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void render() {
        if (this.f_96541_.f_91073_ != null) {
            BlockRenderer.renderHandler.pendingBulkRender = this.text.m_94155_();
            BlockRenderer.renderHandler.pendingBulkRenderSize = this.round(this.sliderValue);
            BlockRenderer.renderHandler.pendingBulkItems = true;
            BlockRenderer.renderHandler.pendingBulkEntities = false;
            BlockRenderer.renderHandler.pendingBulkStructures = false;
        }
        this.f_96541_.m_91152_(this.old);
    }

    public void m_86600_() {
        super.m_86600_();
        this.text.m_94120_();
        if (this.fixSliderMax) {
            this.fixSliderMax = false;
            this.slider.updateSliderMax(this.getSliderMax());
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.text.m_94204_() && keyCode != 256) {
            if (keyCode == 257 || keyCode == 335) {
                this.render();
                return true;
            }
            return this.text.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char c, int keyCode) {
        if (this.text.m_94204_()) {
            return this.text.m_5534_(c, keyCode);
        }
        return super.m_5534_(c, keyCode);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.text.m_5953_(mouseX, mouseY)) {
            return this.text.m_6375_(mouseX, mouseY, mouseButton);
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void m_7379_() {
        super.m_7379_();
    }

    private static double normalizeValue(double value, double min, double max) {
        return Mth.m_14008_((double)((Mth.m_14008_((double)value, (double)min, (double)max) - min) / (max - min)), (double)0.0, (double)1.0);
    }

    private class Slider
    extends AbstractSliderButton {
        private final double minValue;
        private double maxValue;

        public Slider(int x, int y, int width, int height, Component message, double defaultValue, double minValue, double maxValue) {
            super(x, y, width, height, message, GuiConfigureRender.normalizeValue(defaultValue, minValue, maxValue));
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.m_5695_();
        }

        protected void m_5695_() {
            this.m_93666_((Component)Component.m_237110_((String)"gui.blockrenderer.selected_dimensions", (Object[])new Object[]{GuiConfigureRender.this.round(GuiConfigureRender.this.sliderValue)}));
        }

        private double denormalizeValue() {
            return Mth.m_14008_((double)Mth.m_14139_((double)Mth.m_14008_((double)GuiConfigureRender.this.sliderValue, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue), (double)this.minValue, (double)this.maxValue);
        }

        protected void m_5697_() {
            GuiConfigureRender.this.sliderValue = this.denormalizeValue();
        }

        protected void updateSliderMax(double maxValue) {
            double value = this.denormalizeValue();
            this.maxValue = maxValue;
            GuiConfigureRender.this.sliderValue = GuiConfigureRender.normalizeValue(value, this.minValue, this.maxValue);
            this.m_5697_();
            this.m_5695_();
        }
    }
}

