/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.blockrenderer;

import com.unascribed.blockrenderer.AsyncRenderer;
import com.unascribed.blockrenderer.BlockRenderer;
import com.unascribed.blockrenderer.RenderTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class RenderProgressGui
extends Overlay {
    private static final int BG = -14273992;
    private static final int BG_NOALPHA = 2503224;
    private final Minecraft mc;
    private final int total;
    private final String joined;
    private Component title;
    private List<Component> subTitles = Collections.emptyList();
    private AsyncRenderer renderer;
    private float progress;
    private long fadeOutStart = -1L;
    private long fadeInStart = -1L;
    private long start = -1L;
    private int rendered;
    private RenderTask task = null;
    private boolean canceled;

    public RenderProgressGui(Minecraft mc, int total, String joined) {
        this.mc = mc;
        this.total = total;
        this.joined = joined;
        this.title = Component.m_237110_((String)"gui.blockrenderer.rendering", (Object[])new Object[]{this.total, this.joined});
    }

    public void setFutures(List<CompletableFuture<Void>> futures) {
        this.renderer = new AsyncRenderer(futures);
    }

    public void cancel() {
        if (!this.canceled) {
            this.canceled = true;
            this.title = Component.m_237110_((String)"gui.blockrenderer.render_cancelled", (Object[])new Object[]{this.rendered, this.total, this.total - this.rendered});
            this.subTitles = Collections.emptyList();
            this.task = null;
            this.renderer.cancel();
        }
    }

    public void update(RenderTask task) {
        ++this.rendered;
        int remaining = this.total - this.rendered;
        if (remaining > 0) {
            if (this.canceled) {
                this.title = Component.m_237110_((String)"gui.blockrenderer.render_cancelled", (Object[])new Object[]{this.rendered, this.total, remaining});
            } else {
                this.subTitles = new ArrayList<Component>();
                this.subTitles.add((Component)Component.m_237110_((String)"gui.blockrenderer.progress", (Object[])new Object[]{this.rendered, this.total, remaining}));
                this.subTitles.add(task.getPreviewDisplayName());
                this.task = task;
            }
        } else {
            this.title = Component.m_237110_((String)"gui.blockrenderer.rendered", (Object[])new Object[]{this.total, this.joined});
            this.subTitles = Collections.emptyList();
            this.task = null;
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int a;
        float fadeInTime;
        int scaledWidth = this.mc.m_91268_().m_85445_();
        int scaledHeight = this.mc.m_91268_().m_85446_();
        long now = Util.m_137550_();
        if (this.start == -1L) {
            this.start = now;
        }
        if ((this.renderer.asyncPartDone() || this.mc.f_91080_ != null) && this.fadeInStart == -1L) {
            this.fadeInStart = now;
        }
        float fadeOutTime = this.fadeOutStart > -1L ? (float)(now - this.fadeOutStart) / 1000.0f : -1.0f;
        float f = fadeInTime = this.fadeInStart > -1L ? (float)(now - this.fadeInStart) / 500.0f : -1.0f;
        if (fadeOutTime >= 1.0f) {
            if (this.mc.f_91080_ != null) {
                this.mc.f_91080_.m_88315_(guiGraphics, 0, 0, partialTicks);
            }
            a = Mth.m_14167_((float)((1.0f - Mth.m_14036_((float)(fadeOutTime - 1.0f), (float)0.0f, (float)1.0f)) * 255.0f));
            guiGraphics.m_280509_(0, 0, scaledWidth, scaledHeight, 0x263238 | a << 24);
        } else {
            if (this.mc.f_91080_ != null && fadeInTime < 1.0f) {
                this.mc.f_91080_.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            }
            a = Mth.m_14165_((double)(Mth.m_14008_((double)fadeInTime, (double)0.15, (double)1.0) * 255.0));
            guiGraphics.m_280509_(0, 0, scaledWidth, scaledHeight, 0x263238 | a << 24);
        }
        int barSize = (int)(Math.min((double)scaledWidth * 0.75, (double)scaledHeight) * 0.25 * 4.0 / 2.0);
        int barPosition = (int)((double)scaledHeight * 0.8325);
        this.progress = Mth.m_14036_((float)(this.progress * 0.95f + this.renderer.m_7750_() * 0.05f), (float)0.0f, (float)1.0f);
        this.renderProgressText(guiGraphics, scaledWidth, scaledHeight, a << 24);
        if (fadeOutTime < 1.0f) {
            this.drawProgressBar(guiGraphics, scaledWidth / 2 - barSize, barPosition - 5, scaledWidth / 2 + barSize, barPosition + 5, 1.0f - Mth.m_14036_((float)fadeOutTime, (float)0.0f, (float)1.0f));
        } else if (fadeOutTime >= 2.0f) {
            this.mc.m_91150_(null);
        }
        if (this.fadeOutStart == -1L && this.renderer.fullyDone() && fadeInTime >= 2.0f) {
            this.fadeOutStart = Util.m_137550_();
            try {
                this.renderer.m_7748_();
                this.mc.f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"msg.blockrenderer.rendered", (Object[])new Object[]{this.total, this.joined, now - this.start}));
            }
            catch (Throwable t) {
                BlockRenderer.log.warn("Error joining renderer", t);
            }
            if (this.mc.f_91080_ != null) {
                this.mc.f_91080_.m_6575_(this.mc, scaledWidth, scaledHeight);
            }
        }
    }

    private void drawProgressBar(GuiGraphics guiGraphics, int xStart, int yStart, int xEnd, int yEnd, float alpha) {
        int filled = Mth.m_14167_((float)((float)(xEnd - xStart - 2) * this.progress));
        int a = Math.round(alpha * 255.0f);
        int packed = FastColor.ARGB32.m_13660_((int)a, (int)255, (int)255, (int)255);
        guiGraphics.m_280509_(xStart + 1, yStart, xEnd - 1, yStart + 1, packed);
        guiGraphics.m_280509_(xStart + 1, yEnd, xEnd - 1, yEnd - 1, packed);
        guiGraphics.m_280509_(xStart, yStart, xStart + 1, yEnd, packed);
        guiGraphics.m_280509_(xEnd, yStart, xEnd - 1, yEnd, packed);
        guiGraphics.m_280509_(xStart + 2, yStart + 2, xStart + filled, yEnd - 2, packed);
    }

    private void renderProgressText(GuiGraphics guiGraphics, int scaledWidth, int scaledHeight, int a) {
        int subTitleCount;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(2.0f, 2.0f, 0.0f);
        if (a != 0) {
            guiGraphics.m_280653_(this.mc.f_91062_, this.title, scaledWidth / 4, scaledHeight / 4 - 24, 0xFFFFFF | a);
        }
        if ((subTitleCount = this.subTitles.size()) > 0) {
            guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.0f);
            int subTitleX = scaledWidth / 2;
            int subTitleY = scaledHeight / 2;
            if (a != 0) {
                for (int i = 0; i < subTitleCount; ++i) {
                    guiGraphics.m_280653_(this.mc.f_91062_, this.subTitles.get(i), subTitleX, subTitleY + 20 * (i - 1), 0xFFFFFF | a);
                }
            }
            if (this.task != null) {
                this.task.renderPreview(guiGraphics, subTitleX - 8, subTitleY + 20 * (subTitleCount - 1));
            }
        }
        guiGraphics.m_280168_().m_85849_();
    }
}

