/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.chatshot.compat;

import dev.dediamondpro.chatshot.compat.ICompatHandler;
import dev.dediamondpro.chatshot.compat.NoChatReportsCompat;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;

public class CompatCore {
    private static final ConcurrentLinkedDeque<ICompatHandler> compatHandlers = new ConcurrentLinkedDeque();

    public static int getButtonOffset() {
        int offset = 0;
        for (ICompatHandler handler : compatHandlers) {
            try {
                offset = Math.max(offset, handler.getButtonOffset());
            }
            catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError ignored) {
                compatHandlers.remove(handler);
            }
            catch (Throwable throwable) {}
        }
        return offset;
    }

    static {
        ArrayList<Supplier<ICompatHandler>> compatHandlerFactories = new ArrayList<Supplier<ICompatHandler>>(){
            {
                this.add(NoChatReportsCompat::new);
            }
        };
        for (Supplier supplier : compatHandlerFactories) {
            try {
                compatHandlers.add((ICompatHandler)supplier.get());
            }
            catch (Throwable throwable) {}
        }
    }
}

