/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.chatshot.mixins;

import dev.dediamondpro.chatshot.compat.CompatCore;
import dev.dediamondpro.chatshot.config.Config;
import dev.dediamondpro.chatshot.mixins.ChatHudAccessor;
import dev.dediamondpro.chatshot.util.ChatCopyUtil;
import dev.dediamondpro.chatshot.util.Textures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatScreen.class})
public abstract class ChatScreenMixin
extends Screen {
    @Unique
    private boolean mouseClicked = false;

    protected ChatScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    void onDraw(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        this.drawLineButton(context, mouseX, mouseY);
        this.drawScreenshotButton(context, mouseX, mouseY);
        this.mouseClicked = false;
    }

    @Unique
    private void drawLineButton(GuiGraphics context, int mouseX, int mouseY) {
        double chatLineY = this.getChatHudA().toChatLineYA(mouseY);
        int index = this.getChatHudA().getMessageIndexA(0.0, chatLineY);
        float chatScale = (float)this.getChatHud().m_93815_();
        int buttonX = (int)((float)this.getChatHud().m_93813_() + 14.0f * chatScale);
        if (index == -1 || mouseX > buttonX + 14) {
            return;
        }
        int lineHeight = this.getChatHudA().getLineHeightA();
        boolean hovering = mouseX >= buttonX && mouseX <= buttonX + 9;
        int color = this.f_96541_.f_91066_.m_92143_(Integer.MIN_VALUE);
        context.m_280168_().m_85836_();
        context.m_280168_().m_85841_(chatScale, chatScale, 1.0f);
        int scaledButtonX = (int)((float)this.getChatHud().m_93813_() / chatScale + 14.0f);
        int scaledButtonY = (int)((float)(this.f_96544_ - 40) / chatScale - (float)(((int)chatLineY + 1) * lineHeight));
        context.m_280509_(scaledButtonX, scaledButtonY, scaledButtonX + 9, scaledButtonY + 9, hovering ? 0xFFFFFF + color : color);
        context.m_280163_(Textures.COPY, scaledButtonX, scaledButtonY, 0.0f, 0.0f, 9, 9, 9, 9);
        context.m_280168_().m_85849_();
        if (hovering && Config.INSTANCE.tooltip) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237115_((String)"chatshot.copy"));
            tooltip.add(Component.m_237115_((String)("chatshot.click" + (Config.INSTANCE.clickAction == Config.CopyType.TEXT ? "Text" : "Image"))));
            tooltip.add(Component.m_237115_((String)("chatshot.shiftClick" + (Config.INSTANCE.shiftClickAction == Config.CopyType.TEXT ? "Text" : "Image"))));
            context.m_280666_(this.f_96541_.f_91062_, tooltip, mouseX, mouseY);
        }
        if (hovering && this.mouseClicked) {
            context.m_280262_();
            List<GuiMessage.Line> visibleMessages = this.getChatHudA().getVisibleMessages();
            ArrayList<GuiMessage.Line> messageParts = new ArrayList<GuiMessage.Line>();
            messageParts.add(visibleMessages.get(index));
            for (int i = index + 1; i < visibleMessages.size() && !visibleMessages.get(i).f_240367_(); ++i) {
                messageParts.add(0, visibleMessages.get(i));
            }
            if (messageParts.isEmpty()) {
                return;
            }
            ChatCopyUtil.copy(messageParts, this.f_96541_);
        }
    }

    @Unique
    private void drawScreenshotButton(GuiGraphics context, int mouseX, int mouseY) {
        int buttonX = this.f_96543_ - 12 - CompatCore.getButtonOffset();
        int buttonY = this.f_96544_ - 26;
        boolean hovering = mouseX >= buttonX && mouseX <= buttonX + 10 && mouseY >= buttonY && mouseY <= buttonY + 10;
        int color = this.f_96541_.f_91066_.m_92143_(Integer.MIN_VALUE);
        context.m_280509_(buttonX, buttonY, buttonX + 10, buttonY + 10, hovering ? 0xFFFFFF + color : color);
        context.m_280163_(Textures.SCREENSHOT, buttonX, buttonY, 0.0f, 0.0f, 10, 10, 10, 10);
        if (this.mouseClicked && hovering) {
            context.m_280262_();
            ArrayList<GuiMessage.Line> lines = new ArrayList<GuiMessage.Line>();
            int scrolledLines = this.getChatHudA().getScrolledLines();
            List<GuiMessage.Line> visibleMessages = this.getChatHudA().getVisibleMessages();
            for (int i = scrolledLines; i < visibleMessages.size() && i < this.getChatHud().m_93816_() + scrolledLines; ++i) {
                lines.add(0, visibleMessages.get(i));
            }
            ChatCopyUtil.copyImage(lines, this.f_96541_);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="RETURN")})
    void onMouseClick(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (button != 0) {
            return;
        }
        this.mouseClicked = (Boolean)cir.getReturnValue() == false;
    }

    @Unique
    private ChatComponent getChatHud() {
        return this.f_96541_.f_91065_.m_93076_();
    }

    @Unique
    private ChatHudAccessor getChatHudA() {
        return (ChatHudAccessor)this.getChatHud();
    }
}

