/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.chatshot.util;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.NativeImage;
import dev.dediamondpro.chatshot.config.Config;
import dev.dediamondpro.chatshot.util.CollectingCharacterVisitor;
import dev.dediamondpro.chatshot.util.clipboard.ClipboardUtil;
import dev.dediamondpro.chatshot.util.clipboard.MacOSCompat;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.Util;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSink;
import org.lwjgl.glfw.GLFW;

public class ChatCopyUtil {
    public static void copy(List<GuiMessage.Line> lines, Minecraft client) {
        if (GLFW.glfwGetKey((long)client.m_91268_().m_85439_(), (int)340) == 1 || GLFW.glfwGetKey((long)client.m_91268_().m_85439_(), (int)344) == 1) {
            if (Config.INSTANCE.shiftClickAction == Config.CopyType.TEXT) {
                ChatCopyUtil.copyString(lines, client);
            } else {
                ChatCopyUtil.copyImage(lines, client);
            }
        } else if (Config.INSTANCE.clickAction == Config.CopyType.TEXT) {
            ChatCopyUtil.copyString(lines, client);
        } else {
            ChatCopyUtil.copyImage(lines, client);
        }
    }

    public static void copyString(List<GuiMessage.Line> lines, Minecraft client) {
        CollectingCharacterVisitor visitor = new CollectingCharacterVisitor();
        for (GuiMessage.Line line : lines) {
            line.f_240339_().m_13731_((FormattedCharSink)visitor);
        }
        client.f_91068_.m_90911_(visitor.collect());
        if (Config.INSTANCE.showCopyMessage) {
            client.f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"chatshot.text.success"));
        }
    }

    public static void copyImage(List<GuiMessage.Line> lines, Minecraft client) {
        boolean shadow = Config.INSTANCE.shadow;
        int scaleFactor = Config.INSTANCE.scale;
        GuiGraphics context = new GuiGraphics(client, client.m_91269_().m_110104_());
        int width = 0;
        for (GuiMessage.Line line : lines) {
            width = Math.max(width, client.f_91062_.m_92724_(line.f_240339_()));
        }
        int height = lines.size() * 9;
        RenderTarget fb = ChatCopyUtil.createBuffer(width * scaleFactor, height * scaleFactor);
        context.m_280168_().m_85841_((float)client.m_91268_().m_85445_() / (float)width, (float)client.m_91268_().m_85446_() / (float)height, 1.0f);
        fb.m_83947_(false);
        int y = 0;
        for (GuiMessage.Line line : lines) {
            context.m_280649_(client.f_91062_, line.f_240339_(), 0, y, 0xFFFFFF, shadow);
            y += 9;
        }
        fb.m_83970_();
        try (NativeImage nativeImage = Screenshot.m_92279_((RenderTarget)fb);){
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(nativeImage.m_85121_()));
            BufferedImage transparentImage = ChatCopyUtil.imageToBufferedImage(ChatCopyUtil.makeColorTransparent(image, new Color(54, 57, 63)));
            boolean copySuccessfull = false;
            if (Config.INSTANCE.saveImage || Minecraft.f_91002_) {
                File screenShotDir = new File("screenshots/chat");
                screenShotDir.mkdirs();
                File screenshotFile = ChatCopyUtil.getScreenshotFilename(screenShotDir);
                ImageIO.write((RenderedImage)transparentImage, "png", screenshotFile);
                if (Minecraft.f_91002_) {
                    copySuccessfull = MacOSCompat.doCopyMacOS(screenshotFile.getAbsolutePath());
                    if (!Config.INSTANCE.saveImage) {
                        screenshotFile.delete();
                    }
                }
            }
            if (!Minecraft.f_91002_) {
                copySuccessfull = ClipboardUtil.copy(transparentImage);
            }
            MutableComponent message = null;
            if (copySuccessfull) {
                if (Config.INSTANCE.showCopyMessage) {
                    message = Component.m_237115_((String)"chatshot.image.success");
                }
            } else {
                message = Component.m_237115_((String)"chatshot.image.fail");
            }
            if (message != null) {
                client.f_91065_.m_93076_().m_93785_((Component)message);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        client.m_91385_().m_83947_(true);
    }

    private static File getScreenshotFilename(File directory) {
        File file;
        String string = Util.m_241986_();
        int i = 1;
        while ((file = new File(directory, string + (String)(i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file;
    }

    private static RenderTarget createBuffer(int width, int height) {
        TextureTarget fb = new TextureTarget(width, height, true, false);
        fb.m_83931_(0.21176471f, 0.22352941f, 0.24705882f, 0.0f);
        fb.m_83954_(false);
        return fb;
    }

    public static Image makeColorTransparent(BufferedImage im, final Color color) {
        RGBImageFilter filter = new RGBImageFilter(){
            public final int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    private static BufferedImage imageToBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bufferedImage;
    }
}

