/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.gui;

import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.gui.HudPos;
import bre2el.fpsreducer.handler.GuiOpenEventHandler;
import bre2el.fpsreducer.handler.WakeupEventHandler;
import bre2el.fpsreducer.util.GlUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class Hud {
    private String text;
    private float scaledPosX;
    private float scaledPosY;
    private int hudColor;
    private int hudIdleColor;
    private int hudGuiModeColor;
    private int hudNoActModeColor;
    private Minecraft mc = Minecraft.m_91087_();
    private Font fontRenderer;
    private boolean hovered;
    private int dragOffsetX;
    private int dragOffsetY;
    private int x1;
    private int x2;
    private int y1;
    private int y2;
    private boolean blinkState;
    private int curFPS;
    private double cpuLoad;
    private static Hud INSTANCE = new Hud();
    private String hudLine1;
    private String hudLine1Eco;
    private String hudLine1Gui;
    private String hudLine2;
    private int hudLine1OffsetX;
    private int hudLine1EcoOffsetX;
    private int hudLine1GuiOffsetX;
    private int hudLine2OffsetX;

    public Hud() {
        this.fontRenderer = this.mc.f_91062_;
    }

    public static Hud getInstance() {
        return INSTANCE;
    }

    public void setFPSCPUData(int fps, double cpuload) {
        this.curFPS = fps;
        this.cpuLoad = cpuload;
    }

    public void drawHud(GuiGraphics guiGraphics, int scaledWidth, int scaledHeight, boolean blink) {
        float scale = (float)Config.CURRENT.hudScale;
        this.updatePosition(scaledWidth, scaledHeight, scale);
        if (scale != 1.0f) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(scale, scale, 0.0f);
        }
        switch (WakeupEventHandler.INSTANCE.fpsMode) {
            case 0: {
                if (Config.CURRENT.hudInfo == 6) {
                    if (blink) {
                        boolean bl = this.blinkState = !this.blinkState;
                    }
                    if (this.blinkState) break;
                }
                guiGraphics.m_280430_(this.fontRenderer, Component.m_130674_((String)this.hudLine1Eco), (int)this.scaledPosX + this.hudLine1EcoOffsetX, (int)this.scaledPosY, this.hudIdleColor);
                break;
            }
            case 2: {
                guiGraphics.m_280430_(this.fontRenderer, Component.m_130674_((String)this.hudLine1Gui), (int)this.scaledPosX + this.hudLine1GuiOffsetX, (int)this.scaledPosY, this.hudGuiModeColor);
                break;
            }
            case 3: {
                guiGraphics.m_280430_(this.fontRenderer, Component.m_130674_((String)this.hudLine1), (int)this.scaledPosX + this.hudLine1OffsetX, (int)this.scaledPosY, this.hudNoActModeColor);
                break;
            }
            default: {
                guiGraphics.m_280430_(this.fontRenderer, Component.m_130674_((String)this.hudLine1), (int)this.scaledPosX + this.hudLine1OffsetX, (int)this.scaledPosY, this.hudColor);
            }
        }
        if (Config.CURRENT.hudInfo == 3) {
            Component component = Component.m_130674_((String)this.hudLine2);
            int n = (int)this.scaledPosX + this.hudLine2OffsetX;
            int n2 = (int)this.scaledPosY;
            Objects.requireNonNull(this.fontRenderer);
            guiGraphics.m_280430_(this.fontRenderer, component, n, n2 + 9, this.hudColor);
            if (Config.GLOBAL.debugLog) {
                String tpsText = String.valueOf(WakeupEventHandler.INSTANCE.getTps());
                Component component2 = Component.m_130674_((String)("TPS: " + tpsText));
                int n3 = (int)this.scaledPosX + this.hudLine2OffsetX;
                int n4 = (int)this.scaledPosY;
                Objects.requireNonNull(this.fontRenderer);
                guiGraphics.m_280430_(this.fontRenderer, component2, n3, n4 + 9 * 2, this.hudColor);
            }
        }
        if (scale != 1.0f) {
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public void updateBoxPosition(int screenWidth, int screenHeight) {
        int hudBoxHeight;
        float scale = (float)Config.CURRENT.hudScale;
        String hudStr = switch (Config.CURRENT.hudInfo) {
            case 1 -> "FPS: 000, CPU: 000%";
            case 2 -> "000, 000%";
            default -> "CPU: 000%";
        };
        if (Config.CURRENT.hudInfo == 3) {
            Objects.requireNonNull(this.fontRenderer);
            hudBoxHeight = 9 * 2 - 2;
        } else {
            Objects.requireNonNull(this.fontRenderer);
            hudBoxHeight = 9 - 2;
        }
        int hudBoxWidth = this.fontRenderer.m_92895_(hudStr) - 1;
        int hudBoxOffsetX = switch (Config.CURRENT.curHudPos.alignment) {
            default -> 0;
            case 1 -> -hudBoxWidth;
            case 2 -> -hudBoxWidth / 2;
        };
        this.updatePosition(screenWidth, screenHeight, scale);
        this.x1 = Math.round((this.scaledPosX + (float)hudBoxOffsetX) * scale + (float)this.dragOffsetX);
        this.x2 = Math.round((this.scaledPosX + (float)hudBoxOffsetX) * scale + (float)this.dragOffsetX + (float)hudBoxWidth * scale);
        this.y1 = Math.round(this.scaledPosY * scale + (float)this.dragOffsetY);
        this.y2 = Math.round(this.scaledPosY * scale + (float)this.dragOffsetY + (float)hudBoxHeight * scale);
    }

    public void drawHudBox(GuiGraphics guiGraphics, int screenWidth, int screenHeight, int mouseX, int mouseY, boolean dragging) {
        if (!Config.CURRENT.hudEnabled) {
            return;
        }
        this.hovered = mouseX >= this.x1 && mouseX <= this.x2 && mouseY >= this.y1 && mouseY <= this.y2;
        int color = this.hovered || dragging ? -65281 : -1;
        this.drawRectFrame(guiGraphics, this.x1, this.y1, this.x2, this.y2, color);
    }

    public void drawLineToHudBox(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        if (!Config.CURRENT.hudEnabled) {
            return;
        }
        float zLevel = 0.0f;
        float lineWidth = 0.5f;
        int alignedX = switch (Config.CURRENT.curHudPos.alignment) {
            default -> this.x1;
            case 1 -> this.x2;
            case 2 -> Math.round((float)(this.x1 + this.x2) / 2.0f);
        };
        GlUtils.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        switch (Config.CURRENT.getHudReferencePos()) {
            case 1: {
                GlUtils.drawLine3(guiGraphics, 0, 0, alignedX, this.y1, zLevel, lineWidth);
                break;
            }
            case 2: {
                GlUtils.drawLine3(guiGraphics, Math.round((float)screenWidth / 2.0f), 0, alignedX, this.y1, zLevel, lineWidth);
                break;
            }
            case 3: {
                GlUtils.drawLine3(guiGraphics, screenWidth, 0, alignedX, this.y1, zLevel, lineWidth);
                break;
            }
            case 4: {
                GlUtils.drawLine3(guiGraphics, screenWidth, Math.round((float)screenHeight / 2.0f), alignedX, Math.round((float)(this.y1 + this.y2) / 2.0f), zLevel, lineWidth);
                break;
            }
            case 5: {
                GlUtils.drawLine3(guiGraphics, screenWidth, screenHeight, alignedX, this.y2, zLevel, lineWidth);
                break;
            }
            case 6: {
                GlUtils.drawLine3(guiGraphics, Math.round((float)screenWidth / 2.0f), screenHeight, alignedX, this.y2, zLevel, lineWidth);
                break;
            }
            case 7: {
                GlUtils.drawLine3(guiGraphics, 0, screenHeight, alignedX, this.y2, zLevel, lineWidth);
                break;
            }
            case 8: {
                GlUtils.drawLine3(guiGraphics, 0, Math.round((float)screenHeight / 2.0f), alignedX, Math.round((float)(this.y1 + this.y2) / 2.0f), zLevel, lineWidth);
            }
        }
    }

    public void updateHudText() {
        this.hudColor = Config.GLOBAL.hudColor;
        this.hudIdleColor = Config.GLOBAL.hudReductionColor;
        this.hudGuiModeColor = Config.GLOBAL.hudGuiModeColor;
        this.hudNoActModeColor = Config.GLOBAL.hudNoActModeColor;
        switch (Config.CURRENT.hudInfo) {
            case 5: {
                this.hudLine1Eco = this.hudLine1 = "CPU: " + this.cpuLoadValStr(this.cpuLoad);
                this.hudLine1Gui = this.hudLine1;
                break;
            }
            case 1: {
                this.hudLine1 = Config.GLOBAL.hudPreText + this.curFPS + ", " + "CPU: " + this.cpuLoadValStr(this.cpuLoad);
                this.hudLine1Eco = Config.GLOBAL.hudReductionPreText + this.curFPS + ", " + "CPU: " + this.cpuLoadValStr(this.cpuLoad);
                this.hudLine1Gui = Config.GLOBAL.hudGuiModePreText + this.curFPS + ", " + "CPU: " + this.cpuLoadValStr(this.cpuLoad);
                break;
            }
            case 2: {
                String commonStr;
                this.hudLine1 = commonStr = "" + this.curFPS + ", " + this.cpuLoadValStr(this.cpuLoad);
                this.hudLine1Eco = commonStr;
                this.hudLine1Gui = this.hudLine1;
                break;
            }
            case 3: {
                this.hudLine2 = "CPU: " + this.cpuLoadValStr(this.cpuLoad);
            }
            case 4: {
                this.hudLine1 = Config.GLOBAL.hudPreText + this.curFPS;
                this.hudLine1Eco = Config.GLOBAL.hudReductionPreText + this.curFPS;
                this.hudLine1Gui = Config.GLOBAL.hudGuiModePreText + this.curFPS;
                break;
            }
            case 6: {
                this.hudLine1 = "";
                this.hudLine1Eco = "- ECO -";
                this.hudLine1Gui = "";
            }
        }
        this.updateAlignOffset();
    }

    private String cpuLoadValStr(double cpuload) {
        if (cpuload < 0.0) {
            return "n/a";
        }
        if (cpuload < 10.0) {
            return String.valueOf((float)((int)(cpuload * 10.0)) / 10.0f) + "%";
        }
        return String.valueOf((int)cpuload) + "%";
    }

    public void updateAlignOffset() {
        switch (Config.CURRENT.curHudPos.alignment) {
            default: {
                this.hudLine1OffsetX = 0;
                this.hudLine1EcoOffsetX = 0;
                this.hudLine1GuiOffsetX = 0;
                this.hudLine2OffsetX = 0;
                break;
            }
            case 1: {
                this.hudLine1OffsetX = -this.fontRenderer.m_92895_(this.hudLine1);
                this.hudLine1EcoOffsetX = -this.fontRenderer.m_92895_(this.hudLine1Eco);
                this.hudLine1GuiOffsetX = -this.fontRenderer.m_92895_(this.hudLine1Gui);
                if (Config.CURRENT.hudInfo != 3) break;
                this.hudLine2OffsetX = -this.fontRenderer.m_92895_(this.hudLine2);
                int minX = Math.min(this.hudLine1EcoOffsetX, this.hudLine1GuiOffsetX);
                minX = Math.min(minX, this.hudLine1OffsetX);
                this.hudLine1EcoOffsetX = this.hudLine1GuiOffsetX = (minX = Math.min(minX, this.hudLine2OffsetX));
                this.hudLine2OffsetX = this.hudLine1GuiOffsetX;
                this.hudLine1OffsetX = this.hudLine1GuiOffsetX;
                break;
            }
            case 2: {
                this.hudLine1OffsetX = -this.fontRenderer.m_92895_(this.hudLine1) / 2;
                this.hudLine1EcoOffsetX = -this.fontRenderer.m_92895_(this.hudLine1Eco) / 2;
                this.hudLine1GuiOffsetX = -this.fontRenderer.m_92895_(this.hudLine1Gui) / 2;
                if (Config.CURRENT.hudInfo != 3) break;
                this.hudLine2OffsetX = -this.fontRenderer.m_92895_(this.hudLine2) / 2;
                int minX = Math.min(this.hudLine1EcoOffsetX, this.hudLine1GuiOffsetX);
                minX = Math.min(minX, this.hudLine1OffsetX);
                this.hudLine1EcoOffsetX = this.hudLine1GuiOffsetX = (minX = Math.min(minX, this.hudLine2OffsetX));
                this.hudLine2OffsetX = this.hudLine1GuiOffsetX;
                this.hudLine1OffsetX = this.hudLine1GuiOffsetX;
            }
        }
    }

    public void update() {
        this.updateHudText();
        this.updateAlignOffset();
    }

    private void updatePosition(int screenWidth, int screenHeight, float scale) {
        int boxHeight;
        HudPos hudPos = Config.CURRENT.curHudPos;
        if (Config.CURRENT.hudInfo == 3) {
            Objects.requireNonNull(this.fontRenderer);
            boxHeight = 9 * 2;
        } else {
            Objects.requireNonNull(this.fontRenderer);
            boxHeight = 9;
        }
        block0 : switch (Config.CURRENT.getHudReferencePos()) {
            case 1: {
                this.scaledPosX = (float)hudPos.offsetX / scale;
                this.scaledPosY = (float)hudPos.offsetY / scale;
                break;
            }
            case 2: {
                this.scaledPosX = (float)(screenWidth / 2 + hudPos.offsetX) / scale;
                this.scaledPosY = (float)hudPos.offsetY / scale;
                break;
            }
            case 3: {
                this.scaledPosX = (float)(screenWidth + hudPos.offsetX) / scale;
                this.scaledPosY = (float)hudPos.offsetY / scale;
                break;
            }
            case 4: {
                this.scaledPosX = (float)(screenWidth + hudPos.offsetX) / scale;
                this.scaledPosY = (float)(screenHeight / 2 + hudPos.offsetY) / scale - (float)(boxHeight / 2);
                break;
            }
            case 5: {
                this.scaledPosX = (float)(screenWidth + hudPos.offsetX) / scale;
                this.scaledPosY = (float)(screenHeight + hudPos.offsetY) / scale - (float)(boxHeight - 1);
                break;
            }
            case 6: {
                this.scaledPosX = (float)(screenWidth / 2 + hudPos.offsetX) / scale;
                this.scaledPosY = (float)(screenHeight + hudPos.offsetY) / scale - (float)(boxHeight - 1);
                break;
            }
            case 7: {
                float dodgeY;
                this.scaledPosX = (float)hudPos.offsetX / scale;
                this.scaledPosY = (float)(screenHeight + hudPos.offsetY) / scale - (float)(boxHeight - 1);
                if (!GuiOpenEventHandler.guiChatOpened || !(this.scaledPosY > (dodgeY = (float)(screenHeight - 15) / scale - (float)(boxHeight - 1)))) break;
                switch (Config.CURRENT.hudBehindChatBox) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        this.scaledPosY = dodgeY;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                this.scaledPosX = (float)hudPos.offsetX / scale;
                this.scaledPosY = (float)(screenHeight / 2 + hudPos.offsetY) / scale - (float)(boxHeight / 2);
                break;
            }
        }
    }

    private void drawRectFrame(GuiGraphics guiGraphics, int posX1, int posY1, int posX2, int posY2, int color) {
        guiGraphics.m_280656_(posX1, posX2, posY1, color);
        guiGraphics.m_280656_(posX1, posX2, posY2, color);
        guiGraphics.m_280315_(posX1, posY1, posY2, color);
        guiGraphics.m_280315_(posX2, posY1, posY2, color);
    }

    public int getPosX() {
        return this.x1;
    }

    public int getPosY() {
        return this.y1;
    }

    public void setPos(int x, int y) {
        this.scaledPosX = x;
        this.scaledPosY = y;
    }

    public void setDragOffset(int x, int y) {
        this.dragOffsetX = x;
        this.dragOffsetY = y;
    }

    public int getBoxPosX() {
        return Config.CURRENT.curHudPos.offsetX + this.dragOffsetX;
    }

    public int getBoxPosY() {
        return Config.CURRENT.curHudPos.offsetY + this.dragOffsetY;
    }

    public boolean isMouseOver() {
        return this.hovered;
    }
}

