/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.JadeCommonConfig;
import snownee.jade.addon.universal.ItemCollector;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.api.Accessor;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.command.JadeServerCommand;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.network.ReceiveDataPacket;
import snownee.jade.network.RequestEntityPacket;
import snownee.jade.network.RequestTilePacket;
import snownee.jade.network.ServerPingPacket;
import snownee.jade.network.ShowOverlayPacket;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.JadeForgeUtils;
import snownee.jade.util.WailaExceptionHandler;

@Mod(value="jade")
public final class CommonProxy {
    public static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("jade", "networking")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "2").simpleChannel();
    public static final Set<ResourceLocation> BLOCKED_UIDS = Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("bluepower:machines"), new ResourceLocation("bluepower:parts")});

    public CommonProxy() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        FMLJavaModLoadingContext.get().getModEventBus().register(JadeCommonConfig.class);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.addListener(CommonProxy::playerJoin);
        MinecraftForge.EVENT_BUS.addListener(CommonProxy::registerServerCommand);
        if (CommonProxy.isPhysicallyClient()) {
            ClientProxy.init();
        }
    }

    public static int showOrHideFromServer(Collection<ServerPlayer> players, boolean show) {
        ShowOverlayPacket msg = new ShowOverlayPacket(show);
        for (ServerPlayer player : players) {
            NETWORK.sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        return players.size();
    }

    public static boolean isBlockedUid(IJadeProvider provider) {
        try {
            return BLOCKED_UIDS.contains(provider.getUid());
        }
        catch (Throwable e) {
            return true;
        }
    }

    public static boolean isMultipartEntity(Entity target) {
        return target.isMultipartEntity();
    }

    public static Entity wrapPartEntityParent(Entity target) {
        if (target instanceof PartEntity) {
            PartEntity part = (PartEntity)target;
            return part.getParent();
        }
        return target;
    }

    public static int getPartEntityIndex(Entity entity) {
        if (!(entity instanceof PartEntity)) {
            return -1;
        }
        PartEntity part = (PartEntity)entity;
        Entity parent = CommonProxy.wrapPartEntityParent(entity);
        PartEntity[] parts = parent.getParts();
        if (parts == null) {
            return -1;
        }
        return List.of(parts).indexOf(part);
    }

    public static Entity getPartEntity(Entity parent, int index) {
        if (parent == null) {
            return null;
        }
        if (index < 0) {
            return parent;
        }
        PartEntity[] parts = parent.getParts();
        if (parts == null || index >= parts.length) {
            return parent;
        }
        return parts[index];
    }

    private void setup(FMLCommonSetupEvent event) {
        NETWORK.registerMessage(0, ReceiveDataPacket.class, ReceiveDataPacket::write, ReceiveDataPacket::read, ReceiveDataPacket.Handler::onMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        NETWORK.registerMessage(1, ServerPingPacket.class, ServerPingPacket::write, ServerPingPacket::read, ServerPingPacket.Handler::onMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        NETWORK.registerMessage(2, RequestEntityPacket.class, RequestEntityPacket::write, RequestEntityPacket::read, RequestEntityPacket.Handler::onMessage, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        NETWORK.registerMessage(3, RequestTilePacket.class, RequestTilePacket::write, RequestTilePacket::read, RequestTilePacket.Handler::onMessage, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        NETWORK.registerMessage(4, ShowOverlayPacket.class, ShowOverlayPacket::write, ShowOverlayPacket::read, ShowOverlayPacket.Handler::onMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        List<String> classNames = ModList.get().getAllScanData().stream().flatMap($ -> $.getAnnotations().stream()).filter($ -> {
            if ($.annotationType().getClassName().equals(WailaPlugin.class.getName())) {
                String required = $.annotationData().getOrDefault("value", "");
                return required.isEmpty() || ModList.get().isLoaded(required);
            }
            return false;
        }).map(ModFileScanData.AnnotationData::memberName).toList();
        for (String className : classNames) {
            Jade.LOGGER.info("Start loading plugin at {}", (Object)className);
            try {
                Class<?> clazz = Class.forName(className);
                if (!IWailaPlugin.class.isAssignableFrom(clazz)) continue;
                IWailaPlugin plugin = (IWailaPlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                plugin.register(WailaCommonRegistration.INSTANCE);
                if (!CommonProxy.isPhysicallyClient()) continue;
                plugin.registerClient(WailaClientRegistration.INSTANCE);
            }
            catch (Throwable e) {
                Jade.LOGGER.error("Error loading plugin at %s".formatted(className), e);
                Throwables.throwIfInstanceOf((Throwable)e, IllegalStateException.class);
                if (!className.startsWith("snownee.jade.")) continue;
                throw new RuntimeException(e);
            }
        }
        Jade.loadComplete();
    }

    private static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Jade.LOGGER.info("Syncing config to {} ({})", (Object)event.getEntity().m_36316_().getName(), (Object)event.getEntity().m_36316_().getId());
        NETWORK.sendTo((Object)new ServerPingPacket(PluginConfig.INSTANCE), ((ServerPlayer)event.getEntity()).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Nullable
    public static String getLastKnownUsername(UUID uuid) {
        return UsernameCache.getLastKnownUsername((UUID)uuid);
    }

    public static File getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    public static boolean isShears(ItemStack tool) {
        return tool.m_204117_(Tags.Items.SHEARS);
    }

    public static boolean isShearable(BlockState state) {
        return state.m_60734_() instanceof IForgeShearable;
    }

    public static boolean isCorrectToolForDrops(BlockState state, Player player) {
        return ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player);
    }

    public static String getModIdFromItem(ItemStack stack) {
        ResourceLocation id;
        String s;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("id") && (s = stack.m_41783_().m_128461_("id")).contains(":") && (id = ResourceLocation.m_135820_((String)s)) != null) {
            return id.m_135827_();
        }
        return stack.m_41720_().getCreatorModId(stack);
    }

    public static boolean isPhysicallyClient() {
        return FMLEnvironment.dist.isClient();
    }

    private static void registerServerCommand(RegisterCommandsEvent event) {
        JadeServerCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static ItemCollector<?> createItemCollector(Object target, Cache<Object, ItemCollector<?>> containerCache) {
        if (target instanceof CapabilityProvider) {
            CapabilityProvider capProvider = (CapabilityProvider)target;
            if (!(target instanceof Entity) || target instanceof AbstractChestedHorse) {
                try {
                    IItemHandler itemHandler = (IItemHandler)capProvider.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
                    if (itemHandler != null) {
                        return (ItemCollector)containerCache.get((Object)itemHandler, () -> new ItemCollector<IItemHandler>(JadeForgeUtils.fromItemHandler(itemHandler, target instanceof AbstractChestedHorse ? 2 : 0)));
                    }
                }
                catch (Throwable e) {
                    WailaExceptionHandler.handleErr(e, null, null, null);
                }
            }
        }
        if (target instanceof Container) {
            if (target instanceof ChestBlockEntity) {
                return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(o -> {
                    if (o instanceof ChestBlockEntity) {
                        ChestBlock chestBlock;
                        Container compound;
                        ChestBlockEntity be = (ChestBlockEntity)o;
                        Block patt11846$temp = be.m_58900_().m_60734_();
                        if (patt11846$temp instanceof ChestBlock && (compound = ChestBlock.m_51511_((ChestBlock)(chestBlock = (ChestBlock)patt11846$temp), (BlockState)be.m_58900_(), (Level)be.m_58904_(), (BlockPos)be.m_58899_(), (boolean)false)) != null) {
                            return compound;
                        }
                        return be;
                    }
                    return null;
                }, 0));
            }
            return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(0));
        }
        return ItemCollector.EMPTY;
    }

    @Nullable
    public static List<ViewGroup<ItemStack>> containerGroup(Container container, Accessor<?> accessor) {
        try {
            return ((ItemCollector)ItemStorageProvider.INSTANCE.containerCache.get((Object)container, () -> new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(0)))).update(container, accessor.getLevel().m_46467_());
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Nullable
    public static List<ViewGroup<ItemStack>> storageGroup(Object storage, Accessor<?> accessor) {
        try {
            return ((ItemCollector)ItemStorageProvider.INSTANCE.containerCache.get(storage, () -> new ItemCollector<IItemHandler>(JadeForgeUtils.fromItemHandler((IItemHandler)storage, 0)))).update(storage, accessor.getLevel().m_46467_());
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static List<ViewGroup<CompoundTag>> wrapFluidStorage(Object target, @Nullable Player player) {
        CapabilityProvider capProvider;
        IFluidHandler fluidHandler;
        if (target instanceof CapabilityProvider && (fluidHandler = (IFluidHandler)(capProvider = (CapabilityProvider)target).getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null)) != null) {
            return JadeForgeUtils.fromFluidHandler(fluidHandler);
        }
        return null;
    }

    public static List<ViewGroup<CompoundTag>> wrapEnergyStorage(Object target, @Nullable Player player) {
        CapabilityProvider capProvider;
        IEnergyStorage storage;
        if (target instanceof CapabilityProvider && (storage = (IEnergyStorage)(capProvider = (CapabilityProvider)target).getCapability(ForgeCapabilities.ENERGY).orElse(null)) != null && storage.getMaxEnergyStored() > 0) {
            ViewGroup<CompoundTag> group = new ViewGroup<CompoundTag>(List.of(EnergyView.of(storage.getEnergyStored(), storage.getMaxEnergyStored())));
            group.getExtraData().m_128359_("Unit", "FE");
            return List.of(group);
        }
        return null;
    }

    public static boolean isDevEnv() {
        return !FMLEnvironment.production;
    }

    public static float getEnchantPowerBonus(BlockState state, Level world, BlockPos pos) {
        return state.getEnchantPowerBonus((LevelReader)world, pos);
    }

    public static ResourceLocation getId(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block);
    }

    public static ResourceLocation getId(EntityType<?> entityType) {
        return BuiltInRegistries.f_256780_.m_7981_(entityType);
    }

    public static ResourceLocation getId(BlockEntityType<?> blockEntityType) {
        return BuiltInRegistries.f_257049_.m_7981_(blockEntityType);
    }

    public static ResourceLocation getId(PaintingVariant motive) {
        return BuiltInRegistries.f_257051_.m_7981_((Object)motive);
    }

    public static String getPlatformIdentifier() {
        return "forge";
    }

    public static MutableComponent getProfressionName(VillagerProfession profession) {
        ResourceLocation profName = ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)profession);
        return Component.m_237115_((String)(EntityType.f_20492_.m_20675_() + "." + (String)(!"minecraft".equals(profName.m_135827_()) ? profName.m_135827_() + "." : "") + profName.m_135815_()));
    }

    public static boolean isBoss(Entity entity) {
        EntityType entityType = entity.m_6095_();
        return entityType.m_204039_(Tags.EntityTypes.BOSSES) || entityType == EntityType.f_20565_ || entityType == EntityType.f_20496_;
    }

    public static boolean isModLoaded(String modid) {
        try {
            return ModList.get().isLoaded(modid);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static ItemStack getBlockPickedResult(BlockState state, Player player, BlockHitResult hitResult) {
        return state.getCloneItemStack((HitResult)hitResult, (BlockGetter)player.m_9236_(), hitResult.m_82425_(), player);
    }

    public static ItemStack getEntityPickedResult(Entity entity, Player player, EntityHitResult hitResult) {
        return entity.getPickedResult((HitResult)hitResult);
    }

    public static Component getFluidName(JadeFluidObject fluid) {
        return CommonProxy.toFluidStack(fluid).getDisplayName();
    }

    public static FluidStack toFluidStack(JadeFluidObject fluid) {
        return new FluidStack(fluid.getType(), (int)fluid.getAmount(), fluid.getTag());
    }

    public static Void handleNetworkingError(Throwable e) {
        Jade.LOGGER.error("Error receiving packet", e);
        return null;
    }
}

