/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.gui.GuiBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockUtils {
    @Nullable
    public static DirectionProperty getFirstDirectionProperty(BlockState state) {
        for (Property prop : state.m_61147_()) {
            if (!(prop instanceof DirectionProperty)) continue;
            return (DirectionProperty)prop;
        }
        return null;
    }

    @Nullable
    public static Direction getFirstPropertyFacingValue(BlockState state) {
        DirectionProperty prop = BlockUtils.getFirstDirectionProperty(state);
        return prop != null ? (Direction)state.m_61143_((Property)prop) : null;
    }

    public static List<String> getFormattedBlockStateProperties(BlockState state) {
        return BlockUtils.getFormattedBlockStateProperties(state, ": ");
    }

    public static List<String> getFormattedBlockStateProperties(BlockState state, String separator) {
        Collection properties = state.m_61147_();
        if (properties.size() > 0) {
            ArrayList<String> lines = new ArrayList<String>();
            for (Property prop : properties) {
                Comparable val = state.m_61143_(prop);
                if (prop instanceof BooleanProperty) {
                    String pre = val.equals(Boolean.TRUE) ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
                    lines.add(prop.m_61708_() + separator + pre + val.toString());
                    continue;
                }
                if (prop instanceof DirectionProperty) {
                    lines.add(prop.m_61708_() + separator + GuiBase.TXT_GOLD + val.toString());
                    continue;
                }
                if (prop instanceof IntegerProperty) {
                    lines.add(prop.m_61708_() + separator + GuiBase.TXT_AQUA + val.toString());
                    continue;
                }
                lines.add(prop.m_61708_() + separator + val.toString());
            }
            return lines;
        }
        return Collections.emptyList();
    }
}

