/*
 * Decompiled with CFR 0.152.
 */
package com.haruhakugit.mythical.utility.common.block;

import com.haruhakugit.mythical.utility.common.blockentity.BlockEntitiesRegistry;
import com.haruhakugit.mythical.utility.common.blockentity.ParticleBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ParticleBlock
extends Block
implements EntityBlock {
    public ParticleBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(-1.0f, 3600000.0f).m_222994_().m_60955_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntitiesRegistry.PARTICLE_BLOCK_ENTITY.get()).m_155264_(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return super.m_5940_(state, world, pos, context);
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity;
        super.m_214162_(state, world, pos, random);
        if (world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof ParticleBlockEntity) {
            ParticleBlockEntity particleBlockEntity = (ParticleBlockEntity)blockEntity;
            int particleCount = particleBlockEntity.getParticleCount();
            String particleTypeKey = particleBlockEntity.getParticleTypeKey();
            int startX = particleBlockEntity.getStartPos().m_123341_();
            int startY = particleBlockEntity.getStartPos().m_123342_();
            int startZ = particleBlockEntity.getStartPos().m_123343_();
            int endX = particleBlockEntity.getEndPos().m_123341_();
            int endY = particleBlockEntity.getEndPos().m_123342_();
            int endZ = particleBlockEntity.getEndPos().m_123343_();
            int minX = Math.min(startX, endX);
            int maxX = Math.max(startX, endX);
            int minY = Math.min(startY, endY);
            int maxY = Math.max(startY, endY);
            int minZ = Math.min(startZ, endZ);
            int maxZ = Math.max(startZ, endZ);
            ParticleType particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(particleTypeKey));
            if (particleType != null) {
                int areaSize = (maxX - minX + 1) * (maxY - minY + 1) * (maxZ - minZ + 1);
                if (areaSize == 0) {
                    return;
                }
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            for (int i = 0; i < particleCount; ++i) {
                                double posX = (double)x + random.m_188500_();
                                double posY = (double)y + random.m_188500_();
                                double posZ = (double)z + random.m_188500_();
                                try {
                                    world.m_7106_((ParticleOptions)particleType, posX, posY, posZ, 0.0, 0.1, 0.0);
                                    continue;
                                }
                                catch (Exception exception) {
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

