/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.world.entity.boats.BWGBoatEntity;
import net.potionstudios.biomeswevegone.world.entity.boats.BWGChestBoatEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class BWGBoatRenderer
extends EntityRenderer<Boat> {
    private final Map<BWGBoatEntity.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources;

    public BWGBoatRenderer(EntityRendererProvider.Context context, boolean chestBoat) {
        super(context);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(BWGBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)BiomesWeveGone.id(BWGBoatRenderer.getTextureLocation(type, chestBoat)), this.createBoatModel(context, (BWGBoatEntity.Type)((Object)type), chestBoat))));
    }

    public void render(Boat boat, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        float f2;
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.375f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        float f = (float)boat.m_38385_() - partialTicks;
        float f1 = boat.m_38384_() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)boat.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = boat.m_38352_(partialTicks)), (float)0.0f)) {
            poseStack.m_252781_(new Quaternionf().setAngleAxis(boat.m_38352_(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<Boat>> pair = this.getModelWithLocation(boat);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        ListModel listmodel = (ListModel)pair.getSecond();
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        listmodel.m_6973_((Entity)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.m_6299_(listmodel.m_103119_(resourcelocation));
        listmodel.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.m_5842_()) {
            VertexConsumer vertexconsumer1 = buffer.m_6299_(RenderType.m_110478_());
            if (listmodel instanceof WaterPatchModel) {
                WaterPatchModel waterpatchmodel = (WaterPatchModel)listmodel;
                waterpatchmodel.m_102282_().m_104301_(poseStack, vertexconsumer1, packedLight, OverlayTexture.f_118083_);
            }
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)boat, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private static String getTextureLocation(BWGBoatEntity.Type pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context pContext, BWGBoatEntity.Type pType, boolean pChestBoat) {
        ModelLayerLocation modellayerlocation = pChestBoat ? BWGBoatRenderer.createChestBoatModelName(pType) : BWGBoatRenderer.createBoatModelName(pType);
        ModelPart modelpart = pContext.m_174023_(modellayerlocation);
        return pChestBoat ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    private static ModelLayerLocation createLocation(String pPath) {
        return new ModelLayerLocation(BiomesWeveGone.id(pPath), "main");
    }

    public static ModelLayerLocation createBoatModelName(BWGBoatEntity.Type pType) {
        return BWGBoatRenderer.createLocation("boat/" + pType.getName());
    }

    public static ModelLayerLocation createChestBoatModelName(BWGBoatEntity.Type pType) {
        return BWGBoatRenderer.createLocation("chest_boat/" + pType.getName());
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        if (boat instanceof BWGBoatEntity) {
            BWGBoatEntity boatEntity = (BWGBoatEntity)boat;
            return this.boatResources.get((Object)boatEntity.getModVariant());
        }
        if (boat instanceof BWGChestBoatEntity) {
            BWGChestBoatEntity chestBoatEntity = (BWGChestBoatEntity)boat;
            return this.boatResources.get((Object)chestBoatEntity.getModVariant());
        }
        return null;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Boat entity) {
        return (ResourceLocation)this.getModelWithLocation(entity).getFirst();
    }
}

