/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.forge;

import com.google.auto.service.AutoService;
import com.mojang.datafixers.DSL;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.forge.world.level.block.BWGFarmLandBlock;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;
import org.jetbrains.annotations.NotNull;

@AutoService(value={PlatformHandler.class})
public class ForgePlatformHandler
implements PlatformHandler {
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"biomeswevegone");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"biomeswevegone");
    private static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"biomeswevegone");
    public static final Map<ResourceKey<?>, DeferredRegister> CACHED = new Reference2ObjectOpenHashMap();

    @Override
    public PlatformHandler.Platform getPlatform() {
        return PlatformHandler.Platform.FORGE;
    }

    @Override
    public Path configPath() {
        return FMLPaths.CONFIGDIR.get().resolve("biomeswevegone");
    }

    @Override
    public <E extends Entity> Supplier<EntityType<E>> registerEntity(String id, EntityType.EntityFactory<E> factory, MobCategory category, float width, float height) {
        return ENTITY_TYPES.register(id, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)category).m_20699_(width, height).m_20712_(BiomesWeveGone.id(id).toString()));
    }

    @Override
    public <E extends Entity> Supplier<EntityType<E>> registerEntity(String id, EntityType.EntityFactory<E> factory, MobCategory category, float width, float height, int trackingRange) {
        return ENTITY_TYPES.register(id, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)category).m_20699_(width, height).m_20702_(trackingRange).m_20712_(BiomesWeveGone.id(id).toString()));
    }

    @Override
    public <T extends BlockEntity> Supplier<BlockEntityType<T>> registerBlockEntity(String key, Supplier<BlockEntityType.Builder<T>> builder) {
        return BLOCK_ENTITIES.register(key, () -> ((BlockEntityType.Builder)builder.get()).m_58966_(Util.m_137456_((DSL.TypeReference)References.f_16781_, (String)key)));
    }

    @Override
    public Supplier<SpawnEggItem> createSpawnEgg(Supplier<EntityType<? extends Mob>> entity, int backgroundColor, int highlightColor) {
        return () -> new ForgeSpawnEggItem(entity, backgroundColor, highlightColor, new Item.Properties());
    }

    @Override
    public Supplier<FlowerPotBlock> createPottedBlock(Supplier<? extends Block> block) {
        return () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, block, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_));
    }

    @Override
    public Supplier<MobBucketItem> createMobBucket(Supplier<EntityType<? extends Mob>> entity, Supplier<Fluid> fluid, Supplier<SoundEvent> sound) {
        return () -> new MobBucketItem(entity, fluid, sound, new Item.Properties().m_41487_(1));
    }

    @Override
    public Supplier<RecordItem> createRecordItem(int comparatorValue, Supplier<SoundEvent> sound, int lengthInSeconds) {
        return () -> new RecordItem(comparatorValue, sound, new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE), lengthInSeconds * 20);
    }

    @Override
    public Supplier<net.potionstudios.biomeswevegone.world.level.block.custom.BWGFarmLandBlock> bwgFarmLandBlock(Supplier<Block> dirt) {
        return () -> new BWGFarmLandBlock(dirt);
    }

    @Override
    public WoodType createWoodType(String id, @NotNull BlockSetType setType) {
        return WoodType.m_61844_((WoodType)new WoodType("biomeswevegone:" + id, setType));
    }

    @Override
    public Supplier<SimpleParticleType> registerCreateParticle(String name) {
        return PARTICLES.register(name, () -> new SimpleParticleType(false));
    }

    @Override
    @SafeVarargs
    public final Supplier<CreativeModeTab> createCreativeTab(String name, Supplier<ItemStack> icon, ArrayList<Supplier<? extends Item>> ... items) {
        return this.register(BuiltInRegistries.f_279662_, name, () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)("itemGroup.biomeswevegone." + name))).m_257737_(icon).m_257501_((context, entries) -> {
            for (ArrayList item : items) {
                item.forEach(item1 -> entries.m_246326_((ItemLike)item1.get()));
            }
        }).withSearchBar().m_257652_());
    }

    @Override
    public <T> Supplier<T> register(Registry<? super T> registry, String name, Supplier<T> value) {
        return CACHED.computeIfAbsent(registry.m_123023_(), key -> DeferredRegister.create((ResourceLocation)registry.m_123023_().m_135782_(), (String)"biomeswevegone")).register(name, value);
    }

    @Override
    public <T> Supplier<Holder.Reference<T>> registerForHolder(Registry<T> registry, String name, Supplier<T> value) {
        RegistryObject registryObject = CACHED.computeIfAbsent(registry.m_123023_(), key -> DeferredRegister.create((ResourceLocation)registry.m_123023_().m_135782_(), (String)"biomeswevegone")).register(name, value);
        return () -> (Holder.Reference)registryObject.getHolder().get();
    }

    public static void registerPottedPlants() {
        BWGBlocks.BLOCKS.forEach((Consumer<Supplier<? extends Block>>)((Consumer<Supplier>)entry -> {
            if (entry.get() instanceof FlowerPotBlock) {
                ((FlowerPotBlock)Blocks.f_50276_).addPlant(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((FlowerPotBlock)entry.get()).m_53560_())), entry);
            }
        }));
        BWGWood.WOOD.forEach((Consumer<Supplier<? extends Block>>)((Consumer<Supplier>)entry -> {
            if (entry.get() instanceof FlowerPotBlock) {
                ((FlowerPotBlock)Blocks.f_50276_).addPlant(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((FlowerPotBlock)entry.get()).m_53560_())), entry);
            }
        }));
    }

    public static void register(IEventBus bus) {
        ENTITY_TYPES.register(bus);
        PARTICLES.register(bus);
        CACHED.values().forEach(deferredRegister -> deferredRegister.register(bus));
        BLOCK_ENTITIES.register(bus);
    }
}

