/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.boats;

import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.potionstudios.biomeswevegone.world.entity.BWGEntities;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWoodSet;
import org.jetbrains.annotations.NotNull;

public class BWGBoatEntity
extends Boat {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.m_135353_(BWGBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BWGBoatEntity(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
    }

    public BWGBoatEntity(Level level, double x, double y, double z) {
        this(BWGEntities.BWG_BOAT.get(), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    @NotNull
    public Item m_38369_() {
        return this.getModVariant().getBoatItem().get();
    }

    public void setVariant(Type pVariant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)pVariant.ordinal());
    }

    public Type getModVariant() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_ID_TYPE));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE, (Object)Type.ASPEN.ordinal());
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128359_("Type", this.getModVariant().m_7912_());
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128425_("Type", 8)) {
            this.setVariant(Type.byName(pCompound.m_128461_("Type")));
        }
    }

    public static enum Type implements StringRepresentable
    {
        ASPEN(() -> BWGWood.ASPEN, "aspen"),
        BAOBAB(() -> BWGWood.BAOBAB, "baobab"),
        CHERRY(() -> BWGWood.BLUE_ENCHANTED, "blue_enchanted"),
        CIKA(() -> BWGWood.CIKA, "cika"),
        CYPRESS(() -> BWGWood.CYPRESS, "cypress"),
        EBONY(() -> BWGWood.EBONY, "ebony"),
        FIR(() -> BWGWood.FIR, "fir"),
        FLORUS(() -> BWGWood.FLORUS, "florus"),
        GREEN_ENCHANTED(() -> BWGWood.GREEN_ENCHANTED, "green_enchanted"),
        HOLLY(() -> BWGWood.HOLLY, "holly"),
        IRONWOOD(() -> BWGWood.IRONWOOD, "ironwood"),
        JACARANDA(() -> BWGWood.JACARANDA, "jacaranda"),
        MAHOGANY(() -> BWGWood.MAHOGANY, "mahogany"),
        MAPLE(() -> BWGWood.MAPLE, "maple"),
        PALM(() -> BWGWood.PALM, "palm"),
        PINE(() -> BWGWood.PINE, "pine"),
        RAINBOW_EUCALYPTUS(() -> BWGWood.RAINBOW_EUCALYPTUS, "rainbow_eucalyptus"),
        REDWOOD(() -> BWGWood.REDWOOD, "redwood"),
        SAKURA(() -> BWGWood.SAKURA, "sakura"),
        SKYRIS(() -> BWGWood.SKYRIS, "skyris"),
        WHITE_MANGROVE(() -> BWGWood.WHITE_MANGROVE, "white_mangrove"),
        WILLOW(() -> BWGWood.WILLOW, "willow"),
        WITCH_HAZEL(() -> BWGWood.WITCH_HAZEL, "witch_hazel"),
        ZELKOVA(() -> BWGWood.ZELKOVA, "zelkova");

        private final Supplier<BWGWoodSet> woodSet;
        private final String name;
        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;

        private Type(Supplier<BWGWoodSet> woodSet, String name) {
            this.woodSet = woodSet;
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.getName();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.woodSet.get().name();
        }

        public Supplier<Item> getBoatItem() {
            return this.woodSet.get().boatItem();
        }

        public Supplier<Item> getChestBoatItem() {
            return this.woodSet.get().chestBoatItem();
        }

        public static Type byId(int id) {
            return BY_ID.apply(id);
        }

        public static Type byName(String name) {
            return (Type)CODEC.m_262792_(name, (Enum)ASPEN);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
            BY_ID = ByIdMap.m_262839_(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

