/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.biome.modifiers;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed.BWGOverworldTreePlacedFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed.BWGVanillaPlacedFeatures;

public class BWGBiomeModifiers {
    public static final Map<ResourceLocation, BWGBiomeModifier> BIOME_MODIFIERS_FACTORIES = new Reference2ObjectOpenHashMap();

    @SafeVarargs
    private static void registerModifierVegetalDecoration(String id, ResourceKey<PlacedFeature> feature, ResourceKey<Biome> ... biomes) {
        BIOME_MODIFIERS_FACTORIES.put(BiomesWeveGone.id(id), new BWGBiomeModifier(feature, GenerationStep.Decoration.VEGETAL_DECORATION, biomes));
    }

    public static void init() {
        BiomesWeveGone.LOGGER.info("Creating and Registering BWG Biome Modifiers for Vanilla Biomes");
        BWGBiomeModifiers.registerModifierVegetalDecoration("vanilla/flower_default", BWGVanillaPlacedFeatures.FLOWER_DEFAULT, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_48203_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186768_, Biomes.f_48205_, Biomes.f_186762_, Biomes.f_48149_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_48151_);
        BWGBiomeModifiers.registerModifierVegetalDecoration("vanilla/flower_warm", BWGVanillaPlacedFeatures.FLOWER_WARM, Biomes.f_186769_, Biomes.f_48222_, Biomes.f_48197_, Biomes.f_48157_, Biomes.f_48158_);
        BWGBiomeModifiers.registerModifierVegetalDecoration("vanilla/flower_plains", BWGVanillaPlacedFeatures.FLOWER_PLAINS, Biomes.f_48202_, Biomes.f_48176_);
        BWGBiomeModifiers.registerModifierVegetalDecoration("vanilla/forest_flowers", BWGVanillaPlacedFeatures.FOREST_FLOWERS, Biomes.f_48205_, Biomes.f_48151_);
        BWGBiomeModifiers.registerModifierVegetalDecoration("vanilla/beach/palm_trees", BWGOverworldTreePlacedFeatures.PALM_TREES, Biomes.f_48217_);
    }

    public record BWGBiomeModifier(ResourceKey<PlacedFeature> feature, GenerationStep.Decoration step, ResourceKey<Biome>[] biomes) {
    }
}

