/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.item.gem.bonus;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.tooltip.TooltipHelper;
import daripher.skilltree.data.serializers.SerializationHelper;
import daripher.skilltree.entity.player.PlayerExtension;
import daripher.skilltree.init.PSTGemBonuses;
import daripher.skilltree.item.ItemHelper;
import daripher.skilltree.item.gem.GemItem;
import daripher.skilltree.item.gem.bonus.GemBonusProvider;
import daripher.skilltree.network.NetworkHelper;
import daripher.skilltree.skill.bonus.item.ItemBonus;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class RandomGemBonusProvider
implements GemBonusProvider {
    private final List<GemBonusProvider> bonuses;

    public RandomGemBonusProvider(List<GemBonusProvider> bonuses) {
        this.bonuses = bonuses;
    }

    @Override
    @Nullable
    public ItemBonus<?> getBonus(Player player, ItemStack itemStack, ItemStack gemStack) {
        int randomSeed = ((PlayerExtension)player).getGemsRandomSeed();
        Random random = new Random(randomSeed);
        GemBonusProvider provider = this.bonuses.get(random.nextInt(this.bonuses.size()));
        return provider.getBonus(player, itemStack, gemStack);
    }

    @Override
    public boolean canApply(Player player, ItemStack itemStack, ItemStack gemStack) {
        int socket = ItemHelper.getFirstEmptySocket(itemStack, player);
        if (GemItem.hasGem(itemStack, socket)) {
            return false;
        }
        return this.getBonus(player, itemStack, gemStack) != null;
    }

    @Override
    public MutableComponent getTooltip(ItemStack gemStack) {
        MutableComponent tooltip = Component.m_237115_((String)"gem_bonus.random");
        return tooltip.m_130948_(TooltipHelper.getSkillBonusStyle(true));
    }

    @Override
    public GemBonusProvider.Serializer getSerializer() {
        return (GemBonusProvider.Serializer)PSTGemBonuses.RANDOM.get();
    }

    public static class Serializer
    implements GemBonusProvider.Serializer {
        @Override
        public GemBonusProvider deserialize(JsonObject json) throws JsonParseException {
            List<GemBonusProvider> bonuses = SerializationHelper.deserializeObjects(json, "bonuses", SerializationHelper::deserializeGemBonusProvider);
            return new RandomGemBonusProvider(bonuses);
        }

        @Override
        public void serialize(JsonObject json, GemBonusProvider provider) {
            if (!(provider instanceof RandomGemBonusProvider)) {
                throw new IllegalArgumentException();
            }
            RandomGemBonusProvider aProvider = (RandomGemBonusProvider)provider;
            SerializationHelper.serializeObjects(json, "bonuses", aProvider.bonuses, SerializationHelper::serializeGemBonusProvider);
        }

        @Override
        public GemBonusProvider deserialize(CompoundTag tag) {
            List<GemBonusProvider> bonuses = SerializationHelper.deserializeObjects(tag, "bonuses", SerializationHelper::deserializeGemBonusProvider);
            return new RandomGemBonusProvider(bonuses);
        }

        @Override
        public CompoundTag serialize(GemBonusProvider provider) {
            if (!(provider instanceof RandomGemBonusProvider)) {
                throw new IllegalArgumentException();
            }
            RandomGemBonusProvider aProvider = (RandomGemBonusProvider)provider;
            CompoundTag tag = new CompoundTag();
            SerializationHelper.serializeObjects(tag, "bonuses", aProvider.bonuses, SerializationHelper::serializeGemBonusProvider);
            return tag;
        }

        @Override
        public GemBonusProvider deserialize(FriendlyByteBuf buf) {
            ArrayList<GemBonusProvider> bonuses = new ArrayList<GemBonusProvider>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                bonuses.add(NetworkHelper.readGemBonusProvider(buf));
            }
            return new RandomGemBonusProvider(bonuses);
        }

        @Override
        public void serialize(FriendlyByteBuf buf, GemBonusProvider provider) {
            if (!(provider instanceof RandomGemBonusProvider)) {
                throw new IllegalArgumentException();
            }
            RandomGemBonusProvider aProvider = (RandomGemBonusProvider)provider;
            buf.writeInt(aProvider.bonuses.size());
            aProvider.bonuses.forEach(b -> NetworkHelper.writeGemBonusProvider(buf, b));
        }
    }
}

