/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.mixin.minecraft;

import daripher.skilltree.container.ContainerHelper;
import daripher.skilltree.container.menu.EnchantmentMenuExtension;
import daripher.skilltree.skill.bonus.SkillBonusHandler;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={EnchantmentMenu.class})
public abstract class EnchantmentMenuMixin
implements EnchantmentMenuExtension {
    private final int[] costsBeforeReduction = new int[3];
    @Shadow
    @Final
    public int[] f_39446_;
    @Shadow
    @Final
    private DataSlot f_39452_;

    @Redirect(method={"lambda$slotsChanged$0", "m_39483_"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/event/ForgeEventFactory;onEnchantmentLevelSet(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;IILnet/minecraft/world/item/ItemStack;I)I"))
    private int reduceEnchantmentCost(Level level, BlockPos pos, int slot, int power, ItemStack itemStack, int enchantmentLevel) {
        int cost;
        this.costsBeforeReduction[slot] = cost = ForgeEventFactory.onEnchantmentLevelSet((Level)level, (BlockPos)pos, (int)slot, (int)power, (ItemStack)itemStack, (int)this.f_39446_[slot]);
        EnchantmentMenu menu = (EnchantmentMenu)this;
        Player player = ContainerHelper.getViewingPlayer((AbstractContainerMenu)menu);
        if (player == null) {
            return cost;
        }
        return SkillBonusHandler.adjustEnchantmentCost(cost, player);
    }

    @Redirect(method={"lambda$slotsChanged$0", "m_39483_"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/EnchantmentMenu;getEnchantmentList(Lnet/minecraft/world/item/ItemStack;II)Ljava/util/List;"))
    private List<EnchantmentInstance> amplifyEnchantmentsVisually(EnchantmentMenu menu, ItemStack itemStack, int slot, int cost) {
        return this.amplifyEnchantments(itemStack, slot);
    }

    @Redirect(method={"lambda$clickMenuButton$1", "m_39475_"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/EnchantmentMenu;getEnchantmentList(Lnet/minecraft/world/item/ItemStack;II)Ljava/util/List;"))
    private List<EnchantmentInstance> amplifyEnchantmentsOnButtonClick(EnchantmentMenu menu, ItemStack itemStack, int slot, int cost) {
        return this.amplifyEnchantments(itemStack, slot);
    }

    private List<EnchantmentInstance> amplifyEnchantments(ItemStack itemStack, int slot) {
        List<EnchantmentInstance> enchantments = this.m_39471_(itemStack, slot, this.costsBeforeReduction[slot]);
        RandomSource random = RandomSource.m_216335_((long)this.f_39452_.m_6501_());
        EnchantmentMenu menu = (EnchantmentMenu)this;
        Player player = ContainerHelper.getViewingPlayer((AbstractContainerMenu)menu);
        if (player == null) {
            return enchantments;
        }
        SkillBonusHandler.amplifyEnchantments(enchantments, random, player);
        return enchantments;
    }

    @Shadow
    @Nonnull
    private List<EnchantmentInstance> m_39471_(ItemStack stack, int slot, int cost) {
        return null;
    }

    @Override
    public int[] getCostsBeforeReduction() {
        return this.costsBeforeReduction;
    }

    @Override
    public int getEnchantmentSeed() {
        return this.f_39452_.m_6501_();
    }
}

