/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus;

import com.mojang.datafixers.util.Either;
import daripher.itemproduction.event.ItemProducedEvent;
import daripher.skilltree.capability.skill.PlayerSkillsProvider;
import daripher.skilltree.effect.SkillBonusEffect;
import daripher.skilltree.entity.EquippedEntity;
import daripher.skilltree.entity.player.PlayerHelper;
import daripher.skilltree.item.ItemBonusProvider;
import daripher.skilltree.item.ItemHelper;
import daripher.skilltree.mixin.AbstractArrowAccessor;
import daripher.skilltree.potion.PotionHelper;
import daripher.skilltree.skill.PassiveSkill;
import daripher.skilltree.skill.bonus.EventListenerBonus;
import daripher.skilltree.skill.bonus.SkillBonus;
import daripher.skilltree.skill.bonus.event.AttackEventListener;
import daripher.skilltree.skill.bonus.event.BlockEventListener;
import daripher.skilltree.skill.bonus.event.DamageTakenEventListener;
import daripher.skilltree.skill.bonus.event.ItemUsedEventListener;
import daripher.skilltree.skill.bonus.event.KillEventListener;
import daripher.skilltree.skill.bonus.event.SkillEventListener;
import daripher.skilltree.skill.bonus.item.FoodHealingBonus;
import daripher.skilltree.skill.bonus.item.ItemBonus;
import daripher.skilltree.skill.bonus.item.ItemSkillBonus;
import daripher.skilltree.skill.bonus.player.ArrowRetrievalBonus;
import daripher.skilltree.skill.bonus.player.AttributeBonus;
import daripher.skilltree.skill.bonus.player.BlockBreakSpeedBonus;
import daripher.skilltree.skill.bonus.player.CantUseItemBonus;
import daripher.skilltree.skill.bonus.player.CraftedItemBonus;
import daripher.skilltree.skill.bonus.player.CritChanceBonus;
import daripher.skilltree.skill.bonus.player.CritDamageBonus;
import daripher.skilltree.skill.bonus.player.DamageBonus;
import daripher.skilltree.skill.bonus.player.EnchantmentAmplificationBonus;
import daripher.skilltree.skill.bonus.player.EnchantmentRequirementBonus;
import daripher.skilltree.skill.bonus.player.FreeEnchantmentBonus;
import daripher.skilltree.skill.bonus.player.GainedExperienceBonus;
import daripher.skilltree.skill.bonus.player.HealthReservationBonus;
import daripher.skilltree.skill.bonus.player.IncomingHealingBonus;
import daripher.skilltree.skill.bonus.player.JumpHeightBonus;
import daripher.skilltree.skill.bonus.player.LootDuplicationBonus;
import daripher.skilltree.skill.bonus.player.RepairEfficiencyBonus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.StringUtils;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;
import top.theillusivec4.curios.api.event.CurioEquipEvent;

@Mod.EventBusSubscriber(modid="skilltree")
public class SkillBonusHandler {
    @SubscribeEvent
    public static void applyBreakSpeedMultiplier(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        float multiplier = 1.0f;
        for (BlockBreakSpeedBonus bonus : SkillBonusHandler.getSkillBonuses(player, BlockBreakSpeedBonus.class)) {
            if (!bonus.getPlayerCondition().met((LivingEntity)player)) continue;
            multiplier += bonus.getMultiplier();
        }
        event.setNewSpeed(event.getNewSpeed() * multiplier);
    }

    @SubscribeEvent
    public static void applyFallReductionMultiplier(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        float multiplier = SkillBonusHandler.getJumpHeightMultiplier(player);
        if (multiplier <= 1.0f) {
            return;
        }
        event.setDistance(event.getDistance() / multiplier);
    }

    @SubscribeEvent
    public static void applyRepairEfficiency(AnvilUpdateEvent event) {
        int materialsUsed;
        int durabilityPerMaterial;
        ItemStack stack;
        Player player = event.getPlayer();
        float efficiency = SkillBonusHandler.getRepairEfficiency(player, stack = event.getLeft());
        if (efficiency == 1.0f) {
            return;
        }
        if (!stack.m_41763_() || !stack.m_41768_()) {
            return;
        }
        ItemStack material = event.getRight();
        if (!stack.m_41720_().m_6832_(stack, material)) {
            return;
        }
        ItemStack result = stack.m_41777_();
        int durabilityRestored = durabilityPerMaterial = (int)((float)(result.m_41776_() * 12) * (1.0f + efficiency) / 100.0f);
        int cost = 0;
        for (materialsUsed = 0; durabilityRestored > 0 && materialsUsed < material.m_41613_(); ++materialsUsed) {
            result.m_41721_(result.m_41773_() - durabilityRestored);
            ++cost;
            durabilityRestored = Math.min(result.m_41773_(), durabilityPerMaterial);
        }
        if (event.getName() != null && !StringUtils.isBlank((CharSequence)event.getName())) {
            if (!event.getName().equals(stack.m_41786_().getString())) {
                ++cost;
                result.m_41714_((Component)Component.m_237113_((String)event.getName()));
            }
        } else if (stack.m_41788_()) {
            ++cost;
            result.m_41787_();
        }
        event.setMaterialCost(materialsUsed);
        event.setCost(cost);
        event.setOutput(result);
    }

    private static float getRepairEfficiency(Player player, ItemStack stack) {
        float efficiency = 1.0f;
        for (RepairEfficiencyBonus bonus : SkillBonusHandler.getSkillBonuses(player, RepairEfficiencyBonus.class)) {
            if (!bonus.getItemCondition().met(stack)) continue;
            efficiency += bonus.getMultiplier();
        }
        return efficiency;
    }

    @SubscribeEvent
    public static void tickSkillBonuses(TickEvent.PlayerTickEvent event) {
        if (event.player.m_21224_()) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        SkillBonusHandler.getSkillBonuses((Player)player2, SkillBonus.Ticking.class).forEach(bonus -> bonus.tick(player2));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void applyFlatDamageBonus(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        player.getPersistentData().m_128405_("LastAttackTarget", event.getEntity().m_19879_());
        float bonus = SkillBonusHandler.getDamageBonus(player, event.getSource(), event.getEntity(), AttributeModifier.Operation.ADDITION);
        event.setAmount(event.getAmount() + bonus);
    }

    @SubscribeEvent
    public static void applyBaseDamageMultipliers(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        float bonus = SkillBonusHandler.getDamageBonus(player, event.getSource(), event.getEntity(), AttributeModifier.Operation.MULTIPLY_BASE);
        event.setAmount(event.getAmount() * (1.0f + bonus));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void applyTotalDamageMultipliers(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        float bonus = SkillBonusHandler.getDamageBonus(player, event.getSource(), event.getEntity(), AttributeModifier.Operation.MULTIPLY_TOTAL);
        event.setAmount(event.getAmount() * (1.0f + bonus));
    }

    private static float getDamageBonus(Player player, DamageSource damageSource, LivingEntity target, AttributeModifier.Operation operation) {
        float amount = 0.0f;
        for (DamageBonus bonus : SkillBonusHandler.getSkillBonuses(player, DamageBonus.class)) {
            amount += bonus.getDamageBonus(operation, damageSource, player, target);
        }
        return amount;
    }

    @SubscribeEvent
    public static void applyCritBonuses(CriticalHitEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        DamageSource damageSource = player2.m_9236_().m_269111_().m_269075_((Player)player2);
        float critChance = SkillBonusHandler.getCritChance(player2, damageSource, (LivingEntity)event.getEntity());
        if (player2.m_217043_().m_188501_() >= critChance) {
            return;
        }
        float critMultiplier = event.getDamageModifier();
        critMultiplier += SkillBonusHandler.getCritDamageMultiplier(player2, damageSource, target);
        if (!event.isVanillaCritical()) {
            critMultiplier += 0.5f;
            event.setResult(Event.Result.ALLOW);
        }
        event.setDamageModifier(critMultiplier);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void applyCritBonuses(LivingHurtEvent event) {
        if (event.getSource().m_7640_() instanceof Player) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        float critChance = SkillBonusHandler.getCritChance(player, event.getSource(), event.getEntity());
        if (player.m_217043_().m_188501_() >= critChance) {
            return;
        }
        float critMultiplier = 1.5f;
        event.setAmount(event.getAmount() * (critMultiplier += SkillBonusHandler.getCritDamageMultiplier(player, event.getSource(), event.getEntity())));
    }

    private static float getCritDamageMultiplier(ServerPlayer player, DamageSource source, LivingEntity target) {
        float multiplier = 0.0f;
        for (CritDamageBonus bonus : SkillBonusHandler.getSkillBonuses((Player)player, CritDamageBonus.class)) {
            multiplier += bonus.getDamageBonus(source, (Player)player, target);
        }
        return multiplier;
    }

    private static float getCritChance(ServerPlayer player, DamageSource source, LivingEntity target) {
        float critChance = 0.0f;
        for (CritChanceBonus bonus : SkillBonusHandler.getSkillBonuses((Player)player, CritChanceBonus.class)) {
            critChance += bonus.getChanceBonus(source, (Player)player, target);
        }
        return critChance;
    }

    @SubscribeEvent
    public static void addAdditionalSocketTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        int sockets = ItemHelper.getAdditionalSockets(stack);
        if (sockets > 0) {
            String key = "gem.additional_socket_" + sockets;
            MutableComponent socketTooltip = Component.m_237115_((String)key).m_130940_(ChatFormatting.YELLOW);
            event.getToolTip().add(1, socketTooltip);
        }
    }

    @SubscribeEvent
    public static void addCraftedItemSkillBonusTooltips(ItemTooltipEvent event) {
        List components = event.getToolTip();
        for (ItemBonus<?> itemBonus : ItemHelper.getItemBonusesExcludingGems(event.getItemStack())) {
            ItemSkillBonus skillBonus;
            SkillBonus<?> bonus;
            if (!(itemBonus instanceof ItemSkillBonus) || (bonus = (skillBonus = (ItemSkillBonus)itemBonus).getBonus()) instanceof AttributeBonus) continue;
            MutableComponent tooltip = bonus.getTooltip();
            components.add(tooltip);
        }
    }

    @SubscribeEvent
    public static void setCraftedItemBonus(ItemProducedEvent event) {
        ItemStack stack = event.getStack();
        if (PotionHelper.isMixture(stack)) {
            return;
        }
        Player player = event.getPlayer();
        ItemHelper.removeItemBonuses(stack);
        SkillBonusHandler.getSkillBonuses(player, CraftedItemBonus.class).forEach(bonus -> bonus.itemCrafted(stack));
        ItemHelper.getItemBonuses(stack, ItemBonus.class).forEach(bonus -> bonus.itemCrafted(stack));
        ItemHelper.refreshDurabilityBonuses(stack);
    }

    @SubscribeEvent
    public static void applyCraftedItemAttributeBonuses(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        if (event.getSlotType() != Player.m_147233_((ItemStack)stack)) {
            return;
        }
        SkillBonusHandler.addAttributeModifiers((arg_0, arg_1) -> ((ItemAttributeModifierEvent)event).addModifier(arg_0, arg_1), stack);
    }

    @SubscribeEvent
    public static void applyCraftedCurioAttributeBonuses(CurioAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        if (!CuriosApi.isStackValid((SlotContext)event.getSlotContext(), (ItemStack)stack)) {
            return;
        }
        SkillBonusHandler.addAttributeModifiers((arg_0, arg_1) -> ((CurioAttributeModifierEvent)event).addModifier(arg_0, arg_1), stack);
    }

    @SubscribeEvent
    public static void applyFoodHealing(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        if (stack.getFoodProperties(event.getEntity()) == null) {
            return;
        }
        float healing = 0.0f;
        for (FoodHealingBonus bonus : ItemHelper.getItemBonuses(stack, FoodHealingBonus.class)) {
            healing += bonus.getAmount();
        }
        event.getEntity().m_5634_(healing);
    }

    @SubscribeEvent
    public static void applyIncomingHealingBonus(LivingHealEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        float multiplier = 1.0f;
        for (IncomingHealingBonus bonus : SkillBonusHandler.getSkillBonuses(player, IncomingHealingBonus.class)) {
            multiplier += bonus.getHealingMultiplier(player);
        }
        event.setAmount(event.getAmount() * multiplier);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void applyLootDuplicationChanceBonus(LivingDropsEvent event) {
        float multiplier;
        if (event.getEntity() instanceof Player) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        for (multiplier = SkillBonusHandler.getLootMultiplier(player, LootDuplicationBonus.LootType.MOBS); multiplier > 1.0f; multiplier -= 1.0f) {
            event.getDrops().addAll(SkillBonusHandler.getDrops(event));
        }
        if (player.m_217043_().m_188501_() < multiplier) {
            event.getDrops().addAll(SkillBonusHandler.getDrops(event));
        }
    }

    @SubscribeEvent
    public static void applyExperienceFromMobsBonus(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player == null) {
            return;
        }
        float multiplier = 1.0f;
        event.setDroppedExperience((int)((float)event.getDroppedExperience() * (multiplier += SkillBonusHandler.getExperienceMultiplier(player, GainedExperienceBonus.ExperienceSource.MOBS))));
    }

    @SubscribeEvent
    public static void applyExperienceFromOreBonus(BlockEvent.BreakEvent event) {
        if (!event.getState().m_204336_(Tags.Blocks.ORES)) {
            return;
        }
        float multiplier = 1.0f;
        event.setExpToDrop((int)((float)event.getExpToDrop() * (multiplier += SkillBonusHandler.getExperienceMultiplier(event.getPlayer(), GainedExperienceBonus.ExperienceSource.ORE))));
    }

    @SubscribeEvent
    public static void applyFishingExperienceBonus(ItemFishedEvent event) {
        Player player = event.getEntity();
        float multiplier = SkillBonusHandler.getExperienceMultiplier(player, GainedExperienceBonus.ExperienceSource.FISHING);
        if (multiplier == 0.0f) {
            return;
        }
        int exp = (int)((float)(player.m_217043_().m_188503_(6) + 1) * multiplier);
        if (exp == 0) {
            return;
        }
        ExperienceOrb expOrb = new ExperienceOrb(player.m_9236_(), player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_() + 0.5, exp);
        player.m_9236_().m_7967_((Entity)expOrb);
    }

    private static float getExperienceMultiplier(Player player, GainedExperienceBonus.ExperienceSource source) {
        float multiplier = 0.0f;
        for (GainedExperienceBonus bonus : SkillBonusHandler.getSkillBonuses(player, GainedExperienceBonus.class)) {
            if (bonus.getSource() != source) continue;
            multiplier += bonus.getMultiplier();
        }
        return multiplier;
    }

    @SubscribeEvent
    public static void applyEventListenerEffect(LivingHurtEvent event) {
        Object copy;
        SkillEventListener listener;
        Object object;
        Player player;
        Entity sourceEntity = event.getSource().m_7639_();
        if (sourceEntity instanceof Player) {
            player = (Player)sourceEntity;
            object = SkillBonusHandler.getSkillBonuses(player, EventListenerBonus.class).iterator();
            while (object.hasNext()) {
                EventListenerBonus bonus = (EventListenerBonus)object.next();
                SkillEventListener skillEventListener = bonus.getEventListener();
                if (!(skillEventListener instanceof AttackEventListener)) continue;
                listener = (AttackEventListener)skillEventListener;
                copy = bonus.copy();
                ((AttackEventListener)listener).onEvent(player, event.getEntity(), event.getSource(), (EventListenerBonus)copy);
            }
        }
        if ((object = event.getEntity()) instanceof Player) {
            player = (Player)object;
            for (EventListenerBonus bonus : SkillBonusHandler.getSkillBonuses(player, EventListenerBonus.class)) {
                copy = bonus.getEventListener();
                if (!(copy instanceof DamageTakenEventListener)) continue;
                listener = (DamageTakenEventListener)copy;
                copy = bonus.copy();
                LivingEntity attacker = sourceEntity instanceof LivingEntity ? (LivingEntity)sourceEntity : null;
                ((DamageTakenEventListener)listener).onEvent(player, attacker, event.getSource(), (EventListenerBonus)copy);
            }
        }
    }

    @SubscribeEvent
    public static void applyEventListenerEffect(ShieldBlockEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        for (EventListenerBonus bonus : SkillBonusHandler.getSkillBonuses(player, EventListenerBonus.class)) {
            SkillEventListener skillEventListener = bonus.getEventListener();
            if (!(skillEventListener instanceof BlockEventListener)) continue;
            BlockEventListener listener = (BlockEventListener)skillEventListener;
            SkillBonus copy = bonus.copy();
            DamageSource source = event.getDamageSource();
            Entity sourceEntity = source.m_7639_();
            LivingEntity attacker = sourceEntity instanceof LivingEntity ? (LivingEntity)sourceEntity : null;
            listener.onEvent(player, attacker, source, (EventListenerBonus)copy);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void applyEventListenerEffect(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        for (EventListenerBonus bonus : SkillBonusHandler.getSkillBonuses(player, EventListenerBonus.class)) {
            SkillEventListener skillEventListener = bonus.getEventListener();
            if (!(skillEventListener instanceof ItemUsedEventListener)) continue;
            ItemUsedEventListener listener = (ItemUsedEventListener)skillEventListener;
            SkillBonus copy = bonus.copy();
            listener.onEvent(player, event.getItem(), (EventListenerBonus)copy);
        }
    }

    @SubscribeEvent
    public static void applyEventListenerEffect(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        for (EventListenerBonus bonus : SkillBonusHandler.getSkillBonuses(player, EventListenerBonus.class)) {
            SkillEventListener skillEventListener = bonus.getEventListener();
            if (!(skillEventListener instanceof KillEventListener)) continue;
            KillEventListener listener = (KillEventListener)skillEventListener;
            SkillBonus copy = bonus.copy();
            DamageSource source = event.getSource();
            listener.onEvent(player, (LivingEntity)player, source, (EventListenerBonus)copy);
        }
    }

    @SubscribeEvent
    public static void applyArrowRetrievalBonus(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7640_();
        if (!(entity instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)entity;
        Entity entity2 = event.getSource().m_7639_();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player player = (Player)entity2;
        AbstractArrowAccessor arrowAccessor = (AbstractArrowAccessor)arrow;
        ItemStack arrowStack = arrowAccessor.invokeGetPickupItem();
        if (arrowStack == null) {
            return;
        }
        float retrievalChance = 0.0f;
        for (ArrowRetrievalBonus bonus : SkillBonusHandler.getSkillBonuses(player, ArrowRetrievalBonus.class)) {
            retrievalChance += bonus.getChance();
        }
        if (player.m_217043_().m_188501_() >= retrievalChance) {
            return;
        }
        LivingEntity target = event.getEntity();
        CompoundTag targetData = target.getPersistentData();
        ListTag stuckArrowsTag = targetData.m_128437_("StuckArrows", (int)new CompoundTag().m_7060_());
        stuckArrowsTag.add((Object)arrowStack.m_41739_(new CompoundTag()));
        targetData.m_128365_("StuckArrows", (Tag)stuckArrowsTag);
    }

    @SubscribeEvent
    public static void retrieveArrows(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        ListTag arrowsTag = entity.getPersistentData().m_128437_("StuckArrows", (int)new CompoundTag().m_7060_());
        if (arrowsTag.isEmpty()) {
            return;
        }
        for (Tag tag : arrowsTag) {
            ItemStack arrowStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)tag));
            entity.m_19983_(arrowStack);
        }
    }

    @SubscribeEvent
    public static void applyHealthReservationEffect(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END || event.side == LogicalSide.CLIENT) {
            return;
        }
        float reservation = SkillBonusHandler.getHealthReservation(event.player);
        if (reservation == 0.0f) {
            return;
        }
        if (event.player.m_21223_() / event.player.m_21233_() > 1.0f - reservation) {
            event.player.m_21153_(event.player.m_21233_() * (1.0f - reservation));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void applyHealthReservationEffect(LivingHealEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        float reservation = SkillBonusHandler.getHealthReservation(player);
        if (reservation == 0.0f) {
            return;
        }
        float healthAfterHealing = player.m_21223_() + event.getAmount();
        if (healthAfterHealing / player.m_21233_() > 1.0f - reservation) {
            event.setCanceled(true);
        }
    }

    private static float getHealthReservation(Player player) {
        float reservation = 0.0f;
        for (HealthReservationBonus bonus : SkillBonusHandler.getSkillBonuses(player, HealthReservationBonus.class)) {
            reservation += bonus.getAmount(player);
        }
        return reservation;
    }

    @SubscribeEvent
    public static void applyCantUseItemBonus(AttackEntityEvent event) {
        for (CantUseItemBonus bonus : SkillBonusHandler.getSkillBonuses(event.getEntity(), CantUseItemBonus.class)) {
            if (!bonus.getItemCondition().met(event.getEntity().m_21205_())) continue;
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void applyCantUseItemBonus(PlayerInteractEvent event) {
        for (CantUseItemBonus bonus : SkillBonusHandler.getSkillBonuses(event.getEntity(), CantUseItemBonus.class)) {
            if (!bonus.getItemCondition().met(event.getItemStack())) continue;
            event.setCancellationResult(InteractionResult.FAIL);
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            return;
        }
    }

    @SubscribeEvent
    public static void applyCantUseItemBonus(CurioEquipEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        for (CantUseItemBonus bonus : SkillBonusHandler.getSkillBonuses(player, CantUseItemBonus.class)) {
            if (!bonus.getItemCondition().met(event.getStack())) continue;
            event.setResult(Event.Result.DENY);
            return;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void addCantUseItemTooltip(RenderTooltipEvent.GatherComponents event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        for (CantUseItemBonus bonus : SkillBonusHandler.getSkillBonuses((Player)player, CantUseItemBonus.class)) {
            if (!bonus.getItemCondition().met(event.getItemStack())) continue;
            MutableComponent tooltip = Component.m_237115_((String)"item.cant_use.info").m_130940_(ChatFormatting.RED);
            event.getTooltipElements().add(Either.left((Object)tooltip));
            return;
        }
    }

    public static float getLootMultiplier(Player player, LootDuplicationBonus.LootType lootType) {
        Map<Float, Float> multipliers = SkillBonusHandler.getLootMultipliers(player, lootType);
        float multiplier = 0.0f;
        for (Map.Entry<Float, Float> entry : multipliers.entrySet()) {
            float chance;
            for (chance = entry.getValue().floatValue(); chance > 1.0f; chance -= 1.0f) {
                multiplier += entry.getKey().floatValue();
            }
            if (!(player.m_217043_().m_188501_() < chance)) continue;
            multiplier += entry.getKey().floatValue();
        }
        return multiplier;
    }

    @Nonnull
    private static Map<Float, Float> getLootMultipliers(Player player, LootDuplicationBonus.LootType lootType) {
        HashMap<Float, Float> multipliers = new HashMap<Float, Float>();
        for (LootDuplicationBonus b : SkillBonusHandler.getSkillBonuses(player, LootDuplicationBonus.class)) {
            if (b.getLootType() != lootType) continue;
            float chance = b.getChance() + multipliers.getOrDefault(Float.valueOf(b.getMultiplier()), Float.valueOf(0.0f)).floatValue();
            multipliers.put(Float.valueOf(b.getMultiplier()), Float.valueOf(chance));
        }
        return multipliers;
    }

    protected static List<ItemEntity> getDrops(LivingDropsEvent event) {
        ArrayList<ItemEntity> drops = new ArrayList<ItemEntity>();
        for (ItemEntity itemEntity : event.getDrops()) {
            ItemEntity copy = itemEntity.m_32066_();
            drops.add(copy);
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EquippedEntity) {
            EquippedEntity entity = (EquippedEntity)livingEntity;
            drops.removeIf(entity::hasItemEquipped);
        }
        return drops;
    }

    private static void addAttributeModifiers(BiConsumer<Attribute, AttributeModifier> addFunction, ItemStack stack) {
        for (ItemBonus<?> itemBonus : ItemHelper.getItemBonuses(stack)) {
            AttributeBonus attributeBonus;
            ItemSkillBonus itemSkillBonus;
            SkillBonus<?> bonus;
            if (!(itemBonus instanceof ItemSkillBonus) || !((bonus = (itemSkillBonus = (ItemSkillBonus)itemBonus).getBonus()) instanceof AttributeBonus) || (attributeBonus = (AttributeBonus)bonus).hasMultiplier() || attributeBonus.hasCondition()) continue;
            addFunction.accept(attributeBonus.getAttribute(), attributeBonus.getModifier());
        }
    }

    public static float getJumpHeightMultiplier(Player player) {
        float multiplier = 1.0f;
        for (JumpHeightBonus bonus : SkillBonusHandler.getSkillBonuses(player, JumpHeightBonus.class)) {
            multiplier += bonus.getJumpHeightMultiplier(player);
        }
        return multiplier;
    }

    public static void amplifyEnchantments(List<EnchantmentInstance> enchantments, RandomSource random, Player player) {
        enchantments.replaceAll(enchantmentInstance -> SkillBonusHandler.amplifyEnchantment(enchantmentInstance, random, player));
    }

    private static EnchantmentInstance amplifyEnchantment(EnchantmentInstance enchantment, RandomSource random, Player player) {
        if (enchantment.f_44947_.m_6586_() == 1) {
            return enchantment;
        }
        float amplificationChance = SkillBonusHandler.getAmplificationChance(enchantment, player);
        if (amplificationChance == 0.0f) {
            return enchantment;
        }
        int levelBonus = (int)amplificationChance;
        amplificationChance -= (float)levelBonus;
        int enchantmentLevel = enchantment.f_44948_ + levelBonus;
        if (random.m_188501_() < amplificationChance) {
            ++enchantmentLevel;
        }
        return new EnchantmentInstance(enchantment.f_44947_, enchantmentLevel);
    }

    public static int adjustEnchantmentCost(int cost, @Nonnull Player player) {
        return (int)Math.max(1.0, (double)cost * SkillBonusHandler.getEnchantmentCostMultiplier(player));
    }

    public static float getFreeEnchantmentChance(@Nonnull Player player) {
        float chance = 0.0f;
        for (FreeEnchantmentBonus bonus : SkillBonusHandler.getSkillBonuses(player, FreeEnchantmentBonus.class)) {
            chance += bonus.getChance();
        }
        return chance;
    }

    private static double getEnchantmentCostMultiplier(@Nonnull Player player) {
        float multiplier = 1.0f;
        for (EnchantmentRequirementBonus bonus : SkillBonusHandler.getSkillBonuses(player, EnchantmentRequirementBonus.class)) {
            multiplier += bonus.getMultiplier();
        }
        return multiplier;
    }

    private static float getAmplificationChance(EnchantmentInstance enchantment, Player player) {
        float chance = 0.0f;
        for (EnchantmentAmplificationBonus bonus : SkillBonusHandler.getSkillBonuses(player, EnchantmentAmplificationBonus.class)) {
            if (!bonus.getCondition().met(enchantment.f_44947_.f_44672_)) continue;
            chance += bonus.getChance();
        }
        return chance;
    }

    public static <T> List<T> getSkillBonuses(@Nonnull Player player, Class<T> type) {
        if (!PlayerSkillsProvider.hasSkills(player)) {
            return List.of();
        }
        ArrayList<T> bonuses = new ArrayList<T>();
        bonuses.addAll(SkillBonusHandler.getPlayerBonuses(player, type));
        bonuses.addAll(SkillBonusHandler.getEffectBonuses(player, type));
        bonuses.addAll(SkillBonusHandler.getEquipmentBonuses(player, type));
        return bonuses;
    }

    private static <T> List<T> getPlayerBonuses(Player player, Class<T> type) {
        ArrayList<T> list = new ArrayList<T>();
        for (PassiveSkill skill : PlayerSkillsProvider.get(player).getPlayerSkills()) {
            List<SkillBonus<?>> bonuses = skill.getBonuses();
            for (SkillBonus<?> skillBonus : bonuses) {
                if (!type.isInstance(skillBonus)) continue;
                list.add(type.cast(skillBonus));
            }
        }
        return list;
    }

    private static <T> List<T> getEffectBonuses(Player player, Class<T> type) {
        ArrayList<T> bonuses = new ArrayList<T>();
        for (MobEffectInstance e : player.m_21220_()) {
            SkillBonusEffect skillEffect;
            SkillBonus<?> bonus;
            MobEffect mobEffect = e.m_19544_();
            if (!(mobEffect instanceof SkillBonusEffect) || !type.isInstance(bonus = (skillEffect = (SkillBonusEffect)mobEffect).getBonus().copy())) continue;
            bonus = bonus.copy().multiply(e.m_19564_());
            bonuses.add(type.cast(bonus));
        }
        return bonuses;
    }

    private static <T> List<T> getEquipmentBonuses(Player player, Class<T> type) {
        return PlayerHelper.getAllEquipment((LivingEntity)player).map(s -> SkillBonusHandler.getItemBonuses(s, type)).flatMap(Collection::stream).toList();
    }

    private static <T> List<T> getItemBonuses(ItemStack stack, Class<T> type) {
        ArrayList itemBonuses = new ArrayList();
        Item item = stack.m_41720_();
        if (item instanceof ItemBonusProvider) {
            ItemBonusProvider provider = (ItemBonusProvider)item;
            itemBonuses.addAll(provider.getItemBonuses());
        }
        itemBonuses.addAll(ItemHelper.getItemBonuses(stack));
        ArrayList<T> bonuses = new ArrayList<T>();
        for (ItemBonus itemBonus : itemBonuses) {
            ItemSkillBonus skillBonus;
            SkillBonus<?> bonus;
            if (!(itemBonus instanceof ItemSkillBonus) || !type.isInstance(bonus = (skillBonus = (ItemSkillBonus)itemBonus).getBonus())) continue;
            bonuses.add(type.cast(bonus));
        }
        return bonuses;
    }
}

