/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookCategory;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.text.Span;
import vazkii.patchouli.client.book.text.SpanState;
import vazkii.patchouli.common.book.Book;

public class BookTextParser {
    public static final MutableComponent EMPTY_STRING_COMPONENT = Component.m_237113_((String)"");
    private static final List<CommandLookup> COMMAND_LOOKUPS = new ArrayList<CommandLookup>();
    private static final Map<String, CommandProcessor> COMMANDS = new ConcurrentHashMap<String, CommandProcessor>();
    private static final Map<String, FunctionProcessor> FUNCTIONS = new ConcurrentHashMap<String, FunctionProcessor>();
    private final GuiBook gui;
    private final Book book;
    private final int x;
    private final int y;
    private final int width;
    private final int lineHeight;
    private final Style baseStyle;
    private Pattern COMMAND_PATTERN = Pattern.compile("\\$\\(([^)]*)\\)");

    private static void registerProcessor(CommandLookup processor) {
        COMMAND_LOOKUPS.add(processor);
    }

    public static void register(CommandProcessor handler, String ... names) {
        for (String name : names) {
            COMMANDS.put(name, handler);
        }
    }

    public static void register(FunctionProcessor function, String ... names) {
        for (String name : names) {
            FUNCTIONS.put(name, function);
        }
    }

    public BookTextParser(GuiBook gui, Book book, int x, int y, int width, int lineHeight, Style baseStyle) {
        this.gui = gui;
        this.book = book;
        this.x = x;
        this.y = y;
        this.width = width;
        this.lineHeight = lineHeight;
        this.baseStyle = baseStyle;
    }

    public List<Span> parse(Component text) {
        ArrayList<Span> spans = new ArrayList<Span>();
        SpanState state = new SpanState(this.gui, this.book, this.baseStyle);
        text.m_7451_((style, string) -> {
            spans.addAll(this.processCommands(this.expandMacros(string), state, style));
            return Optional.empty();
        }, this.baseStyle);
        return spans;
    }

    public String expandMacros(@Nullable String text) {
        int i;
        String actualText = text;
        if (actualText == null) {
            actualText = "[ERROR]";
        }
        int expansionCap = 10;
        for (i = 0; i < expansionCap; ++i) {
            String newText = actualText;
            for (Map.Entry<String, String> e : this.book.macros.entrySet()) {
                newText = newText.replace(e.getKey(), e.getValue());
            }
            if (newText.equals(actualText)) break;
            actualText = newText;
        }
        if (i == expansionCap) {
            PatchouliAPI.LOGGER.warn("Expanded macros for {} iterations without reaching fixpoint, stopping. Make sure you don't have circular macro invocations", (Object)expansionCap);
        }
        return actualText;
    }

    private List<Span> processCommands(String text, SpanState state, Style style) {
        state.changeBaseStyle(style);
        ArrayList<Span> spans = new ArrayList<Span>();
        Matcher match = this.COMMAND_PATTERN.matcher(text);
        while (match.find()) {
            StringBuilder sb = new StringBuilder();
            match.appendReplacement(sb, "");
            spans.add(new Span(state, sb.toString()));
            try {
                String processed = this.processCommand(state, match.group(1));
                if (processed.isEmpty()) continue;
                spans.add(new Span(state, processed));
                if (state.cluster != null) continue;
                state.tooltip = EMPTY_STRING_COMPONENT;
            }
            catch (Exception ex) {
                spans.add(Span.error(state, "[ERROR]"));
            }
        }
        spans.add(new Span(state, match.appendTail(new StringBuffer()).toString()));
        return spans;
    }

    private String processCommand(SpanState state, String cmd) {
        CommandLookup lookup;
        state.endingExternal = false;
        Optional<Object> optResult = Optional.empty();
        Iterator<CommandLookup> iterator = COMMAND_LOOKUPS.iterator();
        while (iterator.hasNext() && !(optResult = (lookup = iterator.next()).process(cmd, state)).isPresent()) {
        }
        Object result = (String)((Object)optResult.orElse("$(" + cmd + ")"));
        if (state.endingExternal) {
            result = (String)result + ChatFormatting.GRAY + "\u21aa";
        }
        return result;
    }

    private static Optional<String> colorCodeProcessor(String functionName, SpanState state) {
        if (functionName.length() == 1 && functionName.matches("^[0123456789abcdef]$")) {
            state.modifyStyle(s -> s.m_131157_(ChatFormatting.m_126645_((char)functionName.charAt(0))));
            return Optional.of("");
        }
        return Optional.empty();
    }

    private static Optional<String> colorHexProcessor(String functionName, SpanState state) {
        if (functionName.startsWith("#") && (functionName.length() == 4 || functionName.length() == 7)) {
            TextColor color;
            Object parse = functionName.substring(1);
            if (((String)parse).length() == 3) {
                parse = "" + ((String)parse).charAt(0) + ((String)parse).charAt(0) + ((String)parse).charAt(1) + ((String)parse).charAt(1) + ((String)parse).charAt(2) + ((String)parse).charAt(2);
            }
            try {
                color = TextColor.m_131266_((int)Integer.parseInt((String)parse, 16));
            }
            catch (NumberFormatException e) {
                color = state.getBase().m_131135_();
            }
            state.color(color);
            return Optional.of("");
        }
        return Optional.empty();
    }

    private static Optional<String> listProcessor(String functionName, SpanState state) {
        if (functionName.matches("li\\d?")) {
            char c = functionName.length() > 2 ? (char)functionName.charAt(2) : (char)'1';
            int dist = Character.isDigit(c) ? Character.digit(c, 10) : 1;
            int pad = dist * 4;
            char bullet = dist % 2 == 0 ? (char)'\u25e6' : '\u2022';
            state.lineBreaks = 1;
            state.spacingLeft = pad;
            state.spacingRight = state.spaceWidth;
            return Optional.of(ChatFormatting.BLACK.toString() + bullet);
        }
        return Optional.empty();
    }

    private static Optional<String> lookupFunctionProcessor(String functionName, SpanState state) {
        int index = functionName.indexOf(58);
        if (index > 0) {
            String fname = functionName.substring(0, index);
            String param = functionName.substring(index + 1);
            return Optional.of(Optional.ofNullable(FUNCTIONS.get(fname)).map(f -> f.process(param, state)).orElse("[MISSING FUNCTION: " + fname + "]"));
        }
        return Optional.empty();
    }

    private static Optional<String> lookupCommandProcessor(String functionName, SpanState state) {
        return Optional.ofNullable(COMMANDS.get(functionName)).map(c -> c.process(state));
    }

    private static KeyMapping getKeybindKey(SpanState state, String keybind) {
        KeyMapping[] keys;
        String alt = "key." + keybind;
        for (KeyMapping k : keys = state.gui.getMinecraft().f_91066_.f_92059_) {
            String name = k.m_90860_();
            if (!name.equals(keybind) && !name.equals(alt)) continue;
            return k;
        }
        return null;
    }

    static {
        BookTextParser.registerProcessor(BookTextParser::colorCodeProcessor);
        BookTextParser.registerProcessor(BookTextParser::colorHexProcessor);
        BookTextParser.registerProcessor(BookTextParser::listProcessor);
        BookTextParser.registerProcessor(BookTextParser::lookupFunctionProcessor);
        BookTextParser.registerProcessor(BookTextParser::lookupCommandProcessor);
        BookTextParser.register((SpanState state) -> {
            state.lineBreaks = 1;
            return "";
        }, "br");
        BookTextParser.register((SpanState state) -> {
            state.lineBreaks = 2;
            return "";
        }, "br2", "2br", "p");
        BookTextParser.register((SpanState state) -> {
            state.endingExternal = state.isExternalLink;
            state.popStyle();
            state.cluster = null;
            state.tooltip = EMPTY_STRING_COMPONENT;
            state.onClick = null;
            state.isExternalLink = false;
            return "";
        }, "/l");
        BookTextParser.register((SpanState state) -> {
            state.cluster = null;
            state.tooltip = EMPTY_STRING_COMPONENT;
            return "";
        }, "/t");
        BookTextParser.register((SpanState state) -> state.gui.getMinecraft().f_91074_.m_7755_().getString(), "playername");
        BookTextParser.register((SpanState state) -> {
            state.modifyStyle(s -> s.m_131157_(ChatFormatting.OBFUSCATED));
            return "";
        }, "k", "obf");
        BookTextParser.register((SpanState state) -> {
            state.modifyStyle(s -> s.m_131157_(ChatFormatting.BOLD));
            return "";
        }, "l", "bold");
        BookTextParser.register((SpanState state) -> {
            state.modifyStyle(s -> s.m_131157_(ChatFormatting.STRIKETHROUGH));
            return "";
        }, "m", "strike");
        BookTextParser.register((SpanState state) -> {
            state.modifyStyle(s -> s.m_131157_(ChatFormatting.UNDERLINE));
            return "";
        }, "n", "underline");
        BookTextParser.register((SpanState state) -> {
            state.modifyStyle(s -> s.m_131157_(ChatFormatting.ITALIC));
            return "";
        }, "o", "italic", "italics");
        BookTextParser.register((SpanState state) -> {
            state.reset();
            return "";
        }, "", "reset", "clear");
        BookTextParser.register((SpanState state) -> {
            state.baseColor();
            return "";
        }, "nocolor");
        BookTextParser.register((String parameter, SpanState state) -> {
            KeyMapping result = BookTextParser.getKeybindKey(state, parameter);
            if (result == null) {
                state.tooltip = Component.m_237110_((String)"patchouli.gui.lexicon.keybind_missing", (Object[])new Object[]{parameter});
                return "N/A";
            }
            state.tooltip = Component.m_237110_((String)"patchouli.gui.lexicon.keybind", (Object[])new Object[]{Component.m_237115_((String)result.m_90860_())});
            return result.m_90863_().getString();
        }, "k");
        BookTextParser.register((String parameter, SpanState state) -> {
            state.cluster = new LinkedList<Span>();
            state.pushStyle(Style.f_131099_.m_131148_(TextColor.m_131266_((int)state.book.linkColor)));
            boolean isExternal = parameter.matches("^https?:.*");
            if (isExternal) {
                String url = parameter;
                state.tooltip = Component.m_237115_((String)"patchouli.gui.lexicon.external_link");
                state.isExternalLink = true;
                state.onClick = () -> {
                    GuiBook.openWebLink(state.gui, url);
                    return true;
                };
            } else {
                int hash = parameter.indexOf(35);
                String anchor = null;
                if (hash >= 0) {
                    anchor = parameter.substring(hash + 1);
                    parameter = parameter.substring(0, hash);
                }
                ResourceLocation href = parameter.contains(":") ? new ResourceLocation(parameter) : new ResourceLocation(state.book.id.m_135827_(), parameter);
                GuiBook gui = state.gui;
                Book book = state.book;
                BookEntry entry = book.getContents().entries.get(href);
                BookCategory category = book.getContents().categories.get(href);
                if (entry != null) {
                    state.tooltip = entry.isLocked() ? Component.m_237115_((String)"patchouli.gui.lexicon.locked").m_130940_(ChatFormatting.GRAY) : entry.getName();
                    int page = 0;
                    if (anchor != null) {
                        int anchorPage = entry.getPageFromAnchor(anchor);
                        if (anchorPage >= 0) {
                            page = anchorPage / 2;
                        } else {
                            state.tooltip.m_130946_(" (INVALID ANCHOR:" + anchor + ")");
                        }
                    }
                    int finalPage = page;
                    state.onClick = () -> {
                        GuiBookEntry entryGui = new GuiBookEntry(book, entry, finalPage);
                        gui.displayLexiconGui(entryGui, true);
                        GuiBook.playBookFlipSound(book);
                        return true;
                    };
                } else if (category != null) {
                    if (anchor != null) {
                        state.tooltip = Component.m_237113_((String)"BAD LINK: Cannot specify anchor when linking to a category");
                    } else {
                        state.tooltip = category.getName();
                        state.onClick = () -> {
                            gui.displayLexiconGui(new GuiBookCategory(book, category), true);
                            GuiBook.playBookFlipSound(book);
                            return true;
                        };
                    }
                } else {
                    state.tooltip = Component.m_237113_((String)("BAD LINK: " + parameter));
                }
            }
            return "";
        }, "l");
        BookTextParser.register((String parameter, SpanState state) -> {
            state.tooltip = Component.m_237113_((String)parameter);
            state.cluster = new LinkedList<Span>();
            return "";
        }, "tooltip", "t");
        BookTextParser.register((String parameter, SpanState state) -> {
            state.pushStyle(Style.f_131099_.m_131148_(TextColor.m_131266_((int)state.book.linkColor)));
            state.cluster = new LinkedList<Span>();
            state.tooltip = !parameter.startsWith("/") ? Component.m_237113_((String)"INVALID COMMAND (must begin with /)") : Component.m_237113_((String)(parameter.length() < 20 ? parameter : parameter.substring(0, 20) + "..."));
            state.onClick = () -> {
                state.gui.getMinecraft().f_91074_.f_108617_.m_246623_(parameter.substring(1));
                return true;
            };
            return "";
        }, "command", "c");
        BookTextParser.register((SpanState state) -> {
            state.popStyle();
            state.cluster = null;
            state.tooltip = EMPTY_STRING_COMPONENT;
            state.onClick = null;
            return "";
        }, "/c");
    }

    public static interface CommandLookup {
        public Optional<String> process(String var1, SpanState var2);
    }

    public static interface FunctionProcessor {
        public String process(String var1, SpanState var2);
    }

    public static interface CommandProcessor {
        public String process(SpanState var1);
    }
}

