/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper;

import com.yungnickyoung.minecraft.yungscavebiomes.block.PricklyPeachCactusBlock;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal.EatPeachGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal.EatPricklyPeachCactusGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal.EmergeGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal.RunFromPlayerGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal.SnapperStrollGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal.SnapperTemptGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.ItemModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.SoundModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SandSnapperEntity
extends PathfinderMob
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation EMERGE_PLAYER = RawAnimation.begin().thenPlay("look").thenPlay("look_loop");
    private final RawAnimation EMERGE = RawAnimation.begin().thenPlay("look_turn_head");
    private final RawAnimation DIVE = RawAnimation.begin().thenPlay("diveback");
    private final RawAnimation SWIM = RawAnimation.begin().thenPlay("swim");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation DIG_DOWN = RawAnimation.begin().thenPlay("dig_down");
    private final RawAnimation DIG_UP = RawAnimation.begin().thenPlay("dig_up");
    private final RawAnimation EAT = RawAnimation.begin().thenPlay("eat");
    private static final EntityDataAccessor<Boolean> SUBMERGED = SynchedEntityData.m_135353_(SandSnapperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LOOKING_AT_PLAYER = SynchedEntityData.m_135353_(SandSnapperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> EMERGING = SynchedEntityData.m_135353_(SandSnapperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DIVING = SynchedEntityData.m_135353_(SandSnapperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DIGGING_DOWN = SynchedEntityData.m_135353_(SandSnapperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DIGGING_UP = SynchedEntityData.m_135353_(SandSnapperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(SandSnapperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private RunFromPlayerGoal runFromPlayerGoal;
    private boolean submergedHolder;
    private boolean lookingAtPlayerHolder;
    private boolean emergingHolder;
    private boolean divingHolder;
    private boolean diggingDownHolder;
    private boolean diggingUpHolder;
    private boolean eatingHolder;
    private int divingTimer;
    private static final int DIVING_LENGTH = 15;
    private int digUpTimer;
    private static final int DIG_UP_LENGTH = 34;
    private int digDownTimer;
    private static final int DIG_DOWN_LENGTH = 37;
    private int aboveGroundTimer;
    private static final int MIN_TICKS_ABOVE_GROUND = 100;
    private boolean submergeLocked = false;
    private int friendlyTimer;
    private static final int FRIENDLY_TIMER_LENGTH = 3600;
    private int invalidSubmergeTimer;
    public int cactusEatCooldownTimer;
    public static final int CACTUS_EAT_COOLDOWN = 6000;
    public static final int CACTUS_EAT_INTERRUPTED_COOLDOWN = 200;
    private int panicSoundCooldownTimer;
    private static final int PANIC_SOUND_COOLDOWN = 60;

    public SandSnapperEntity(EntityType<SandSnapperEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EMERGING, (Object)false);
        this.f_19804_.m_135372_(DIVING, (Object)false);
        this.f_19804_.m_135372_(SUBMERGED, (Object)false);
        this.f_19804_.m_135372_(LOOKING_AT_PLAYER, (Object)false);
        this.f_19804_.m_135372_(DIGGING_DOWN, (Object)false);
        this.f_19804_.m_135372_(DIGGING_UP, (Object)false);
        this.f_19804_.m_135372_(EATING, (Object)false);
    }

    protected void m_8099_() {
        this.runFromPlayerGoal = new RunFromPlayerGoal(this, 8.0f, 1.25, 2.0);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SnapperTemptGoal(this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemModule.PRICKLY_PEACH_ITEM.get()}), false, 2.5f));
        this.f_21345_.m_25352_(2, (Goal)new EatPeachGoal(this, 16.0f, 4.0f, 1.0f, 1.5f));
        this.f_21345_.m_25352_(3, (Goal)this.runFromPlayerGoal);
        this.f_21345_.m_25352_(4, (Goal)new SnapperStrollGoal(this, 1.0, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new EatPricklyPeachCactusGoal(this, 6, 1, 4.0f, 2.0f));
        this.f_21345_.m_25352_(5, (Goal)new EmergeGoal(this, 8.0f, 2.0f, 32.0f, 100));
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.isEmerging() || this.isDiving() || this.isDiggingUp() || this.isDiggingDown()) {
            return EntityDimensions.m_20398_((float)0.4f, (float)0.7f);
        }
        if (this.isSubmerged()) {
            return EntityDimensions.m_20398_((float)0.01f, (float)0.01f);
        }
        return super.m_6972_(pose);
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        super.m_7350_(dataAccessor);
        if (dataAccessor.equals(EMERGING)) {
            AnimationController controller;
            if (this.m_9236_().f_46443_ && (controller = (AnimationController)this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).getAnimationControllers().get("generalController")) != null) {
                controller.forceAnimationReset();
            }
            this.emergingHolder = (Boolean)this.f_19804_.m_135370_(EMERGING);
            this.m_6210_();
        } else if (dataAccessor.equals(DIVING)) {
            this.divingHolder = (Boolean)this.f_19804_.m_135370_(DIVING);
            if (this.isDiving()) {
                this.divingTimer = 15;
            }
            this.m_6210_();
        } else if (dataAccessor.equals(SUBMERGED)) {
            this.submergedHolder = (Boolean)this.f_19804_.m_135370_(SUBMERGED);
            this.m_6210_();
        } else if (dataAccessor.equals(LOOKING_AT_PLAYER)) {
            this.lookingAtPlayerHolder = (Boolean)this.f_19804_.m_135370_(LOOKING_AT_PLAYER);
        } else if (dataAccessor.equals(DIGGING_UP)) {
            this.diggingUpHolder = (Boolean)this.f_19804_.m_135370_(DIGGING_UP);
            if (this.isDiggingUp()) {
                this.digUpTimer = 34;
            }
            this.m_6210_();
        } else if (dataAccessor.equals(DIGGING_DOWN)) {
            this.diggingDownHolder = (Boolean)this.f_19804_.m_135370_(DIGGING_DOWN);
            if (this.isDiggingDown()) {
                this.digDownTimer = 37;
            }
            this.m_6210_();
        } else if (dataAccessor.equals(EATING)) {
            this.eatingHolder = (Boolean)this.f_19804_.m_135370_(EATING);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.aboveGroundTimer > 0) {
                --this.aboveGroundTimer;
            }
            if (this.panicSoundCooldownTimer > 0) {
                --this.panicSoundCooldownTimer;
            }
            if (this.friendlyTimer > 0) {
                --this.friendlyTimer;
                if (this.friendlyTimer <= 0) {
                    if (this.runFromPlayerGoal == null) {
                        this.runFromPlayerGoal = new RunFromPlayerGoal(this, 8.0f, 1.25, 2.0);
                    }
                    this.f_21345_.m_25363_((Goal)this.runFromPlayerGoal);
                    this.f_21345_.m_25352_(3, (Goal)this.runFromPlayerGoal);
                }
            }
            if (this.cactusEatCooldownTimer > 0) {
                --this.cactusEatCooldownTimer;
            }
            if (this.canMove()) {
                if (!this.isSubmerged() && this.canSubmerge(false)) {
                    this.setSubmerged(true);
                    this.invalidSubmergeTimer = 0;
                } else if (this.isSubmerged() && !this.canSubmerge(false)) {
                    ++this.invalidSubmergeTimer;
                    if (this.invalidSubmergeTimer > 10) {
                        this.setSubmerged(false);
                        this.invalidSubmergeTimer = 0;
                    }
                }
            }
            if (this.isDiving()) {
                if (this.divingTimer > 0) {
                    --this.divingTimer;
                } else {
                    this.setDiving(false);
                    this.divingTimer = 0;
                }
            }
            if (this.isDiggingDown()) {
                if (this.digDownTimer > 0) {
                    --this.digDownTimer;
                } else {
                    this.setDiggingDown(false);
                    this.digDownTimer = 0;
                    this.f_19804_.m_135381_(SUBMERGED, (Object)true);
                    this.submergedHolder = true;
                    this.m_6210_();
                }
            }
            if (this.isDiggingUp()) {
                if (this.digUpTimer > 0) {
                    --this.digUpTimer;
                } else {
                    this.setDiggingUp(false);
                    this.digUpTimer = 0;
                    this.f_19804_.m_135381_(SUBMERGED, (Object)false);
                    this.submergedHolder = false;
                    this.m_6210_();
                }
            }
        }
    }

    public boolean canMove() {
        return !this.isDiving() && !this.isDiggingUp() && !this.isDiggingDown() && !this.isEmerging() && !this.isEating();
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.isSubmerged()) {
            return InteractionResult.FAIL;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_((Item)ItemModule.PRICKLY_PEACH_ITEM.get())) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            this.onEat();
            this.friendlyTimer = 3600;
            this.f_21345_.m_25363_((Goal)this.runFromPlayerGoal);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void onEat() {
        this.m_5634_(4.0f);
        this.m_146850_(GameEvent.f_223708_);
        this.m_9236_().m_7605_((Entity)this, (byte)7);
        float pitch = Mth.m_216283_((RandomSource)this.f_19796_, (float)0.9f, (float)1.2f);
        this.m_5496_((SoundEvent)SoundModule.SAND_SNAPPER_HAPPY.get(), 1.0f, pitch);
    }

    protected void spawnHeartParticles() {
        for (int i = 0; i < 7; ++i) {
            double xSpeed = this.f_19796_.m_188583_() * 0.02;
            double ySpeed = this.f_19796_.m_188583_() * 0.02;
            double zSpeed = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), xSpeed, ySpeed, zSpeed);
        }
    }

    public void m_7822_(byte eventId) {
        if (eventId == 7) {
            this.spawnHeartParticles();
        } else {
            super.m_7822_(eventId);
        }
    }

    public boolean m_7337_(Entity entity) {
        return !this.isSubmerged() && super.m_7337_(entity);
    }

    public boolean m_6094_() {
        return super.m_6094_() && !this.isSubmerged();
    }

    public void m_7334_(Entity entity) {
        if (!this.isSubmerged()) {
            super.m_7334_(entity);
        }
    }

    public boolean m_20147_() {
        return this.isSubmerged() || super.m_20147_();
    }

    public boolean m_6673_(DamageSource source) {
        if (this.isSubmerged() && !source.m_269533_(DamageTypeTags.f_268738_) && !source.m_19390_()) {
            return true;
        }
        return super.m_6673_(source);
    }

    public float m_5610_(BlockPos movePos, LevelReader level) {
        return level.m_8055_(movePos.m_7495_()).m_204336_(BlockModule.SAND_SNAPPER_BLOCKS) ? 10.0f : 0.0f;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.canMove()) {
            this.m_21573_().m_26573_();
        }
        Vec3 movement = this.m_20184_();
        if (this.m_9236_().m_5776_() && this.isSubmerged() && movement.m_82553_() > (double)0.01f) {
            float width = this.m_6972_((Pose)this.m_20089_()).f_20377_ * 0.8f;
            Vector3d particlePos = new Vector3d(this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)width, this.m_20186_() + 0.1, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)width);
            Vector3d particleSpeed = new Vector3d(movement.f_82479_ * -4.0, 1.5, movement.f_82481_ * -4.0);
            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_20075_()), particlePos.x, particlePos.y, particlePos.z, particleSpeed.x, particleSpeed.y, particleSpeed.z);
        }
    }

    public boolean m_5830_() {
        return false;
    }

    public boolean isOnCactusEatCooldown() {
        return this.cactusEatCooldownTimer > 0;
    }

    public void eatCactus(BlockPos cactusPos) {
        BlockPos cactusBlockPos = new BlockPos((Vec3i)cactusPos);
        BlockState state = this.m_9236_().m_8055_(cactusBlockPos);
        if (state.m_60713_((Block)BlockModule.PRICKLY_PEACH_CACTUS.get()) && ((Boolean)state.m_61143_((Property)PricklyPeachCactusBlock.FRUIT)).booleanValue()) {
            this.m_9236_().m_7731_(cactusBlockPos, (BlockState)((BlockState)state.m_61124_((Property)PricklyPeachCactusBlock.FRUIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PricklyPeachCactusBlock.AGE, (Comparable)Integer.valueOf(0)), 3);
            this.onEat();
        }
    }

    public void setSubmerged(boolean isSubmerged) {
        boolean prevValue = this.submergedHolder;
        this.f_19804_.m_135381_(SUBMERGED, (Object)isSubmerged);
        int n = this.aboveGroundTimer = isSubmerged ? 0 : 100;
        if (isSubmerged && !prevValue) {
            this.setDiggingDown(true);
        } else if (!isSubmerged && prevValue) {
            this.setDiggingUp(true);
        }
        this.m_6210_();
    }

    public boolean canSubmerge(boolean ignoreTimer) {
        if (!ignoreTimer && this.aboveGroundTimer > 0) {
            return false;
        }
        if (!this.canMove()) {
            return false;
        }
        if (this.submergeLocked) {
            return false;
        }
        BlockState blockStateOn = this.m_20075_();
        BlockState blockStateBelow = this.m_9236_().m_8055_(this.m_20097_().m_7495_());
        return blockStateOn.m_204336_(BlockModule.SAND_SNAPPER_BLOCKS) || blockStateOn.m_60713_(Blocks.f_50016_) && blockStateBelow.m_204336_(BlockModule.SAND_SNAPPER_BLOCKS);
    }

    public void setSubmergeLocked(boolean locked) {
        this.submergeLocked = locked;
    }

    public boolean isSubmergeLocked() {
        return this.submergeLocked;
    }

    public void setEmerging(boolean isEmerging) {
        this.f_19804_.m_135381_(EMERGING, (Object)isEmerging);
        this.emergingHolder = isEmerging;
        this.f_19804_.m_135381_(SUBMERGED, (Object)(!isEmerging ? 1 : 0));
        this.submergedHolder = !isEmerging;
    }

    public boolean isEmerging() {
        return this.emergingHolder;
    }

    public void setDiving(boolean isDiving) {
        this.f_19804_.m_135381_(DIVING, (Object)isDiving);
        this.divingHolder = isDiving;
    }

    public boolean isDiving() {
        return this.divingHolder;
    }

    public boolean isSubmerged() {
        return this.submergedHolder;
    }

    public void setDiggingUp(boolean diggingUp) {
        this.f_19804_.m_135381_(DIGGING_UP, (Object)diggingUp);
        this.diggingUpHolder = diggingUp;
    }

    public boolean isDiggingUp() {
        return this.diggingUpHolder;
    }

    public void setDiggingDown(boolean diggingDown) {
        this.f_19804_.m_135381_(DIGGING_DOWN, (Object)diggingDown);
        this.diggingDownHolder = diggingDown;
    }

    public boolean isDiggingDown() {
        return this.diggingDownHolder;
    }

    public boolean isLookingAtPlayer() {
        return this.lookingAtPlayerHolder;
    }

    public void setLookingAtPlayer(boolean isLookingAtPlayer) {
        this.f_19804_.m_135381_(LOOKING_AT_PLAYER, (Object)isLookingAtPlayer);
        this.lookingAtPlayerHolder = isLookingAtPlayer;
    }

    public boolean isEating() {
        return this.eatingHolder;
    }

    public void setEating(boolean isEating) {
        this.f_19804_.m_135381_(EATING, (Object)isEating);
        this.eatingHolder = isEating;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource $$0) {
        return (SoundEvent)SoundModule.SAND_SNAPPER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundModule.SAND_SNAPPER_DEATH.get();
    }

    public void tryPlayPanicSound() {
        if (this.panicSoundCooldownTimer > 0) {
            return;
        }
        float pitch = Mth.m_216283_((RandomSource)this.m_217043_(), (float)1.0f, (float)1.2f);
        this.m_5496_((SoundEvent)SoundModule.SAND_SNAPPER_PANIC.get(), 1.0f, pitch);
        this.panicSoundCooldownTimer = 60;
    }

    private <E extends GeoAnimatable> PlayState generalPredicate(AnimationState<E> event) {
        if (this.isEmerging()) {
            if (this.isLookingAtPlayer()) {
                event.getController().setAnimation(this.EMERGE_PLAYER);
            } else {
                event.getController().setAnimation(this.EMERGE);
            }
            return PlayState.CONTINUE;
        }
        if (this.isEating()) {
            event.getController().setAnimation(this.EAT);
            return PlayState.CONTINUE;
        }
        if (this.isDiving()) {
            event.getController().setAnimation(this.DIVE);
            return PlayState.CONTINUE;
        }
        if (this.isDiggingDown()) {
            event.getController().setAnimation(this.DIG_DOWN);
            return PlayState.CONTINUE;
        }
        if (this.isDiggingUp()) {
            event.getController().setAnimation(this.DIG_UP);
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            if (this.isSubmerged()) {
                event.getController().setAnimation(this.SWIM);
            } else {
                event.getController().setAnimation(this.WALK);
            }
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    protected void m_7355_(BlockPos pos, BlockState stateOn) {
        if (this.isSubmerged()) {
            return;
        }
        super.m_7355_(pos, stateOn);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "generalController", 0, this::generalPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

