/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.foundation;

import java.util.Objects;

public class NSRange {
    public static final NSRange ZERO = new NSRange(0, 0);
    public final int location;
    public final int length;

    public NSRange(int location, int length) {
        this.location = location;
        this.length = length;
    }

    public static NSRange of(int startIndex, int endIndex) {
        int i = Math.min(startIndex, endIndex);
        int j = Math.max(startIndex, endIndex);
        return new NSRange(i, j - i);
    }

    public boolean contains(int index) {
        int diff = index - this.location;
        if (diff >= 0) {
            return diff <= this.length;
        }
        return false;
    }

    public boolean intersects(NSRange range) {
        int diff = range.location - this.location;
        if (diff > 0) {
            return diff <= this.length;
        }
        if (diff < 0) {
            return diff >= -range.length;
        }
        return true;
    }

    public int startIndex() {
        return this.location;
    }

    public int endIndex() {
        return this.location + this.length;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NSRange)) {
            return false;
        }
        NSRange that = (NSRange)o;
        return this.location == that.location && this.length == that.length;
    }

    public int hashCode() {
        return Objects.hash(this.location, this.length);
    }

    public String toString() {
        return String.format("%d ..< %d", this.startIndex(), this.endIndex());
    }
}

