/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class FontImpl {
    private final Font font;
    private final float scale;
    private final float lineHeight;

    public FontImpl(Object impl, float size) {
        this.font = (Font)impl;
        this.scale = size / 9.0f;
        Objects.requireNonNull(this.font);
        this.lineHeight = this._i2f(9);
    }

    protected static Font defaultFont() {
        return Minecraft.m_91087_().f_91062_;
    }

    public float lineHeight() {
        return this.lineHeight;
    }

    public Font impl() {
        return this.font;
    }

    public float _getScale() {
        return this.scale;
    }

    public float _getTextWidth(FormattedCharSequence value) {
        return this._i2f(this.font.m_92724_(value));
    }

    public String _getTextByWidth(String text, float width) {
        return this._getTextByWidth(text, width, false);
    }

    public String _getTextByWidth(String text, float width, boolean bl) {
        return this.font.m_92837_(text, this._f2i(width), bl);
    }

    public Style _getStyleByWidth(FormattedCharSequence value, float width) {
        return this.font.m_92865_().m_92338_(value, this._f2i(width));
    }

    public <T> List<T> _splitLines(String value, float maxWidth, boolean bl, SliceTransform<T> transformer) {
        ArrayList results = new ArrayList();
        this.font.m_92865_().m_92364_(value, this._f2i(maxWidth), Style.f_131099_, bl, (style, bi, ei) -> results.add(transformer.accept(value.substring(bi, ei), bi, ei)));
        return results;
    }

    public <T> List<T> _splitLines(Component value, float maxWidth, boolean bl, Function<FormattedCharSequence, T> transformer) {
        ArrayList<T> results = new ArrayList<T>();
        for (FormattedCharSequence seq : this.font.m_92923_((FormattedText)value, this._f2i(maxWidth))) {
            results.add(transformer.apply(seq));
        }
        return results;
    }

    private float _i2f(int size) {
        return (float)size * this.scale;
    }

    private int _f2i(float size) {
        return (int)(size / this.scale);
    }

    public static interface SliceTransform<T> {
        public T accept(String var1, int var2, int var3);
    }
}

