/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import moe.plushie.armourers_workshop.init.ModLog;

public class SelfTester {
    private static void testConvert() {
        UIWindow w = new UIWindow(new CGRect(5.0f, 5.0f, 1000.0f, 1000.0f));
        UIView p = new UIView(new CGRect(100.0f, 100.0f, 1000.0f, 1000.0f));
        UIView c1 = new UIView(new CGRect(0.0f, 40.0f, 40.0f, 40.0f));
        UIView c2 = new UIView(new CGRect(40.0f, 0.0f, 40.0f, 40.0f));
        p.addSubview(c1);
        p.addSubview(c2);
        SelfTester.assertEqual(c1.convertPointToView(CGPoint.ZERO, p), 0.0f, 40.0f);
        SelfTester.assertEqual(c2.convertPointToView(CGPoint.ZERO, p), 40.0f, 0.0f);
        SelfTester.assertEqual(c1.convertPointFromView(CGPoint.ZERO, p), 0.0f, -40.0f);
        SelfTester.assertEqual(c2.convertPointFromView(CGPoint.ZERO, p), -40.0f, 0.0f);
        SelfTester.assertEqual(c1.convertPointToView(CGPoint.ZERO, null), 0.0f, 0.0f);
        SelfTester.assertEqual(c2.convertPointToView(CGPoint.ZERO, null), 0.0f, 0.0f);
        w.addSubview(p);
        SelfTester.assertEqual(c1.convertPointToView(CGPoint.ZERO, null), 100.0f, 140.0f);
        SelfTester.assertEqual(c2.convertPointToView(CGPoint.ZERO, null), 140.0f, 100.0f);
        UIView c21 = new UIView(new CGRect(0.0f, 40.0f, 40.0f, 40.0f));
        UIView c22 = new UIView(new CGRect(40.0f, 0.0f, 40.0f, 40.0f));
        c2.addSubview(c21);
        c2.addSubview(c22);
        SelfTester.assertEqual(c21.convertPointToView(CGPoint.ZERO, null), 140.0f, 140.0f);
        SelfTester.assertEqual(c22.convertPointToView(CGPoint.ZERO, null), 180.0f, 100.0f);
        SelfTester.assertEqual(c21.convertPointFromView(CGPoint.ZERO, p), -40.0f, -40.0f);
        SelfTester.assertEqual(c22.convertPointFromView(CGPoint.ZERO, p), -80.0f, 0.0f);
        SelfTester.assertEqual(p.convertPointToView(CGPoint.ZERO, c21), -40.0f, -40.0f);
        SelfTester.assertEqual(p.convertPointToView(CGPoint.ZERO, c22), -80.0f, 0.0f);
        UIView c11 = new UIView(new CGRect(0.0f, 40.0f, 40.0f, 40.0f));
        UIView c12 = new UIView(new CGRect(40.0f, 0.0f, 40.0f, 40.0f));
        c1.setTransform(CGAffineTransform.createScale(0.5f, 0.5f));
        c1.addSubview(c11);
        c1.addSubview(c12);
        SelfTester.assertEqual(c11.convertPointToView(CGPoint.ZERO, null), 110.0f, 170.0f);
        SelfTester.assertEqual(c12.convertPointToView(CGPoint.ZERO, null), 130.0f, 150.0f);
        SelfTester.assertEqual(p.convertPointToView(CGPoint.ZERO, c11), -20.0f, -140.0f);
        SelfTester.assertEqual(p.convertPointToView(CGPoint.ZERO, c12), -60.0f, -100.0f);
        SelfTester.assertEqual(c21.convertPointToView(CGPoint.ZERO, c11), 60.0f, -60.0f);
        SelfTester.assertEqual(c22.convertPointToView(CGPoint.ZERO, c12), 100.0f, -100.0f);
        SelfTester.assertEqual(c21.convertPointFromView(CGPoint.ZERO, c11), -30.0f, 30.0f);
        SelfTester.assertEqual(c22.convertPointFromView(CGPoint.ZERO, c12), -50.0f, 50.0f);
    }

    private static void assertEqual(CGPoint p1, float x, float y) {
        CGPoint p2 = new CGPoint(x, y);
        if (p2.equals(p1)) {
            ModLog.debug("{} => {}", p1, p2);
        } else {
            ModLog.error("{} => {}", p1, p2);
        }
    }

    public static void run() {
        SelfTester.testConvert();
    }
}

