/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSIndexPath;
import com.apple.library.impl.DelegateImpl;
import com.apple.library.uikit.UIScrollView;
import com.apple.library.uikit.UITableViewCell;
import com.apple.library.uikit.UITableViewDataSource;
import com.apple.library.uikit.UITableViewDelegate;
import com.apple.library.uikit.UIView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;

public class UITableView
extends UIScrollView {
    private int rowHeight = 24;
    private boolean allowsMultipleSection = false;
    protected final DelegateImpl<UITableViewDelegate> delegate = DelegateImpl.of(new UITableViewDelegate(){});
    protected final DelegateImpl<UITableViewDataSource> dataSource = DelegateImpl.of(new UITableViewDataSource(){

        @Override
        public int tableViewNumberOfRowsInSection(UITableView tableView, int section) {
            return 0;
        }

        @Override
        public UITableViewCell tableViewCellForRow(UITableView tableView, NSIndexPath indexPath) {
            return null;
        }
    });
    private float cachedWidth = 0.0f;
    private final HashSet<NSIndexPath> selectedIndexPaths = new HashSet();
    private ArrayList<UIView> entries;
    private HashMap<NSIndexPath, UIView> indexedEntries;

    public UITableView(CGRect frame) {
        super(frame);
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        float width = this.bounds().getWidth();
        if (width != this.cachedWidth) {
            this.cachedWidth = width;
            this.reloadData();
        }
    }

    public void reloadData() {
        CGRect bounds = this.bounds();
        ArrayList<UIView> entries = new ArrayList<UIView>();
        HashMap<NSIndexPath, UITableViewCell> indexedEntries = new HashMap<NSIndexPath, UITableViewCell>();
        UITableViewDelegate delegate = this.delegate.invoker();
        UITableViewDataSource dataSource = this.dataSource.invoker();
        float height = 0.0f;
        int sections = dataSource.tableViewNumberOfSections(this);
        for (int section = 0; section < sections; ++section) {
            UIView footerView;
            UIView headerView;
            int rows = dataSource.tableViewNumberOfRowsInSection(this, section);
            float headerHeight = delegate.tableViewHeightForHeaderInSection(this, section);
            if (headerHeight != 0.0f && (headerView = delegate.tableViewViewForHeaderInSection(this, section)) != null) {
                headerView.setFrame(new CGRect(0.0f, height, bounds.width, headerHeight));
                entries.add(headerView);
                height += headerHeight;
            }
            for (int row = 0; row < rows; ++row) {
                NSIndexPath indexPath = new NSIndexPath(row, section);
                UITableViewCell cell = dataSource.tableViewCellForRow(this, indexPath);
                float rowHeight = this.heightForRow(indexPath);
                cell._setIndexPath(indexPath);
                cell.setFrame(new CGRect(0.0f, height, bounds.width, rowHeight));
                entries.add(cell);
                indexedEntries.put(indexPath, cell);
                height += rowHeight;
            }
            float footerHeight = delegate.tableViewHeightForFooterInSection(this, section);
            if (footerHeight == 0.0f || (footerView = delegate.tableViewViewForFooterInSection(this, section)) == null) continue;
            footerView.setFrame(new CGRect(0.0f, height, bounds.width, footerHeight));
            entries.add(footerView);
            height += footerHeight;
        }
        if (this.entries != null) {
            this.entries.forEach(UIView::removeFromSuperview);
        }
        this.indexedEntries = indexedEntries;
        this.entries = entries;
        this.entries.forEach(this::addSubview);
        this.setContentSize(new CGSize(0.0f, height));
    }

    public int rowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    public UITableViewDataSource dataSource() {
        return this.dataSource.get();
    }

    public void setDataSource(UITableViewDataSource dataSource) {
        this.dataSource.set(dataSource);
    }

    @Override
    public UITableViewDelegate delegate() {
        return this.delegate.get();
    }

    public void setDelegate(UITableViewDelegate delegate) {
        super.setDelegate(delegate);
        this.delegate.set(delegate);
    }

    @Nullable
    public NSIndexPath indexPathForSelectedRow() {
        return this.selectedIndexPaths.stream().findFirst().orElse(null);
    }

    @Nullable
    public Collection<NSIndexPath> indexPathsForSelectedRows() {
        return this.selectedIndexPaths;
    }

    public NSIndexPath indexPathForCell(UITableViewCell cell) {
        return cell._indexPath();
    }

    public UITableViewCell cellForRow(NSIndexPath indexPath) {
        UIView entry = this.indexedEntries.get(indexPath);
        if (entry instanceof UITableViewCell) {
            UITableViewCell cell = (UITableViewCell)entry;
            return cell;
        }
        return null;
    }

    public void selectRow(NSIndexPath indexPath, boolean animated) {
        indexPath = this.delegate.invoker().tableViewWillSelectRow(this, indexPath);
        if (indexPath == null) {
            return;
        }
        if (this.selectedIndexPaths.contains(indexPath)) {
            if (!this.allowsMultipleSection) {
                this.deselectRow(indexPath, animated);
            }
            return;
        }
        if (!this.allowsMultipleSection) {
            for (NSIndexPath indexPath1 : this.selectedIndexPaths) {
                this.deselectRow(indexPath1, animated);
            }
        }
        this.selectedIndexPaths.add(indexPath);
        this.apply(UITableViewCell::setSelected, indexPath, true);
        this.delegate.invoker().tableViewDidSelectRow(this, indexPath);
    }

    public void deselectRow(NSIndexPath indexPath, boolean animated) {
        indexPath = this.delegate.invoker().tableViewWillDeselectRow(this, indexPath);
        if (indexPath == null) {
            return;
        }
        this.selectedIndexPaths.remove(indexPath);
        this.apply(UITableViewCell::setSelected, indexPath, false);
        this.delegate.invoker().tableViewDidDeselectRow(this, indexPath);
    }

    protected void _highlightRow(NSIndexPath indexPath) {
        if (!this.delegate.invoker().tableViewShouldHighlightRow(this, indexPath)) {
            return;
        }
        this.apply(UITableViewCell::setHighlighted, indexPath, true);
        this.delegate.invoker().tableViewDidHighlightRow(this, indexPath);
    }

    protected void _unhighlightRow(NSIndexPath indexPath) {
        this.apply(UITableViewCell::setHighlighted, indexPath, false);
        this.delegate.invoker().tableViewDidUnhighlightRow(this, indexPath);
    }

    private float heightForRow(NSIndexPath indexPath) {
        float height = this.delegate.invoker().tableViewHeightForRowAt(this, indexPath);
        if (height != 0.0f) {
            return height;
        }
        return this.rowHeight;
    }

    private <T> void apply(BiConsumer<UITableViewCell, T> func, NSIndexPath indexPath, T value) {
        UITableViewCell cell = this.cellForRow(indexPath);
        if (cell != null) {
            func.accept(cell, (UITableViewCell)value);
        }
    }
}

