/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import java.util.Map;
import moe.plushie.armourers_workshop.api.client.IBlockEntityExtendedRenderer;
import moe.plushie.armourers_workshop.api.data.IDataSerializer;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.builder.block.ArmourerBlock;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.DataSerializerKey;
import moe.plushie.armourers_workshop.utils.DataTypeCodecs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SkinCubeBlockEntity
extends UpdatableBlockEntity
implements IPaintable,
IBlockEntityExtendedRenderer {
    private static final DataSerializerKey<CompoundTag> COLORS_KEY = DataSerializerKey.create("Color", DataTypeCodecs.COMPOUND_TAG, new CompoundTag());
    protected BlockPaintColor colors = new BlockPaintColor(PaintColor.WHITE);
    protected boolean customRenderer = false;

    public SkinCubeBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.colors.deserializeNBT(serializer.read(COLORS_KEY));
        this.customRenderer = this.checkRendererFromColors();
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        serializer.write(COLORS_KEY, this.colors.serializeNBT());
    }

    private boolean checkRendererFromColors() {
        for (IPaintColor color : this.colors.values()) {
            if (color.getPaintType() == SkinPaintTypes.NORMAL) continue;
            return true;
        }
        return false;
    }

    private Direction getResolvedDirection(Direction dir) {
        return switch (this.getDirection()) {
            case Direction.SOUTH -> Rotation.CLOCKWISE_180.m_55954_(dir);
            case Direction.WEST -> Rotation.CLOCKWISE_90.m_55954_(dir);
            case Direction.EAST -> Rotation.COUNTERCLOCKWISE_90.m_55954_(dir);
            default -> dir;
        };
    }

    @Override
    public IPaintColor getColor(Direction direction) {
        return this.colors.getOrDefault(this.getResolvedDirection(direction), PaintColor.WHITE);
    }

    @Override
    public void setColor(Direction direction, IPaintColor color) {
        this.colors.put(this.getResolvedDirection(direction), color);
        this.customRenderer = this.checkRendererFromColors();
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    @Override
    public void setColors(Map<Direction, IPaintColor> colors) {
        colors.forEach((direction, color) -> this.colors.put(this.getResolvedDirection((Direction)direction), (IPaintColor)color));
        this.customRenderer = this.checkRendererFromColors();
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public Direction getDirection() {
        return this.m_58900_().m_61145_((Property)ArmourerBlock.f_54117_).orElse(Direction.NORTH);
    }

    @Override
    public boolean shouldUseExtendedRenderer() {
        return this.customRenderer;
    }
}

