/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UIView;
import com.google.common.base.Objects;
import moe.plushie.armourers_workshop.api.data.IDataProperty;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentConnector;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentEditor;
import moe.plushie.armourers_workshop.builder.data.properties.DataProperty;
import moe.plushie.armourers_workshop.utils.ObjectUtils;

public class AdvancedLeftCardPanel
extends UIView {
    private final DocumentConnector connector;

    public AdvancedLeftCardPanel(DocumentEditor editor, CGRect frame) {
        super(frame);
        this.connector = editor.getConnector();
        this.setup(this.bounds());
    }

    private void setup(CGRect rect) {
        float width = rect.width;
        float height = rect.height;
        this.setupLabel(10, 18, "armourer.main.label.itemName");
        this.setupLabel(10, 50, "armourer.main.label.flavour");
        this.setupTextField(10.0f, 28.0f, width - 20.0f, "outfit-maker.skinName", this.connector.itemName);
        this.setupTextField(10.0f, 60.0f, width - 20.0f, "outfit-maker.skinFlavour", this.connector.itemFlavour);
        this.setupCheckBox(10.0f, height - 30.0f, width - 20.0f, "armourer.displaySettings.showOrigin", this.connector.showOrigin);
        this.setupCheckBox(10.0f, height - 20.0f, width - 20.0f, "armourer.displaySettings.showHelper", this.connector.showHelperModel);
    }

    private void setupLabel(int x, int y, String key) {
        UILabel label = new UILabel(new CGRect(x, y, this.bounds().getWidth(), 9.0f));
        label.setText(NSString.localizedString(key, new Object[0]));
        label.setTextColor(UIColor.WHITE);
        this.addSubview(label);
    }

    private void setupTextField(float x, float y, float width, String placeholderKey, DataProperty<String> property) {
        UITextField textField = new UITextField(new CGRect(x, y, width, 16.0f));
        textField.setMaxLength(40);
        textField.setText("");
        textField.setPlaceholder(NSString.localizedString(placeholderKey, new Object[0]));
        textField.addTarget(property, UIControl.Event.EDITING_DID_BEGIN, DataProperty::beginEditing);
        textField.addTarget(property, UIControl.Event.EDITING_DID_END, DataProperty::endEditing);
        textField.addTarget(property, UIControl.Event.VALUE_CHANGED, (it, ctr) -> {
            UITextField textField1 = (UITextField)ctr;
            it.set(textField1.text());
        });
        property.addObserver(newValue -> {
            String oldValue = textField.text();
            if (!Objects.equal((Object)oldValue, (Object)newValue)) {
                textField.setText((String)newValue);
            }
        });
        this.addSubview(textField);
    }

    private void setupCheckBox(float x, float y, float width, String key, IDataProperty<Boolean> property) {
        UICheckBox checkBox = new UICheckBox(new CGRect(x, y, width, 10.0f));
        checkBox.setTitle(NSString.localizedString(key, new Object[0]));
        checkBox.setTitleColor(UIColor.WHITE);
        checkBox.setAutoresizingMask(10);
        checkBox.setSelected(property.getOrDefault(false));
        checkBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, c) -> {
            UICheckBox checkBox1 = (UICheckBox)ObjectUtils.unsafeCast(c);
            property.set(checkBox1.isSelected());
        });
        this.addSubview(checkBox);
        property.addObserver(checkBox::setSelected);
    }
}

