/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIScrollView;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentEditor;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel.AdvancedPanel;
import moe.plushie.armourers_workshop.builder.client.gui.widget.PropertySettingView;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.utils.ObjectUtils;

public class AdvancedSettingPanel
extends AdvancedPanel {
    private static final ImmutableMap<ISkinType, Collection<ISkinProperty<?>>> VALUES = new ImmutableMap.Builder().put((Object)SkinTypes.OUTFIT, ObjectUtils.map(SkinProperty.OVERRIDE_MODEL_HEAD, SkinProperty.OVERRIDE_MODEL_CHEST, SkinProperty.OVERRIDE_MODEL_LEFT_ARM, SkinProperty.OVERRIDE_MODEL_RIGHT_ARM, SkinProperty.OVERRIDE_MODEL_LEFT_LEG, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, SkinProperty.OVERRIDE_OVERLAY_HAT, SkinProperty.OVERRIDE_OVERLAY_JACKET, SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE, SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE, SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, SkinProperty.OVERRIDE_EQUIPMENT_BOOTS, SkinProperty.OVERRIDE_EQUIPMENT_CHESTPLATE, SkinProperty.OVERRIDE_EQUIPMENT_HELMET, SkinProperty.OVERRIDE_EQUIPMENT_LEGGINGS, SkinProperty.LIMIT_LEGS_LIMBS, SkinProperty.KEEP_OVERLAY_COLOR)).put((Object)SkinTypes.ARMOR_HEAD, ObjectUtils.map(SkinProperty.OVERRIDE_MODEL_HEAD, SkinProperty.OVERRIDE_OVERLAY_HAT, SkinProperty.OVERRIDE_EQUIPMENT_HELMET, SkinProperty.KEEP_OVERLAY_COLOR)).put((Object)SkinTypes.ARMOR_CHEST, ObjectUtils.map(SkinProperty.OVERRIDE_MODEL_CHEST, SkinProperty.OVERRIDE_MODEL_LEFT_ARM, SkinProperty.OVERRIDE_MODEL_RIGHT_ARM, SkinProperty.OVERRIDE_OVERLAY_JACKET, SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE, SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE, SkinProperty.OVERRIDE_EQUIPMENT_CHESTPLATE, SkinProperty.KEEP_OVERLAY_COLOR)).put((Object)SkinTypes.ARMOR_FEET, ObjectUtils.map(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, SkinProperty.OVERRIDE_EQUIPMENT_LEGGINGS, SkinProperty.KEEP_OVERLAY_COLOR)).put((Object)SkinTypes.ARMOR_LEGS, ObjectUtils.map(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, SkinProperty.OVERRIDE_EQUIPMENT_BOOTS, SkinProperty.LIMIT_LEGS_LIMBS, SkinProperty.KEEP_OVERLAY_COLOR)).put((Object)SkinTypes.ARMOR_WINGS, ObjectUtils.map(SkinProperty.KEEP_OVERLAY_COLOR)).put((Object)SkinTypes.ITEM_SWORD, ObjectUtils.map(new ISkinProperty[0])).put((Object)SkinTypes.ITEM_SHIELD, ObjectUtils.map(new ISkinProperty[0])).put((Object)SkinTypes.ITEM_BOW, ObjectUtils.map(new ISkinProperty[0])).put((Object)SkinTypes.ITEM_TRIDENT, ObjectUtils.map(new ISkinProperty[0])).put((Object)SkinTypes.ITEM_PICKAXE, ObjectUtils.map(new ISkinProperty[0])).put((Object)SkinTypes.ITEM_AXE, ObjectUtils.map(new ISkinProperty[0])).put((Object)SkinTypes.ITEM_SHOVEL, ObjectUtils.map(new ISkinProperty[0])).put((Object)SkinTypes.ITEM_HOE, ObjectUtils.map(new ISkinProperty[0])).put((Object)SkinTypes.BLOCK, ObjectUtils.map(SkinProperty.BLOCK_GLOWING, SkinProperty.BLOCK_LADDER, SkinProperty.BLOCK_NO_COLLISION, SkinProperty.BLOCK_SEAT, SkinProperty.BLOCK_MULTIBLOCK, SkinProperty.BLOCK_BED, SkinProperty.BLOCK_ENDER_INVENTORY, SkinProperty.BLOCK_INVENTORY, SkinProperty.BLOCK_INVENTORY_WIDTH, SkinProperty.BLOCK_INVENTORY_HEIGHT)).put((Object)SkinTypes.HORSE, ObjectUtils.map(SkinProperty.OVERRIDE_MODEL_HEAD, SkinProperty.OVERRIDE_MODEL_CHEST, SkinProperty.OVERRIDE_MODEL_LEFT_FRONT_LEG, SkinProperty.OVERRIDE_MODEL_RIGHT_FRONT_LEG, SkinProperty.OVERRIDE_MODEL_LEFT_HIND_LEG, SkinProperty.OVERRIDE_MODEL_RIGHT_HIND_LEG, SkinProperty.OVERRIDE_MODEL_TAIL, SkinProperty.OVERRIDE_EQUIPMENT_CHESTPLATE, SkinProperty.KEEP_OVERLAY_COLOR)).build();
    private SkinProperties properties;
    private final ArrayList<UICheckBox> boxes = new ArrayList();
    private PropertySettingView settingView;
    private final UIScrollView scrollView = new UIScrollView(CGRect.ZERO);

    public AdvancedSettingPanel(DocumentEditor editor) {
        super(editor);
        this.barItem.setImage(UIImage.of(ModTextures.TAB_ICONS).uv(208.0f, 0.0f).fixed(16.0f, 16.0f).build());
        this.setup();
    }

    private void setup() {
        this.scrollView.setFrame(this.bounds());
        this.scrollView.setAutoresizingMask(18);
        this.insertViewAtIndex(this.scrollView, 0);
        this.editor.getConnector().addListener(this::update);
    }

    private void update(SkinDocumentNode node) {
        if (this.properties == this.document.getProperties()) {
            return;
        }
        this.properties = this.document.getProperties();
        this.addProperties(this.document.getType().getSkinType());
    }

    private void addProperties(ISkinType skinType) {
        if (this.settingView != null) {
            this.settingView.removeFromSuperview();
        }
        CGRect rect = this.scrollView.frame();
        Collection properties = (Collection)VALUES.get((Object)skinType);
        if (properties == null || properties.isEmpty()) {
            return;
        }
        this.settingView = new PropertySettingView(new CGRect(10.0f, 10.0f, rect.width - 20.0f, 0.0f), properties){

            @Override
            public void beginEditing() {
                AdvancedSettingPanel.this.editor.beginEditing();
            }

            @Override
            public <T> void putValue(ISkinProperty<T> property, T value) {
                AdvancedSettingPanel.this.document.put(property, value);
            }

            @Override
            public <T> T getValue(ISkinProperty<T> property) {
                return AdvancedSettingPanel.this.document.get(property);
            }

            @Override
            public void endEditing() {
                AdvancedSettingPanel.this.editor.endEditing();
            }
        };
        this.scrollView.addSubview(this.settingView);
        this.scrollView.setContentSize(new CGSize(0.0f, this.settingView.frame().getMaxY() + 10.0f));
    }
}

