/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIImageView;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UITextFieldDelegate;
import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.ArmourerBaseSetting;
import moe.plushie.armourers_workshop.builder.menu.ArmourerMenu;
import moe.plushie.armourers_workshop.builder.network.UpdateArmourerPacket;
import moe.plushie.armourers_workshop.core.client.gui.widget.SkinComboBox;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerMainSetting
extends ArmourerBaseSetting
implements UITextFieldDelegate {
    private static final List<ISkinType> SUPPORTED_SKIN_TYPES = new ImmutableList.Builder().add((Object)SkinTypes.ARMOR_HEAD).add((Object)SkinTypes.ARMOR_CHEST).add((Object)SkinTypes.ARMOR_LEGS).add((Object)SkinTypes.ARMOR_FEET).add((Object)SkinTypes.ARMOR_WINGS).add((Object)SkinTypes.ITEM_SWORD).add((Object)SkinTypes.ITEM_SHIELD).add((Object)SkinTypes.ITEM_BOW).add((Object)SkinTypes.ITEM_TRIDENT).add((Object)SkinTypes.ITEM_PICKAXE).add((Object)SkinTypes.ITEM_AXE).add((Object)SkinTypes.ITEM_SHOVEL).add((Object)SkinTypes.ITEM_HOE).add((Object)SkinTypes.ITEM).add((Object)SkinTypes.BLOCK).add((Object)SkinTypes.ADVANCED).build();
    private final UITextField nameTextField = new UITextField(new CGRect(8.0f, 58.0f, 158.0f, 16.0f));
    private final UITextField flavorTextField = new UITextField(new CGRect(8.0f, 90.0f, 158.0f, 16.0f));
    private final SkinComboBox skinTypeBox = new SkinComboBox(new CGRect(7.0f, 21.0f, 50.0f, 16.0f));
    protected final ArmourerMenu container;
    protected final ArmourerBlockEntity blockEntity;
    protected final String modVersion;
    protected ISkinType skinType = SkinTypes.ARMOR_HEAD;

    protected ArmourerMainSetting(ArmourerMenu container) {
        super("armourer.main");
        this.modVersion = EnvironmentManager.getVersion();
        this.container = container;
        this.blockEntity = (ArmourerBlockEntity)container.getBlockEntity();
        if (this.blockEntity != null) {
            this.skinType = this.blockEntity.getSkinType();
        }
    }

    @Override
    public void init() {
        UIButton saveBtn = new UIButton(new CGRect(88.0f, 16.0f, 50.0f, 12.0f));
        saveBtn.setTitle(this.getDisplayText("save", new Object[0]), 7);
        saveBtn.setTitleColor(UIColor.WHITE, 7);
        saveBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        saveBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerMainSetting::saveSkin);
        this.addSubview(saveBtn);
        UIButton loadBtn = new UIButton(new CGRect(88.0f, 29.0f, 50.0f, 12.0f));
        loadBtn.setTitle(this.getDisplayText("load", new Object[0]), 7);
        loadBtn.setTitleColor(UIColor.WHITE, 7);
        loadBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        loadBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerMainSetting::loadSkin);
        this.addSubview(loadBtn);
        this.nameTextField.setMaxLength(40);
        this.nameTextField.setDelegate(this);
        this.addSubview(this.nameTextField);
        this.flavorTextField.setMaxLength(40);
        this.flavorTextField.setDelegate(this);
        this.addSubview(this.flavorTextField);
        this.setupLabel(14, 48, this.getDisplayText("label.itemName", new Object[0]));
        this.setupLabel(14, 80, this.getDisplayText("label.flavour", new Object[0]));
        if (this.modVersion != null) {
            UILabel modLabel = new UILabel(new CGRect(8.0f, 131.0f, 160.0f, 9.0f));
            modLabel.setText(new NSString(this.modVersion));
            modLabel.setTextHorizontalAlignment(NSTextAlignment.Horizontal.RIGHT);
            this.addSubview(modLabel);
        }
        this.setupHelpView(6, 12, "help.skinType");
        this.setupHelpView(6, 48, "help.itemName");
        this.setupHelpView(6, 80, "help.itemFlavour");
        this.setupHelpView(81, 18, "help.save");
        this.setupHelpView(81, 30, "help.load");
        this.skinTypeBox.setMaxRows(7);
        this.skinTypeBox.reloadSkins(SUPPORTED_SKIN_TYPES);
        this.skinTypeBox.setSelectedSkin(this.skinType);
        this.skinTypeBox.addTarget(this, UIControl.Event.VALUE_CHANGED, ArmourerMainSetting::updateSkinType);
        this.addSubview(this.skinTypeBox);
        UIImageView slot1 = new UIImageView(new CGRect(63.0f, 20.0f, 18.0f, 18.0f));
        UIImageView slot2 = new UIImageView(new CGRect(142.0f, 16.0f, 26.0f, 26.0f));
        slot1.setImage(UIImage.of(ModTextures.ARMOURER).uv(238.0f, 0.0f).build());
        slot2.setImage(UIImage.of(ModTextures.ARMOURER).uv(230.0f, 18.0f).build());
        this.insertViewAtIndex(slot1, 0);
        this.insertViewAtIndex(slot2, 0);
        this.reloadData();
    }

    @Override
    public boolean textFieldShouldReturn(UITextField textField) {
        this.updateSkinPropertiesReturn();
        return true;
    }

    @Override
    public void textFieldDidEndEditing(UITextField textField) {
        this.updateSkinProperties();
    }

    @Override
    public void reloadData() {
        SkinProperties skinProperties = this.blockEntity.getSkinProperties();
        this.nameTextField.setText(skinProperties.get(SkinProperty.ALL_CUSTOM_NAME));
        this.flavorTextField.setText(skinProperties.get(SkinProperty.ALL_FLAVOUR_TEXT));
        this.skinTypeBox.setSelectedSkin(this.blockEntity.getSkinType());
    }

    private void setupLabel(int x, int y, NSString text) {
        UILabel label = new UILabel(new CGRect(x, y, this.bounds().getWidth(), 9.0f));
        label.setText(text);
        this.addSubview(label);
    }

    private void setupHelpView(int x, int y, String key) {
        UIButton button = new UIButton(new CGRect(x, y, 7.0f, 8.0f));
        button.setBackgroundImage(ModTextures.helpButtonImage(), 7);
        button.setTooltip(this.getDisplayText(key, new Object[0]));
        button.setCanBecomeFocused(false);
        this.addSubview(button);
    }

    private void updateSkinType(UIControl control) {
        ISkinType skinType = this.skinTypeBox.selectedSkin();
        if (Objects.equals(skinType, this.skinType)) {
            return;
        }
        this.skinType = skinType;
        if (this.blockEntity == null) {
            return;
        }
        this.blockEntity.setSkinType(skinType);
        NetworkManager.sendToServer(UpdateArmourerPacket.Field.SKIN_TYPE.buildPacket(this.blockEntity, skinType));
    }

    private void updateSkinProperties() {
        SkinProperties newValue = this.blockEntity.getSkinProperties().copy();
        newValue.put(SkinProperty.ALL_CUSTOM_NAME, this.nameTextField.text());
        newValue.put(SkinProperty.ALL_FLAVOUR_TEXT, this.flavorTextField.text());
        if (newValue.equals(this.blockEntity.getSkinProperties())) {
            return;
        }
        this.blockEntity.setSkinProperties(newValue);
        NetworkManager.sendToServer(UpdateArmourerPacket.Field.SKIN_PROPERTIES.buildPacket(this.blockEntity, newValue));
    }

    private void loadSkin(UIControl sender) {
        Player player = EnvironmentManager.getPlayer();
        if (player == null || !this.container.shouldLoadArmourItem(player)) {
            return;
        }
        NetworkManager.sendToServer(UpdateArmourerPacket.Field.ITEM_LOAD.buildPacket(this.blockEntity, new CompoundTag()));
    }

    private void saveSkin(UIControl sender) {
        Player player = EnvironmentManager.getPlayer();
        if (player == null || !this.container.shouldSaveArmourItem(player)) {
            return;
        }
        GameProfile origin = Minecraft.m_91087_().m_91094_().m_92548_();
        CompoundTag nbt = DataSerializers.writeGameProfile(new CompoundTag(), origin);
        NetworkManager.sendToServer(UpdateArmourerPacket.Field.ITEM_SAVE.buildPacket(this.blockEntity, nbt));
    }

    private void updateSkinPropertiesReturn() {
        this.nameTextField.resignFirstResponder();
        this.flavorTextField.resignFirstResponder();
    }
}

