/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer.guide;

import java.util.HashMap;
import moe.plushie.armourers_workshop.api.client.guide.IGuideRenderer;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.AbstractGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.ChestGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.FeetGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.HeadGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.HeldItemGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.WingsGuideRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuideRendererManager {
    private final HashMap<ISkinPartType, IGuideRenderer> renderers = new HashMap();

    public GuideRendererManager() {
        this.register(new HeadGuideRenderer());
        this.register(new ChestGuideRenderer());
        this.register(new FeetGuideRenderer());
        this.register(new HeldItemGuideRenderer());
        this.register(new WingsGuideRenderer());
    }

    private void register(AbstractGuideRenderer renderer) {
        renderer.init(this);
    }

    public void register(ISkinPartType partType, IGuideRenderer renderer) {
        this.renderers.put(partType, renderer);
    }

    public IGuideRenderer getRenderer(ISkinPartType partType) {
        return this.renderers.get(partType);
    }
}

