/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer.panel;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UISliderBox;
import com.apple.library.uikit.UIView;
import java.util.ArrayList;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerBaseSkinPanel
extends UIView {
    protected final SkinProperties skinProperties;
    protected final ArrayList<AbstractWidget> widgets = new ArrayList();
    protected int cursorX = 0;
    protected int cursorY = 0;
    protected Consumer<SkinProperties> applier;

    public ArmourerBaseSkinPanel(SkinProperties skinProperties) {
        super(CGRect.ZERO);
        this.skinProperties = skinProperties;
    }

    public void init() {
        this.widgets.clear();
        this.cursorX = 10;
        this.cursorY = 20;
    }

    public void apply() {
        if (this.applier != null) {
            this.applier.accept(this.skinProperties);
        }
    }

    public Consumer<SkinProperties> getApplier() {
        return this.applier;
    }

    public void setApplier(Consumer<SkinProperties> applier) {
        this.applier = applier;
    }

    protected UISliderBox addSliderBox(int x, int y, int width, int height, double minValue, double maxValue, String suffix, SkinProperty<Double> property) {
        UISliderBox slider = new UISliderBox(new CGRect(this.cursorX + x, this.cursorY + y, width, height));
        slider.setFormatter(value -> {
            String formattedValue = String.format("%.0f%s", value, suffix);
            return new NSString(formattedValue);
        });
        slider.setMaxValue(maxValue);
        slider.setMinValue(minValue);
        slider.setValue(this.skinProperties.get(property));
        slider.addTarget(this, UIControl.Event.EDITING_DID_END, (self, box) -> {
            double value = ((UISliderBox)box).value();
            this.skinProperties.put(property, value);
            this.apply();
        });
        this.addSubview(slider);
        this.cursorY += 2;
        return slider;
    }

    protected UICheckBox addCheckBox(int x, int y, SkinProperty<Boolean> property) {
        boolean oldValue = this.skinProperties.get(property);
        UICheckBox checkBox = new UICheckBox(new CGRect(this.cursorX + x, this.cursorY + y, 156 - x, 9.0f));
        checkBox.setTitle(this.getDisplayText(property.getKey(), new Object[0]));
        checkBox.setSelected(oldValue);
        checkBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, box) -> {
            boolean value = box.isSelected();
            self.skinProperties.put(property, value);
            this.apply();
        });
        this.addSubview(checkBox);
        this.cursorY += 4;
        return checkBox;
    }

    protected UILabel addLabel(int x, int y, NSString message) {
        UILabel label = new UILabel(new CGRect(this.cursorX + x, this.cursorY + y, 156 - x, 9.0f));
        label.setText(message);
        this.addSubview(label);
        return label;
    }

    @Override
    public void addSubview(UIView view) {
        super.addSubview(view);
        this.cursorY = (int)((float)this.cursorY + (view.bounds().getHeight() + 2.0f));
    }

    protected NSString getDisplayText(String key, Object ... objects) {
        return NSString.localizedString("armourer.skinSettings." + key, objects);
    }
}

