/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import com.apple.library.uikit.UIColor;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaintingHighlightPlacementRenderer {
    public static void renderPaintTool(ItemStack itemStack, Player player, BlockHitResult traceResult, Camera renderInfo, IPoseStack poseStack, IBufferSource bufferSource) {
        float z1;
        float y1;
        float x1;
        float z0;
        float y0;
        float x0;
        Level level = PropertyProvider.getLevel((Entity)player);
        BlockPos pos = traceResult.m_82425_();
        Direction direction = traceResult.m_82434_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof IPaintable)) {
            return;
        }
        Integer radiusSample = ToolAPI.get(itemStack, PaintingToolOptions.RADIUS_SAMPLE);
        Integer radiusEffect = ToolAPI.get(itemStack, PaintingToolOptions.RADIUS_EFFECT);
        Boolean restrictPlane = ToolAPI.get(itemStack, PaintingToolOptions.PLANE_RESTRICT);
        ArrayList<BlockPos> blockSamples = BlockUtils.findTouchingBlockFaces(level, pos, direction, radiusSample, restrictPlane);
        ArrayList<BlockPos> blockEffects = BlockUtils.findTouchingBlockFaces(level, pos, direction, radiusEffect, restrictPlane);
        poseStack.pushPose();
        Vector3f origin = new Vector3f((Position)renderInfo.m_90583_());
        IVertexConsumer builder = bufferSource.getBuffer(SkinRenderType.HIGHLIGHTED_LINES);
        poseStack.translate(-origin.getX(), -origin.getY(), -origin.getZ());
        poseStack.translate(0.5f, 0.5f, 0.5f);
        for (BlockPos pos1 : blockSamples) {
            x0 = (float)pos1.m_123341_() - 0.5f;
            y0 = (float)pos1.m_123342_() - 0.5f;
            z0 = (float)pos1.m_123343_() - 0.5f;
            x1 = (float)pos1.m_123341_() + 0.5f;
            y1 = (float)pos1.m_123342_() + 0.5f;
            z1 = (float)pos1.m_123343_() + 0.5f;
            ShapeTesselator.fill(x0, y0, z0, x1, y1, z1, UIColor.RED, poseStack, builder);
        }
        for (BlockPos pos1 : blockEffects) {
            x0 = (float)pos1.m_123341_() - 0.4f;
            y0 = (float)pos1.m_123342_() - 0.4f;
            z0 = (float)pos1.m_123343_() - 0.4f;
            x1 = (float)pos1.m_123341_() + 0.4f;
            y1 = (float)pos1.m_123342_() + 0.4f;
            z1 = (float)pos1.m_123343_() + 0.4f;
            ShapeTesselator.fill(x0, y0, z0, x1, y1, z1, UIColor.GREEN, poseStack, builder);
        }
        poseStack.popPose();
    }
}

