/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.api.painting.IBlockPaintViewer;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.registry.IRegistryHolder;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.item.AbstractColoredToolItem;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolAction;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolSelector;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubePaintingEvent;
import moe.plushie.armourers_workshop.builder.other.CubeSelector;
import moe.plushie.armourers_workshop.builder.other.CubeWrapper;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.init.ModSounds;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlendingToolItem
extends AbstractColoredToolItem
implements IBlockPaintViewer {
    public BlendingToolItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void createToolProperties(Consumer<IConfigurableToolProperty<?>> builder) {
        builder.accept(PaintingToolOptions.INTENSITY);
        builder.accept(PaintingToolOptions.RADIUS_SAMPLE);
        builder.accept(PaintingToolOptions.RADIUS_EFFECT);
        builder.accept(PaintingToolOptions.PLANE_RESTRICT);
        builder.accept(PaintingToolOptions.FULL_BLOCK_MODE);
    }

    protected CubeSelector createColorApplierSelector(int radius, UseOnContext context) {
        ItemStack itemStack = context.m_43722_();
        Boolean restrictPlane = ToolAPI.get(itemStack, PaintingToolOptions.PLANE_RESTRICT);
        boolean isFullMode = this.shouldUseFullMode(context);
        return CubeSelector.touching(context.m_8083_(), radius, isFullMode, restrictPlane);
    }

    @Override
    public IPaintToolSelector createPaintToolSelector(BlockEntity blockEntity, UseOnContext context) {
        if (blockEntity instanceof ArmourerBlockEntity) {
            return null;
        }
        return super.createPaintToolSelector(blockEntity, context);
    }

    @Override
    public IPaintToolSelector createPaintToolSelector(UseOnContext context) {
        ItemStack itemStack = context.m_43722_();
        Integer radiusEffect = ToolAPI.get(itemStack, PaintingToolOptions.RADIUS_EFFECT);
        return this.createColorApplierSelector(radiusEffect, context);
    }

    @Override
    public IPaintToolAction createPaintToolAction(UseOnContext context) {
        ItemStack itemStack = context.m_43722_();
        Integer intensity = ToolAPI.get(itemStack, PaintingToolOptions.INTENSITY);
        Integer radiusSample = ToolAPI.get(itemStack, PaintingToolOptions.RADIUS_SAMPLE);
        ArrayList<Integer> colors = new ArrayList<Integer>();
        CubeChangesCollector collector = new CubeChangesCollector(context.m_43725_());
        this.createColorApplierSelector(radiusSample, context).forEach(context, (targetPos, dir) -> {
            IPaintColor paintColor;
            CubeWrapper cube = collector.getCube((BlockPos)targetPos);
            if (cube.shouldChangeColor((Direction)dir) && (paintColor = cube.getColor((Direction)dir)) != null) {
                colors.add(paintColor.getRGB());
            }
        });
        PaintColor paintColor = PaintColor.of(ColorUtils.getAverageColor(colors), SkinPaintTypes.NORMAL);
        return new CubePaintingEvent.BlendingAction(paintColor, intensity);
    }

    @Override
    public void appendSettingHoverText(ItemStack itemStack, List<Component> tooltips) {
        int intensity = ToolAPI.get(itemStack, PaintingToolOptions.INTENSITY);
        int radiusSample = ToolAPI.get(itemStack, PaintingToolOptions.RADIUS_SAMPLE);
        int radiusEffect = ToolAPI.get(itemStack, PaintingToolOptions.RADIUS_EFFECT);
        tooltips.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.intensity", intensity));
        tooltips.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.sampleRadius", radiusSample, radiusSample, 1));
        tooltips.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.effectRadius", radiusEffect, radiusEffect, 1));
        super.appendSettingHoverText(itemStack, tooltips);
    }

    @Override
    public IRegistryHolder<SoundEvent> getItemSoundEvent(UseOnContext context) {
        return ModSounds.PAINT;
    }
}

