/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.menu;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Map;
import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.api.math.ITexturePos;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinPartTypeTextured;
import moe.plushie.armourers_workshop.builder.blockentity.OutfitMakerBlockEntity;
import moe.plushie.armourers_workshop.core.data.UserNotifications;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlot;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.exception.SkinLoadException;
import moe.plushie.armourers_workshop.core.skin.exception.TranslatableException;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.texture.SkinPaintData;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class OutfitMakerMenu
extends AbstractBlockEntityMenu<OutfitMakerBlockEntity> {
    private final Container inventory;

    public OutfitMakerMenu(MenuType<?> menuType, Block block, int containerId, Inventory playerInventory, IGlobalPos access) {
        super((MenuType)menuType, block, containerId, access);
        this.inventory = ((OutfitMakerBlockEntity)this.blockEntity).getInventory();
        this.addPlayerSlots((Container)playerInventory, 8, 158);
        this.addInputSlots(this.inventory, 0, this.inventory.m_6643_() - 1, 36, 58);
        this.addOutputSlot(this.inventory, this.inventory.m_6643_() - 1, 148, 88);
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        return this.quickMoveStack(player, index, this.f_38839_.size() - 1);
    }

    public boolean shouldCrafting() {
        if (!this.getOutputStack().m_41619_()) {
            return false;
        }
        for (ItemStack itemStack : this.getInputStacks()) {
            if (itemStack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    public void saveArmourItem(Player player, GameProfile profile) {
        if (!this.shouldCrafting()) {
            return;
        }
        try {
            this.saveArmourItemWithProfile(profile, (OutfitMakerBlockEntity)this.blockEntity);
        }
        catch (TranslatableException exception) {
            player.m_213846_(exception.getComponent());
            UserNotifications.sendErrorMessage(exception.getComponent(), player);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void saveArmourItemWithProfile(GameProfile profile, OutfitMakerBlockEntity blockEntity) throws Exception {
        ArrayList<SkinPart> skinParts = new ArrayList<SkinPart>();
        SkinProperties skinProperties = new SkinProperties();
        Object partIndexs = "";
        SkinPaintData paintData = null;
        int skinIndex = 0;
        for (ItemStack itemStack : this.getInputStacks()) {
            SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
            Skin skin = SkinLoader.getInstance().loadSkin(descriptor.getIdentifier());
            if (skin == null) continue;
            if (skin.getVersion() >= 20) {
                throw SkinLoadException.Type.NOT_SUPPORTED.build("notSupported", new Object[0]);
            }
            if (!skin.getSettings().isEditable()) {
                throw SkinLoadException.Type.NOT_EDITABLE.build("notEditable", new Object[0]);
            }
            for (int partIndex = 0; partIndex < skin.getPartCount(); ++partIndex) {
                SkinPart skinPart = skin.getParts().get(partIndex);
                skinParts.add(skinPart);
            }
            if (skin.getPaintData() != null) {
                if (paintData == null) {
                    paintData = SkinPaintData.v2();
                }
                for (ISkinPartType iSkinPartType : skin.getType().getParts()) {
                    if (!(iSkinPartType instanceof ISkinPartTypeTextured)) continue;
                    ISkinPartTypeTextured texType = (ISkinPartTypeTextured)iSkinPartType;
                    this.mergePaintPart(texType, paintData, skin.getPaintData());
                }
            }
            partIndexs = ((String)partIndexs).isEmpty() ? String.valueOf(skinParts.size()) : (String)partIndexs + ":" + skinParts.size();
            for (Map.Entry<String, Object> entry : skin.getProperties().entrySet()) {
                if (entry.getKey().startsWith("wings")) {
                    skinProperties.put(entry.getKey() + skinIndex, entry.getValue());
                    continue;
                }
                skinProperties.put(entry.getKey(), entry.getValue());
            }
            ++skinIndex;
        }
        if (paintData != null) {
            SkinPaintData resolvedPaintData = SkinPaintData.v1();
            resolvedPaintData.copyFrom(paintData);
            paintData = resolvedPaintData;
        }
        if (!skinParts.isEmpty()) {
            skinProperties.put(SkinProperty.OUTFIT_PART_INDEXS, partIndexs);
            skinProperties.put(SkinProperty.ALL_AUTHOR_NAME, profile.getName());
            if (profile.getId() != null) {
                skinProperties.put(SkinProperty.ALL_AUTHOR_UUID, profile.getId().toString());
            }
            skinProperties.put(SkinProperty.ALL_CUSTOM_NAME, blockEntity.getItemName());
            skinProperties.put(SkinProperty.ALL_FLAVOUR_TEXT, blockEntity.getItemFlavour());
            Skin.Builder builder = new Skin.Builder(SkinTypes.OUTFIT);
            builder.properties(skinProperties);
            builder.paintData(paintData);
            builder.parts(skinParts);
            Skin skin = builder.build();
            String identifier = SkinLoader.getInstance().saveSkin("", skin);
            SkinDescriptor descriptor = new SkinDescriptor(identifier, skin.getType());
            this.setOutputStack(descriptor.asItemStack());
        }
    }

    protected void addInputSlots(Container inventory, int start, int end, int x, int y) {
        SkinSlotType[] skinTypes = new SkinSlotType[]{SkinSlotType.HEAD, SkinSlotType.CHEST, SkinSlotType.LEGS, SkinSlotType.FEET, SkinSlotType.WINGS};
        for (int i = start; i < end; ++i) {
            int col = i % 5;
            int row = i / 5;
            this.m_38897_(new SkinSlot(inventory, i, x + col * 20, y + row * 20, skinTypes));
        }
    }

    protected void addOutputSlot(Container inventory, int slot, int x, int y) {
        this.m_38897_(new Slot(inventory, slot, x, y){});
    }

    protected ItemStack getOutputStack() {
        Slot outputSlot = (Slot)this.f_38839_.get(this.f_38839_.size() - 1);
        return outputSlot.m_7993_();
    }

    protected void setOutputStack(ItemStack itemStack) {
        Slot outputSlot = (Slot)this.f_38839_.get(this.f_38839_.size() - 1);
        outputSlot.m_5852_(itemStack);
    }

    protected Iterable<ItemStack> getInputStacks() {
        return Iterables.transform((Iterable)Iterables.skip((Iterable)Iterables.limit((Iterable)this.f_38839_, (int)(this.f_38839_.size() - 1)), (int)36), Slot::m_7993_);
    }

    private void mergePaintPart(ISkinPartTypeTextured texType, SkinPaintData desPaint, SkinPaintData srcPaint) {
        ITexturePos pos = texType.getTextureSkinPos();
        int width = texType.getTextureModelSize().getX() * 2 + texType.getTextureModelSize().getZ() * 2;
        int height = texType.getTextureModelSize().getY() + texType.getTextureModelSize().getZ();
        for (int ix = 0; ix < width; ++ix) {
            for (int iy = 0; iy < height; ++iy) {
                int y;
                int x = pos.getU() + ix;
                int color = srcPaint.getColor(x, y = pos.getV() + iy);
                if (!PaintColor.isOpaque(color)) continue;
                desPaint.setColor(x, y, color);
            }
        }
    }
}

