/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.AdvancedBuilderMenu;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.utils.SkinFileStreamUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AdvancedImportPacket
extends CustomPacket {
    private final BlockPos pos;
    private final Skin skin;
    private final String target;

    public AdvancedImportPacket(AdvancedBuilderBlockEntity blockEntity, Skin skin, String target) {
        this.pos = blockEntity.m_58899_();
        this.skin = skin;
        this.target = target;
    }

    public AdvancedImportPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.target = buffer.readUtf();
        this.skin = this.decodeSkin(buffer);
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeUtf(this.target);
        this.encodeSkin(buffer);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        AdvancedBuilderBlockEntity blockEntity1;
        block10: {
            block9: {
                BlockEntity blockEntity = PropertyProvider.getLevel((Entity)player).m_7702_(this.pos);
                if (!(blockEntity instanceof AdvancedBuilderBlockEntity)) break block9;
                blockEntity1 = (AdvancedBuilderBlockEntity)blockEntity;
                if (player.f_36096_ instanceof AdvancedBuilderMenu && this.skin != null) break block10;
            }
            this.abort((Player)player, "unauthorized", "user status is incorrect or the skin is invalid");
            return;
        }
        SkinLibraryManager.Server server = SkinLibraryManager.getServer();
        if (!server.shouldUploadFile((Player)player)) {
            this.abort((Player)player, "import", "uploading prohibited in the config file");
            return;
        }
        if (!ModPermissions.ADVANCED_SKIN_BUILDER_SKIN_IMPORT.accept((Player)player)) {
            this.abort((Player)player, "import", "prohibited by the config file");
            return;
        }
        if (!this.skin.getSettings().isEditable()) {
            this.abort((Player)player, "import", "prohibited by the skin can't editing.");
            return;
        }
        SkinDocumentNode node = null;
        if (!this.target.isEmpty() && (node = blockEntity1.getDocument().nodeById(this.target)) == null) {
            this.abort((Player)player, "import", "can't found node.");
            return;
        }
        this.accept((Player)player, "import");
        String identifier = SkinLoader.getInstance().saveSkin("", this.skin);
        if (node != null) {
            blockEntity1.importToNode(identifier, this.skin, node);
        } else {
            blockEntity1.importToDocument(identifier, this.skin);
        }
    }

    private void accept(Player player, String op) {
        ModLog.info("accept {} request of the '{}'", op, player.m_6302_());
    }

    private void abort(Player player, String op, String reason) {
        ModLog.info("abort {} request of the '{}', reason: '{}'", op, player.m_6302_(), reason);
    }

    private void encodeSkin(IFriendlyByteBuf buffer) {
        try {
            GZIPOutputStream stream = new GZIPOutputStream((OutputStream)new ByteBufOutputStream(buffer.asByteBuf()));
            SkinFileStreamUtils.saveSkinToStream(stream, this.skin);
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Skin decodeSkin(IFriendlyByteBuf buffer) {
        try {
            GZIPInputStream stream = new GZIPInputStream((InputStream)new ByteBufInputStream(buffer.asByteBuf()));
            Skin skin = SkinFileStreamUtils.loadSkinFromStream(stream);
            stream.close();
            return skin;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

