/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolSelector;
import moe.plushie.armourers_workshop.init.ModBlocks;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class CubeSelector
implements IPaintToolSelector {
    final BlockPos blockPos;
    final MatchMode mode;
    final ArrayList<Rectangle3i> rects;
    final int radius;
    final boolean isPlaneOnly;
    final boolean isApplyAllFaces;

    protected CubeSelector(MatchMode mode, BlockPos blockPos, int radius, boolean isApplyAllFaces, boolean isPlaneOnly) {
        this.blockPos = blockPos;
        this.mode = mode;
        this.radius = Math.max(radius, 1);
        this.isApplyAllFaces = isApplyAllFaces;
        this.isPlaneOnly = isPlaneOnly;
        this.rects = new ArrayList();
    }

    protected CubeSelector(MatchMode mode, Iterable<Rectangle3i> rects) {
        this.blockPos = BlockPos.f_121853_;
        this.mode = mode;
        this.radius = 0;
        this.isApplyAllFaces = true;
        this.isPlaneOnly = false;
        this.rects = Lists.newArrayList(rects);
    }

    protected CubeSelector(IFriendlyByteBuf buffer) {
        this.blockPos = buffer.readBlockPos();
        this.mode = buffer.readEnum(MatchMode.class);
        this.radius = buffer.readInt();
        this.isApplyAllFaces = buffer.readBoolean();
        this.isPlaneOnly = buffer.readBoolean();
        this.rects = new ArrayList();
        if (this.mode == MatchMode.ALL) {
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                int x = buffer.readInt();
                int y = buffer.readInt();
                int z = buffer.readInt();
                int width = buffer.readInt();
                int height = buffer.readInt();
                int depth = buffer.readInt();
                this.rects.add(new Rectangle3i(x, y, z, width, height, depth));
            }
        }
    }

    public static CubeSelector from(IFriendlyByteBuf buffer) {
        return new CubeSelector(buffer);
    }

    public static CubeSelector box(BlockPos pos, boolean isApplyAllFaces) {
        return CubeSelector.box(pos, 1, isApplyAllFaces);
    }

    public static CubeSelector box(BlockPos pos, int radius, boolean isApplyAllFaces) {
        return new CubeSelector(MatchMode.SAME, pos, radius, isApplyAllFaces, false);
    }

    public static CubeSelector all(Iterable<Rectangle3i> rects) {
        return new CubeSelector(MatchMode.ALL, rects);
    }

    public static CubeSelector plane(BlockPos pos, int radius, boolean isApplyAllFaces) {
        return new CubeSelector(MatchMode.SAME, pos, radius, isApplyAllFaces, true);
    }

    public static CubeSelector touching(BlockPos pos, int radius, boolean isApplyAllFaces, boolean isPlaneOnly) {
        return new CubeSelector(MatchMode.TOUCHING, pos, radius, isApplyAllFaces, isPlaneOnly);
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.blockPos);
        buffer.writeEnum(this.mode);
        buffer.writeInt(this.radius);
        buffer.writeBoolean(this.isApplyAllFaces);
        buffer.writeBoolean(this.isPlaneOnly);
        if (this.mode == MatchMode.ALL) {
            buffer.writeInt(this.rects.size());
            for (Rectangle3i rect : this.rects) {
                buffer.writeInt(rect.getX());
                buffer.writeInt(rect.getY());
                buffer.writeInt(rect.getZ());
                buffer.writeInt(rect.getWidth());
                buffer.writeInt(rect.getHeight());
                buffer.writeInt(rect.getDepth());
            }
        }
    }

    @Override
    public void forEach(UseOnContext context, BiConsumer<BlockPos, Direction> consumer) {
        Level level = context.m_43725_();
        Direction clickedFace = context.m_43719_();
        Direction[] dirs = this.resolvedDirections(clickedFace);
        this.forEach(level, clickedFace, targetPos -> {
            for (Direction dir : dirs) {
                consumer.accept((BlockPos)targetPos, dir);
            }
        });
    }

    private void forEach(Level level, Direction dir, Consumer<BlockPos> consumer) {
        switch (this.mode.ordinal()) {
            case 0: {
                for (Rectangle3i rect : this.rects) {
                    for (Vector3i pos : rect.enumerateZYX()) {
                        consumer.accept(pos.asBlockPos());
                    }
                }
                break;
            }
            case 1: {
                Object info = this.resolvedBlockInfo(level, this.blockPos);
                Consumer<BlockPos> consumer1 = targetPos -> {
                    if (Objects.equals(info, this.resolvedBlockInfo(level, (BlockPos)targetPos))) {
                        consumer.accept((BlockPos)targetPos);
                    }
                };
                if (this.isPlaneOnly) {
                    for (int j = -this.radius + 1; j < this.radius; ++j) {
                        for (int i = -this.radius + 1; i < this.radius; ++i) {
                            consumer1.accept(this.resolvedPos(dir, i, j));
                        }
                    }
                } else {
                    for (int iy = -this.radius + 1; iy < this.radius; ++iy) {
                        for (int ix = -this.radius + 1; ix < this.radius; ++ix) {
                            for (int iz = -this.radius + 1; iz < this.radius; ++iz) {
                                consumer1.accept(this.blockPos.m_7918_(ix, iy, iz));
                            }
                        }
                    }
                }
                break;
            }
            case 2: {
                BlockUtils.findTouchingBlockFaces(level, this.blockPos, dir, this.radius, this.isPlaneOnly).forEach(consumer);
            }
        }
    }

    private BlockPos resolvedPos(Direction dir, int i, int j) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP, Direction.DOWN -> this.blockPos.m_7918_(j, 0, i);
            case Direction.NORTH, Direction.SOUTH -> this.blockPos.m_7918_(i, j, 0);
            case Direction.WEST, Direction.EAST -> this.blockPos.m_7918_(0, i, j);
        };
    }

    private Direction[] resolvedDirections(Direction clickedFace) {
        if (!this.isApplyAllFaces) {
            return new Direction[]{clickedFace};
        }
        return Direction.values();
    }

    private Object resolvedBlockInfo(Level level, BlockPos pos) {
        if (this.radius == 1) {
            return null;
        }
        return level.m_8055_(pos).m_60713_((Block)ModBlocks.BOUNDING_BOX.get());
    }

    protected static enum MatchMode {
        ALL,
        SAME,
        TOUCHING;

    }
}

