/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.common.IWorldUpdateTask;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class WorldUpdater {
    private static final WorldUpdater INSTANCE = new WorldUpdater();
    private final LinkedList<IWorldUpdateTask> failedTasks = new LinkedList();
    private final HashMap<ResourceKey<Level>, AutoMergeQueue> allTasks = new HashMap();

    public static WorldUpdater getInstance() {
        return INSTANCE;
    }

    public synchronized void submit(IWorldUpdateTask task) {
        this.allTasks.computeIfAbsent((ResourceKey<Level>)task.getLevel().m_46472_(), k -> new AutoMergeQueue()).push(task);
    }

    public void tick(Level level) {
        ResourceKey key = level.m_46472_();
        if (this.isEmpty((ResourceKey<Level>)key)) {
            return;
        }
        BlockUtils.performBatch(() -> {
            IWorldUpdateTask task;
            int count = ModConfig.Common.blockTaskRate;
            while (count > 0 && (task = this.poll((ResourceKey<Level>)key)) != null) {
                InteractionResult resultType = task.run(level);
                if (resultType.m_19077_()) {
                    --count;
                    continue;
                }
                if (resultType != InteractionResult.FAIL) continue;
                this.failedTasks.add(task);
            }
            if (!this.failedTasks.isEmpty()) {
                this.failedTasks.forEach(this::submit);
                this.failedTasks.clear();
            }
        });
    }

    public synchronized void drain(Level level) {
        AutoMergeQueue queue = this.allTasks.remove(level.m_46472_());
        if (queue == null || queue.isEmpty()) {
            return;
        }
        BlockUtils.performBatch(() -> {
            while (!queue.isEmpty()) {
                queue.pop().run(level);
            }
        });
    }

    public synchronized boolean isEmpty(ResourceKey<Level> key) {
        AutoMergeQueue m = this.allTasks.get(key);
        return m == null || m.isEmpty();
    }

    @Nullable
    public synchronized IWorldUpdateTask poll(ResourceKey<Level> key) {
        AutoMergeQueue m = this.allTasks.get(key);
        if (m != null && !m.isEmpty()) {
            return m.pop();
        }
        return null;
    }

    public static class AutoMergeQueue {
        private final HashMap<BlockPos, IWorldUpdateTask> fastTable = new HashMap();
        private final ArrayList<IWorldUpdateTask> tasks = new ArrayList();

        public void push(IWorldUpdateTask task) {
            BlockPos blockPos = task.getBlockPos();
            IWorldUpdateTask pendingTask = this.fastTable.get(blockPos);
            if (pendingTask == null) {
                this.tasks.add(task);
                this.fastTable.put(blockPos, task);
                return;
            }
            if (pendingTask instanceof AutoMergeTask) {
                AutoMergeTask mergeTask = (AutoMergeTask)pendingTask;
                mergeTask.add(task);
                return;
            }
            AutoMergeTask mergedTask = new AutoMergeTask(pendingTask);
            mergedTask.add(task);
            this.fastTable.put(blockPos, mergedTask);
        }

        public IWorldUpdateTask pop() {
            IWorldUpdateTask task = this.tasks.remove(0);
            IWorldUpdateTask mergedTask = this.fastTable.remove(task.getBlockPos());
            if (mergedTask != null) {
                return mergedTask;
            }
            return task;
        }

        public boolean isEmpty() {
            return this.tasks.isEmpty();
        }
    }

    public static class AutoMergeTask
    implements IWorldUpdateTask {
        private final Level level;
        private final BlockPos blockPos;
        private final ArrayList<IWorldUpdateTask> tasks = new ArrayList();

        public AutoMergeTask(IWorldUpdateTask task) {
            this.level = task.getLevel();
            this.blockPos = task.getBlockPos();
            this.tasks.add(task);
        }

        public void add(IWorldUpdateTask task) {
            this.tasks.add(task);
        }

        public void optimize(Level level) {
            ArrayList<IWorldUpdateTask> optimizedTasks = new ArrayList<IWorldUpdateTask>();
            BlockState lastBlockState = null;
            for (IWorldUpdateTask task : this.tasks) {
                BlockState newBlockState = task.getBlockState();
                if (!Objects.equals(newBlockState, lastBlockState)) {
                    lastBlockState = newBlockState;
                    optimizedTasks.clear();
                }
                optimizedTasks.add(task);
            }
            if (this.tasks.size() != optimizedTasks.size()) {
                this.tasks.clear();
                this.tasks.addAll(optimizedTasks);
            }
        }

        @Override
        public Level getLevel() {
            return this.level;
        }

        @Override
        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        @Override
        public BlockState getBlockState() {
            return null;
        }

        @Override
        public InteractionResult run(Level level) {
            this.optimize(level);
            int changes = 0;
            ArrayList<IWorldUpdateTask> failedTasks = new ArrayList<IWorldUpdateTask>();
            for (IWorldUpdateTask task : this.tasks) {
                InteractionResult resultType = task.run(level);
                if (resultType.m_19077_()) {
                    ++changes;
                }
                if (resultType != InteractionResult.FAIL) continue;
                failedTasks.add(task);
            }
            if (!failedTasks.isEmpty()) {
                this.tasks.clear();
                this.tasks.addAll(failedTasks);
                return InteractionResult.FAIL;
            }
            if (changes != 0) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
    }
}

