/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.config.IConfigBuilder;
import moe.plushie.armourers_workshop.api.config.IConfigSpec;
import moe.plushie.armourers_workshop.api.config.IConfigValue;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.ObjectUtils;

public class AbstractConfigSpec
implements IConfigSpec {
    private Object spec;
    private Runnable saver;
    private Map<String, Object> snapshot;
    private final Type type;
    private final ArrayList<Runnable> listeners = new ArrayList();
    private final HashMap<String, Value<Object>> values;

    public AbstractConfigSpec(Type type, HashMap<String, Value<Object>> values) {
        this.type = type;
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AbstractConfigSpec) {
            AbstractConfigSpec spec1 = (AbstractConfigSpec)o;
            return Objects.equals(this.spec, spec1.spec);
        }
        return Objects.equals(this.spec, o);
    }

    public int hashCode() {
        return Objects.hashCode(this.spec);
    }

    @Override
    public Map<String, Object> snapshot() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        this.values.forEach((key, value) -> {
            if (value.getter != null) {
                fields.put((String)key, value.getter.get());
            } else {
                fields.put((String)key, value.defaultValue);
            }
        });
        return fields;
    }

    @Override
    public void apply(Map<String, Object> snapshot) {
        this.snapshot = snapshot;
        if (this.snapshot == null) {
            this.reload();
            return;
        }
        ModLog.debug("apply {} snapshot from server", new Object[]{this.type});
        snapshot.forEach((key, object) -> {
            Value<Object> value = this.values.get(key);
            if (value != null && value.setter != null) {
                value.setter.accept(object);
            }
        });
        this.setChanged();
    }

    @Override
    public void reload() {
        if (this.snapshot != null) {
            return;
        }
        ModLog.debug("apply {} changes from spec", new Object[]{this.type});
        this.values.forEach((key, value) -> {
            if (value.setter != null) {
                value.setter.accept(value.read());
            }
        });
        this.setChanged();
    }

    @Override
    public void save() {
        if (this.snapshot != null) {
            return;
        }
        ModLog.debug("save {} changes into spec", new Object[]{this.type});
        this.values.forEach((key, value) -> {
            if (value.getter != null) {
                value.write(value.getter.get());
            }
        });
        if (this.saver != null) {
            this.saver.run();
            this.setChanged();
        }
    }

    @Override
    public void notify(Runnable action) {
        this.listeners.add(action);
    }

    protected <T> void bind(T config, Consumer<T> saver) {
        this.spec = config;
        this.saver = () -> saver.accept(config);
    }

    private void setChanged() {
        this.listeners.forEach(Runnable::run);
    }

    public static enum Type {
        COMMON,
        CLIENT,
        SERVER;

    }

    public static class Value<T>
    implements IConfigValue<T> {
        protected final String path;
        protected final T defaultValue;
        protected final Supplier<T> reader;
        protected final Consumer<T> writer;
        protected Consumer<T> setter;
        protected Supplier<T> getter;

        public Value(String path, T defaultValue, Supplier<T> reader, Consumer<T> writer) {
            this.path = path;
            this.defaultValue = defaultValue;
            this.reader = reader;
            this.writer = writer;
        }

        @Override
        public T read() {
            return this.reader.get();
        }

        @Override
        public void write(T value) {
            this.writer.accept(value);
        }

        @Override
        public void bind(Consumer<T> setter, Supplier<T> getter) {
            this.setter = setter;
            this.getter = getter;
        }
    }

    public static abstract class Builder
    implements IConfigBuilder {
        protected String root = "";
        protected final HashMap<String, Value<Object>> values = new HashMap();

        @Override
        public void defineCategory(String name, String description, Runnable runnable) {
            String parent = this.root;
            this.comment(description);
            this.push(name);
            this.root = this.root + name + ".";
            runnable.run();
            this.root = parent;
            this.pop();
        }

        @Override
        public IConfigValue<Boolean> define(String path, boolean defaultValue, String ... description) {
            return this.defineValue(path, this.comment(description).define(path, defaultValue));
        }

        @Override
        public IConfigValue<String> define(String path, String defaultValue, String ... description) {
            return this.defineValue(path, this.comment(description).define(path, defaultValue));
        }

        @Override
        public IConfigValue<Integer> defineInRange(String path, int defaultValue, int min, int max, String ... description) {
            return this.defineValue(path, this.comment(description).defineInRange(path, defaultValue, min, max));
        }

        @Override
        public IConfigValue<Double> defineInRange(String path, double defaultValue, double min, double max, String ... description) {
            return this.defineValue(path, this.comment(description).defineInRange(path, defaultValue, min, max));
        }

        @Override
        public <T> IConfigValue<List<? extends T>> defineList(String path, List<? extends T> defaultValue, Predicate<Object> elementValidator, String ... description) {
            return this.defineValue(path, this.comment(description).defineList(path, defaultValue, elementValidator));
        }

        public <T> IConfigValue<T> defineValue(String path, Value<T> value) {
            this.values.put(this.root + path, (Value)ObjectUtils.unsafeCast(value));
            return value;
        }

        @Override
        public IConfigBuilder builder() {
            return this;
        }

        protected abstract Builder push(String var1);

        protected abstract Builder pop();

        protected abstract Builder comment(String ... var1);

        protected abstract Value<Boolean> define(String var1, boolean var2);

        protected abstract Value<String> define(String var1, String var2);

        protected abstract Value<Integer> defineInRange(String var1, int var2, int var3, int var4);

        protected abstract Value<Double> defineInRange(String var1, double var2, double var4, double var6);

        protected abstract <T> Value<List<? extends T>> defineList(String var1, List<? extends T> var2, Predicate<Object> var3);
    }
}

