/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core.data;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import moe.plushie.armourers_workshop.api.common.IDataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AbstractDataComponentType<T>
implements IDataComponentType<T> {
    private final String name;
    private final Codec<T> codec;

    public AbstractDataComponentType(String name, Codec<T> codec) {
        this.name = name;
        this.codec = codec;
    }

    public static <T> AbstractDataComponentType<T> create(String name, Codec<T> codec) {
        return new AbstractDataComponentType<T>(name, codec);
    }

    @Override
    public boolean has(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        return tag != null && tag.m_128441_(this.name);
    }

    @Override
    public void set(ItemStack itemStack, @Nullable T value) {
        if (value != null) {
            CompoundTag tag = itemStack.m_41784_();
            this.codec.encodeStart((DynamicOps)NbtOps.f_128958_, value).get().ifLeft(it -> tag.m_128365_(this.name, it));
        } else {
            this.remove(itemStack);
        }
    }

    @Override
    @Nullable
    public T get(ItemStack itemStack) {
        Optional value;
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && tag.m_128441_(this.name) && (value = this.codec.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(this.name)).get().left()).isPresent()) {
            return (T)((Pair)value.get()).getFirst();
        }
        return null;
    }

    @Override
    public T getOrDefault(ItemStack itemStack, T defaultValue) {
        T value = this.get(itemStack);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public void remove(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            tag.m_128473_(this.name);
        }
    }
}

