/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.ICapabilityType;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.data.IDataSerializerProvider;
import moe.plushie.armourers_workshop.api.registry.IRegistryHolder;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobeStorage;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;

public class AbstractForgeCapabilityManager {
    public static <T> IRegistryHolder<ICapabilityType<T>> register(IResourceLocation registryName, Class<T> type, Function<Entity, Optional<T>> factory) {
        if (type == SkinWardrobe.class) {
            return (IRegistryHolder)ObjectUtils.unsafeCast(AbstractForgeCapabilityManager.createWardrobeCapabilityType(registryName, (Function)ObjectUtils.unsafeCast(factory)));
        }
        throw new AssertionError();
    }

    private static IRegistryHolder<ICapabilityType<SkinWardrobe>> createWardrobeCapabilityType(IResourceLocation registryName, Function<Entity, Optional<SkinWardrobe>> provider) {
        Capability capability = CapabilityManager.get((CapabilityToken)new CapabilityToken<SkinWardrobe>(){});
        ICapabilityType capabilityType = entity -> entity.getCapability(capability).resolve();
        return new RegistryObjectProxy<SkinWardrobe>(registryName, SkinWardrobe.class, provider, capabilityType, () -> capability);
    }

    public static class RegistryObjectProxy<T extends IDataSerializerProvider>
    implements IRegistryHolder<ICapabilityType<T>> {
        final IResourceLocation registryName;
        final Supplier<Capability<T>> capability;
        final Class<T> type;
        final ICapabilityType<T> capabilityType;
        final Function<Entity, Optional<T>> factory;

        protected RegistryObjectProxy(IResourceLocation registryName, Class<T> type, Function<Entity, Optional<T>> factory, ICapabilityType<T> capabilityType, Supplier<Capability<T>> capability) {
            this.type = type;
            this.factory = factory;
            this.capability = capability;
            this.capabilityType = capabilityType;
            this.registryName = registryName;
            this.setupBus();
        }

        public void setupBus() {
            MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, this::attachEntityCapability);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerCapability);
        }

        public void registerCapability(RegisterCapabilitiesEvent event) {
            event.register(this.type);
        }

        public void attachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
            Optional<T> value = this.factory.apply((Entity)event.getObject());
            if (!value.isPresent()) {
                return;
            }
            event.addCapability(this.registryName.toLocation(), (ICapabilityProvider)new CapabilityProviderProxy<T>((Entity)event.getObject(), (IDataSerializerProvider)value.get()){

                @Override
                public Capability<T> getCapability() {
                    return capability.get();
                }
            });
        }

        @Override
        public ICapabilityType<T> get() {
            return this.capabilityType;
        }

        @Override
        public IResourceLocation getRegistryName() {
            return this.registryName;
        }
    }

    public static abstract class CapabilityProviderProxy<T extends IDataSerializerProvider>
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        protected final T value;
        protected final WeakReference<Entity> entity;

        protected CapabilityProviderProxy(Entity entity, T value) {
            this.value = value;
            this.entity = new WeakReference<Entity>(entity);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            this.value.serialize(SkinWardrobeStorage.writer((Entity)this.entity.get(), tag));
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.value.deserialize(SkinWardrobeStorage.reader((Entity)this.entity.get(), tag));
        }

        public <I> LazyOptional<I> getCapability(Capability<I> cap, @Nullable Direction arg) {
            return this.getCapability().orEmpty(cap, LazyOptional.of(() -> this.value));
        }

        public abstract Capability<T> getCapability();
    }
}

