/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Map;
import moe.plushie.armourers_workshop.api.client.key.IKeyModifier;
import moe.plushie.armourers_workshop.init.platform.EventManager;
import moe.plushie.armourers_workshop.init.platform.event.client.RegisterKeyMappingsEvent;
import moe.plushie.armourers_workshop.utils.ext.OpenKeyModifier;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;

public abstract class AbstractForgeKeyMapping
extends KeyMapping {
    private static final Map<IKeyModifier, KeyModifier> MODIFIERS1 = ImmutableMap.builder().put((Object)OpenKeyModifier.CONTROL, (Object)KeyModifier.CONTROL).put((Object)OpenKeyModifier.SHIFT, (Object)KeyModifier.SHIFT).put((Object)OpenKeyModifier.ALT, (Object)KeyModifier.ALT).put((Object)OpenKeyModifier.NONE, (Object)KeyModifier.NONE).build();
    private static final Map<KeyModifier, IKeyModifier> MODIFIERS2 = ImmutableMap.builder().put((Object)KeyModifier.CONTROL, (Object)OpenKeyModifier.CONTROL).put((Object)KeyModifier.SHIFT, (Object)OpenKeyModifier.SHIFT).put((Object)KeyModifier.ALT, (Object)OpenKeyModifier.ALT).put((Object)KeyModifier.NONE, (Object)OpenKeyModifier.NONE).build();

    public AbstractForgeKeyMapping(String description, IKeyModifier keyModifier, InputConstants.Key keyCode, String category) {
        super(description, (IKeyConflictContext)KeyConflictContext.IN_GAME, MODIFIERS1.getOrDefault(keyModifier, KeyModifier.NONE), keyCode, category);
    }

    public static void register(String name, KeyMapping keyMapping) {
        EventManager.listen(RegisterKeyMappingsEvent.class, event -> event.register(keyMapping));
    }

    public IKeyModifier getOpenKeyModifier() {
        return MODIFIERS2.getOrDefault(this.getKeyModifier(), OpenKeyModifier.NONE);
    }
}

