/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.common.IEntityTypeProvider;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.ArmatureSerializers;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformer;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;
import moe.plushie.armourers_workshop.core.armature.Armatures;
import moe.plushie.armourers_workshop.core.armature.JointModifier;
import moe.plushie.armourers_workshop.core.armature.core.AfterTransformModifier;
import moe.plushie.armourers_workshop.core.armature.core.DefaultOverriddenArmaturePlugin;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.utils.ext.OpenResourceLocation;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public abstract class ArmatureTransformerBuilder {
    protected IResourceLocation parent;
    protected Armature armature;
    protected IDataPackObject contents;
    protected final IResourceLocation name;
    protected final ArrayList<IResourceLocation> models = new ArrayList();
    protected final ArrayList<IEntityTypeProvider<?>> entities = new ArrayList();
    protected final ArrayList<String> pluginModifiers = new ArrayList();
    protected final HashMap<String, Collection<String>> overrideModifiers = new HashMap();
    protected final HashMap<IJoint, Collection<JointModifier>> jointModifiers = new HashMap();
    protected final HashMap<IJoint, Collection<JointModifier>> transformModifiers = new HashMap();

    public ArmatureTransformerBuilder(IResourceLocation name) {
        this.name = name;
    }

    public void load(IDataPackObject object) {
        object.get("parent").ifPresent(it -> {
            this.parent = OpenResourceLocation.parse(it.stringValue());
        });
        object.get("target").ifPresent(it -> {
            this.armature = Armatures.byName(OpenResourceLocation.parse(it.stringValue()));
        });
        this.contents = object;
        if (this.armature != null) {
            this._parseContent(object);
        }
    }

    public void resolve(Collection<ArmatureTransformerBuilder> hierarchy) {
        this._parseContentWithParent(this.contents, hierarchy);
        hierarchy.forEach(builder -> {
            this._mergeTo(builder.jointModifiers, this.jointModifiers);
            this._mergeTo(builder.transformModifiers, this.transformModifiers);
            this._mergeTo(builder.overrideModifiers, this.overrideModifiers);
            this._mergeTo(builder.pluginModifiers, this.pluginModifiers);
            if (this.models.isEmpty()) {
                this._mergeTo(builder.models, this.models);
            }
            if (this.entities.isEmpty()) {
                this._mergeTo(builder.entities, this.entities);
            }
        });
    }

    public ArmatureTransformer build(ArmatureTransformerContext context) {
        ArrayList<ArmaturePlugin> plugins = new ArrayList<ArmaturePlugin>();
        HashMap<IJoint, ArrayList> modifiers = new HashMap<IJoint, ArrayList>();
        plugins.add(new DefaultOverriddenArmaturePlugin(this.overrideModifiers, context));
        this.jointModifiers.forEach((joint, modifiers1) -> modifiers.computeIfAbsent((IJoint)joint, k -> new ArrayList()).addAll(modifiers1));
        this.transformModifiers.forEach((joint, modifiers1) -> modifiers.computeIfAbsent((IJoint)joint, k -> new ArrayList()).addAll(modifiers1));
        this.pluginModifiers.forEach(it -> plugins.add(this.buildPlugin((String)it, context)));
        plugins.removeIf(Objects::isNull);
        ArmatureTransformer transformer = new ArmatureTransformer(this.armature, plugins, context);
        modifiers.forEach((joint, values) -> transformer.put((IJoint)joint, this.buildTransform((IJoint)joint, (Collection<JointModifier>)values, context)));
        return transformer;
    }

    protected ArmaturePlugin buildPlugin(String name, ArmatureTransformerContext context) {
        Function<ArmatureTransformerContext, ? extends ArmaturePlugin> builder = ArmatureSerializers.getPlugin(name);
        if (builder != null) {
            return builder.apply(context);
        }
        return null;
    }

    protected IJointTransform buildTransform(IJoint joint, Collection<JointModifier> modifiers, ArmatureTransformerContext context) {
        IModel model = context.getEntityModel();
        IJointTransform transform = IJointTransform.NONE;
        for (JointModifier modifier : modifiers) {
            transform = modifier.apply(joint, model, transform);
        }
        return transform;
    }

    protected abstract JointModifier buildJointTarget(String var1);

    public ArrayList<IResourceLocation> getModels() {
        return this.models;
    }

    public ArrayList<IEntityTypeProvider<?>> getEntities() {
        return this.entities;
    }

    public IResourceLocation getParent() {
        return this.parent;
    }

    public IResourceLocation getName() {
        return this.name;
    }

    private void _parseContentWithParent(IDataPackObject object, Collection<ArmatureTransformerBuilder> hierarchy) {
        if (this.armature != null || object == null) {
            return;
        }
        for (ArmatureTransformerBuilder builder : hierarchy) {
            if (builder.armature == null) continue;
            this.armature = builder.armature;
            break;
        }
        if (this.armature != null) {
            this._parseContent(object);
        }
    }

    private void _parseContent(IDataPackObject object) {
        object.get("joint").entrySet().forEach(it -> {
            IJoint joint = this.armature.getJoint((String)it.getKey());
            if (joint != null) {
                this.jointModifiers.put(joint, this._parseModelModifiers((IDataPackObject)it.getValue()));
            }
        });
        object.get("transform").ifPresent(it -> {
            it.get("translate").entrySet().forEach(it2 -> this._parseTranslateModifiers((String)it2.getKey(), (IDataPackObject)it2.getValue()));
            it.get("scale").entrySet().forEach(it2 -> this._parseScaleModifiers((String)it2.getKey(), (IDataPackObject)it2.getValue()));
            it.get("rotate").entrySet().forEach(it2 -> this._parseRotateModifiers((String)it2.getKey(), (IDataPackObject)it2.getValue()));
        });
        object.get("override").entrySet().forEach(it -> this.overrideModifiers.put((String)it.getKey(), this._parseOverrideModifiers((IDataPackObject)it.getValue())));
        object.get("plugin").allValues().forEach(it -> this.pluginModifiers.add(it.stringValue()));
        object.get("model").allValues().forEach(it -> this.models.add(ArmatureSerializers.readResourceLocation(it)));
        object.get("entity").allValues().forEach(it -> this.entities.add(ArmatureSerializers.readEntityType(it)));
        this.contents = null;
    }

    private Collection<JointModifier> _parseModelModifiers(IDataPackObject object) {
        switch (object.type()) {
            case STRING: {
                return this._parseJointTargets(object);
            }
            case DICTIONARY: {
                ArrayList<JointModifier> modifiers = new ArrayList<JointModifier>();
                modifiers.addAll(this._parseJointTargets(object));
                modifiers.addAll(this._parseTransformModifiers(object));
                modifiers.addAll(this._parseModifiers(object.get("modifier")));
                return modifiers;
            }
        }
        return Collections.emptyList();
    }

    private Collection<JointModifier> _parseJointTargets(IDataPackObject object) {
        switch (object.type()) {
            case DICTIONARY: {
                return this._parseJointTargets(object.get("target"));
            }
            case STRING: {
                String value = object.stringValue();
                if (!value.isEmpty()) {
                    return Collections.singleton(this.buildJointTarget(value));
                }
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    private Collection<JointModifier> _parseModifiers(IDataPackObject object) {
        switch (object.type()) {
            case ARRAY: {
                ArrayList<JointModifier> modifiers = new ArrayList<JointModifier>();
                object.allValues().forEach(it -> {
                    Supplier<? extends JointModifier> modifier = ArmatureSerializers.getModifier(it.stringValue());
                    if (modifier != null) {
                        modifiers.add(modifier.get());
                    }
                });
                return modifiers;
            }
            case DICTIONARY: {
                ArrayList<JointModifier> modifiers = new ArrayList<JointModifier>();
                object.entrySet().forEach(it -> {
                    Supplier<? extends JointModifier> modifier = ArmatureSerializers.getModifier((String)it.getKey());
                    if (modifier != null) {
                        modifiers.add(modifier.get());
                    }
                });
                return modifiers;
            }
        }
        return Collections.emptyList();
    }

    private Collection<JointModifier> _parseTransformModifiers(IDataPackObject object) {
        ITransformf transform = ArmatureSerializers.readTransform(object);
        if (transform.isIdentity()) {
            return Collections.emptyList();
        }
        return Collections.singleton(new AfterTransformModifier(transform));
    }

    private Collection<String> _parseOverrideModifiers(IDataPackObject object) {
        return switch (object.type()) {
            case IDataPackObject.Type.STRING -> Collections.singleton(object.stringValue());
            case IDataPackObject.Type.ARRAY -> object.collect(IDataPackObject::stringValue);
            default -> Collections.emptyList();
        };
    }

    private void _parseTranslateModifiers(String name, IDataPackObject object) {
        Vector3f value = ArmatureSerializers.readVector(object, Vector3f.ZERO);
        if (value.equals(Vector3f.ZERO)) {
            return;
        }
        SkinTransform transform = SkinTransform.createTranslateTransform(value);
        this._addTransformModifier(name, new AfterTransformModifier(transform));
    }

    private void _parseRotateModifiers(String name, IDataPackObject object) {
        Vector3f value = ArmatureSerializers.readVector(object, Vector3f.ZERO);
        if (value.equals(Vector3f.ZERO)) {
            return;
        }
        SkinTransform transform = SkinTransform.createRotationTransform(value);
        this._addTransformModifier(name, new AfterTransformModifier(transform));
    }

    private void _parseScaleModifiers(String name, IDataPackObject object) {
        Vector3f value = ArmatureSerializers.readVector(object, Vector3f.ONE);
        if (value.equals(Vector3f.ONE)) {
            return;
        }
        SkinTransform transform = SkinTransform.createScaleTransform(value);
        this._addTransformModifier(name, new AfterTransformModifier(transform));
    }

    private void _addTransformModifier(String name, JointModifier modifier) {
        Collection<IJoint> joints;
        if (name.equals("") || name.equals("*")) {
            joints = this.armature.allJoints();
        } else {
            IJoint joint = this.armature.getJoint(name);
            if (joint == null) {
                return;
            }
            joints = Collections.singleton(joint);
        }
        for (IJoint joint : joints) {
            this.transformModifiers.computeIfAbsent(joint, k -> new ArrayList()).add(modifier);
        }
    }

    private <K, V> void _mergeTo(Map<K, V> other, Map<K, V> result) {
        other.forEach((key, value) -> {
            if (!result.containsKey(key)) {
                result.put(key, value);
            }
        });
    }

    private <V> void _mergeTo(Collection<V> other, Collection<V> result) {
        result.addAll(other);
    }

    private static interface ArmatureModifierBuilder {
        public JointModifier apply(Vector3f var1, Vector3f var2, Vector3f var3);
    }
}

