/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.compatibility.client.layer.AbstractSkinnableLayers;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;
import moe.plushie.armourers_workshop.core.client.layer.PlaceholderLayer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public abstract class DefaultLayerArmaturePlugin
extends ArmaturePlugin {
    private ArmatureTransformerContext context;
    protected final ArrayList<Applier<?, ?>> applying = new ArrayList();

    public DefaultLayerArmaturePlugin(ArmatureTransformerContext context) {
        this.context = context;
    }

    public static DefaultLayerArmaturePlugin any(ArmatureTransformerContext context) {
        return new Blacklist(context, DefaultLayerArmaturePlugin::whenAnyVisible);
    }

    public static DefaultLayerArmaturePlugin villager(ArmatureTransformerContext context) {
        Whitelist plugin = new Whitelist(context);
        plugin.register(AbstractSkinnableLayers.VILLAGER_PROFESSION, DefaultLayerArmaturePlugin::whenHeadVisible);
        return plugin;
    }

    public static DefaultLayerArmaturePlugin mob(ArmatureTransformerContext context) {
        Whitelist plugin = new Whitelist(context);
        plugin.register(AbstractSkinnableLayers.STRAY_CLOTHING, DefaultLayerArmaturePlugin::whenBodyVisible);
        plugin.register(AbstractSkinnableLayers.DROWNED_OUTER, DefaultLayerArmaturePlugin::whenBodyVisible);
        return plugin;
    }

    public static BooleanSupplier whenHeadVisible(IModel model) {
        IModelPart modelPart = model.getPart("head");
        if (modelPart != null) {
            return modelPart::isVisible;
        }
        return null;
    }

    public static BooleanSupplier whenAnyVisible(IModel model) {
        Iterator<? extends IModelPart> iterator = model.getAllParts().iterator();
        if (iterator.hasNext()) {
            IModelPart part = iterator.next();
            return part::isVisible;
        }
        return null;
    }

    public static BooleanSupplier whenBodyVisible(IModel model) {
        IModelPart modelPart = model.getPart("body");
        if (modelPart != null) {
            return modelPart::isVisible;
        }
        return null;
    }

    public abstract <T extends LivingEntity, M extends EntityModel<T>> Selector search(RenderLayer<T, M> var1);

    @Override
    public void activate(Entity entity, ArmaturePlugin.Context context) {
        this.applying.forEach((Consumer<Applier<?, ?>>)((Consumer<Applier>)Applier::activate));
    }

    @Override
    public void deactivate(Entity entity, ArmaturePlugin.Context context) {
        this.applying.forEach((Consumer<Applier<?, ?>>)((Consumer<Applier>)Applier::deactivate));
    }

    @Override
    public boolean freeze() {
        if (this.context != null) {
            this.apply(this.context.getEntityModel(), this.context.getEntityRenderer());
            this.context = null;
        }
        return !this.applying.isEmpty();
    }

    private void apply(IModel entityModel, EntityRenderer<?> entityRenderer) {
        if (entityRenderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)entityRenderer;
            this.apply(livingEntityRenderer);
        }
        if (entityModel != null) {
            this.applying.forEach((Consumer<Applier<?, ?>>)((Consumer<Applier>)it -> {
                it.selector.tester = it.selector.testFactory.apply(entityModel);
            }));
            this.applying.removeIf(it -> it.selector.tester == null);
        }
    }

    private <T extends LivingEntity, M extends EntityModel<T>> void apply(LivingEntityRenderer<T, M> entityRenderer) {
        for (RenderLayer layer : entityRenderer.f_115291_) {
            Selector entry = this.search(layer);
            if (entry == null) continue;
            Applier applier = new Applier(entry);
            applier.target = layer;
            applier.placeholder = new PlaceholderLayer<T, M>(entityRenderer);
            applier.layers = () -> entityRenderer.f_115291_;
            this.applying.add(applier);
        }
    }

    public static class Blacklist
    extends DefaultLayerArmaturePlugin {
        protected final ArrayList<Class<?>> blocked = new ArrayList();
        protected final Function<IModel, BooleanSupplier> testFactory;

        public Blacklist(ArmatureTransformerContext context, Function<IModel, BooleanSupplier> testFactory) {
            super(context);
            this.testFactory = testFactory;
        }

        public void register(Class<?> clazz) {
            this.blocked.add(clazz);
        }

        @Override
        public <T extends LivingEntity, M extends EntityModel<T>> Selector search(RenderLayer<T, M> layer) {
            for (Class<?> layerClass : this.blocked) {
                if (!layerClass.isInstance(layer)) continue;
                return null;
            }
            return new Selector(layer.getClass(), this.testFactory);
        }
    }

    public static class Whitelist
    extends DefaultLayerArmaturePlugin {
        protected final ArrayList<Selector> selectors = new ArrayList();

        public Whitelist(ArmatureTransformerContext context) {
            super(context);
        }

        public void register(Class<?> clazz, Function<IModel, BooleanSupplier> testFactory) {
            if (clazz != null) {
                this.selectors.add(new Selector(clazz, testFactory));
            }
        }

        @Override
        public <T extends LivingEntity, M extends EntityModel<T>> Selector search(RenderLayer<T, M> layer) {
            for (Selector entry : this.selectors) {
                if (!entry.layerClass.isInstance(layer)) continue;
                return entry;
            }
            return null;
        }
    }

    public static class Selector {
        private final Class<?> layerClass;
        private final Function<IModel, BooleanSupplier> testFactory;
        private BooleanSupplier tester;

        public Selector(Class<?> layerClass, Function<IModel, BooleanSupplier> testFactory) {
            this.layerClass = layerClass;
            this.testFactory = testFactory;
        }
    }

    public static class Applier<T extends Entity, M extends EntityModel<T>> {
        private final Selector selector;
        private RenderLayer<T, M> target;
        private RenderLayer<T, M> placeholder;
        private Supplier<List<RenderLayer<T, M>>> layers;
        private int lastIndex = -1;
        private boolean isEnabled = false;

        public Applier(Selector selector) {
            this.selector = selector;
        }

        public void activate() {
            if (!this.isEnabled && !this.selector.tester.getAsBoolean()) {
                this.replace(this.target, this.placeholder);
                this.isEnabled = true;
            }
        }

        public void deactivate() {
            if (this.isEnabled) {
                this.replace(this.placeholder, this.target);
                this.isEnabled = false;
            }
        }

        private void replace(RenderLayer<T, M> from, RenderLayer<T, M> to) {
            List<RenderLayer<T, M>> layers = this.layers.get();
            if (this.lastIndex >= 0 && this.lastIndex < layers.size() && layers.get(this.lastIndex) == from) {
                layers.set(this.lastIndex, to);
                return;
            }
            for (int index = 0; index < layers.size(); ++index) {
                if (layers.get(index) != from) continue;
                layers.set(index, to);
                this.lastIndex = index;
                break;
            }
        }
    }
}

