/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IBlockEntityType;
import moe.plushie.armourers_workshop.api.common.IBlockHandler;
import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.api.common.ILootContext;
import moe.plushie.armourers_workshop.api.common.ILootContextParam;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockEntityProvider;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractDataSerializer;
import moe.plushie.armourers_workshop.core.block.AbstractAttachedHorizontalBlock;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.data.SkinBlockPlaceContext;
import moe.plushie.armourers_workshop.core.entity.SeatEntity;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.init.ModBlockEntityTypes;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import moe.plushie.armourers_workshop.utils.math.Vector3d;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SkinnableBlock
extends AbstractAttachedHorizontalBlock
implements AbstractBlockEntityProvider,
IBlockHandler {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;

    public SkinnableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)BedPart.HEAD)).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockEntity createBlockEntity(BlockGetter level, BlockPos blockPos, BlockState blockState) {
        return ((IBlockEntityType)ModBlockEntityTypes.SKINNABLE.get()).create(level, blockPos, blockState);
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity entity, ItemStack itemStack) {
        SkinBlockPlaceContext context = SkinBlockPlaceContext.of(blockPos);
        if (context == null) {
            return;
        }
        context.getParts().forEach(p -> {
            BlockPos target = blockPos.m_121955_((Vec3i)p.getOffset());
            level.m_7731_(target, blockState, 11);
            SkinnableBlockEntity blockEntity = this.getBlockEntity((BlockGetter)level, target);
            if (blockEntity != null) {
                blockEntity.readAdditionalData(AbstractDataSerializer.wrap(p.getEntityTag(), level));
                blockEntity.updateBlockStates();
            }
        });
        super.m_6402_(level, blockPos, blockState, entity, itemStack);
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState.m_60713_(blockState2.m_60734_())) {
            this.brokenByAnything(level, blockPos, blockState, null);
        }
        super.m_6810_(blockState, level, blockPos, blockState2, bl);
    }

    @Override
    public List<ItemStack> getDrops(BlockState blockState, ILootContext context) {
        SkinnableBlockEntity blockEntity1;
        List<ItemStack> results;
        block4: {
            block3: {
                results = super.getDrops(blockState, context);
                BlockEntity blockEntity = context.getOptionalParameter(ILootContextParam.BLOCK_ENTITY);
                if (!(blockEntity instanceof SkinnableBlockEntity)) break block3;
                blockEntity1 = (SkinnableBlockEntity)blockEntity;
                if (!results.isEmpty()) break block4;
            }
            return results;
        }
        ArrayList<ItemStack> fixedResults = new ArrayList<ItemStack>(results.size());
        for (ItemStack itemStack : results) {
            if (itemStack.m_150930_((Item)ModItems.SKIN.get()) && SkinDescriptor.of(itemStack).isEmpty() && (itemStack = blockEntity1.getDropped()) == null) continue;
            fixedResults.add(itemStack);
        }
        return fixedResults;
    }

    @Override
    public BlockState destroyByPlayer(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        this.brokenByAnything(level, blockPos, blockState, player);
        return super.destroyByPlayer(level, blockPos, blockState, player);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity((BlockGetter)level, blockPos);
        if (blockEntity == null) {
            return InteractionResult.FAIL;
        }
        if (blockEntity.isLinked()) {
            BlockPos linkedPos = blockEntity.getLinkedBlockPos();
            BlockState linkedState = level.m_8055_(linkedPos);
            return super.useWithoutItem(linkedState, level, linkedPos, player, blockHitResult);
        }
        if (blockEntity.isBed() && !player.m_36341_() && ModPermissions.SKINNABLE_SLEEP.accept(blockEntity, player)) {
            BlockState bedState = (BlockState)Blocks.f_50028_.m_49966_().m_61124_(PART, (Comparable)BedPart.HEAD);
            return super.useWithoutItem(bedState, level, blockEntity.getBedPos(), player, blockHitResult);
        }
        if (blockEntity.isSeat() && !player.m_36341_() && ModPermissions.SKINNABLE_SIT.accept(blockEntity, player)) {
            if (level.m_5776_()) {
                return InteractionResult.CONSUME;
            }
            Vector3d seatPos = blockEntity.getSeatPos().add(0.5, 0.5, 0.5);
            SeatEntity seatEntity = this.getSeatEntity((ServerLevel)level, blockEntity.getParentPos(), seatPos);
            if (seatEntity == null) {
                return InteractionResult.FAIL;
            }
            player.m_7998_((Entity)seatEntity, true);
            return InteractionResult.SUCCESS;
        }
        if (blockEntity.isInventory()) {
            InteractionResult result = ((IMenuType)ModMenuTypes.SKINNABLE.get()).openMenu(player, level.m_7702_(blockPos));
            if (result.m_19077_()) {
                player.m_36246_(Stats.f_12988_.m_12902_((Object)Stats.f_12968_));
            }
            return result;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        SkinBlockPlaceContext context1;
        BlockState state = super.m_5573_(context);
        if (state != null && context instanceof SkinBlockPlaceContext && (context1 = (SkinBlockPlaceContext)context).getProperty(SkinProperty.BLOCK_GLOWING).booleanValue()) {
            state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader blockGetter, BlockPos blockPos, BlockState blockState) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity((BlockGetter)blockGetter, blockPos);
        if (blockEntity != null) {
            return blockEntity.getDescriptor().asItemStack();
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean isCustomBed(BlockGetter level, BlockPos blockPos, BlockState blockState, @Nullable Entity player) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.isBed();
        }
        return false;
    }

    @Override
    public boolean isCustomLadder(BlockGetter level, BlockPos blockPos, BlockState blockState, LivingEntity entity) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.isLadder();
        }
        return false;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, FACE, LIT, PART, OCCUPIED});
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(blockGetter, blockPos);
        if (blockEntity != null) {
            return blockEntity.getShape();
        }
        return Shapes.m_83040_();
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(blockGetter, blockPos);
        if (blockEntity != null && blockEntity.noCollision()) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(blockState, blockGetter, blockPos, collisionContext);
    }

    public void forEach(Level level, BlockPos pos, Consumer<BlockPos> consumer) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity((BlockGetter)level, pos);
        if (blockEntity == null) {
            return;
        }
        BlockPos parentPos = blockEntity.m_58899_();
        for (BlockPos offset : blockEntity.getRefers()) {
            BlockPos targetPos = parentPos.m_121955_((Vec3i)offset);
            if (targetPos.equals((Object)pos)) continue;
            consumer.accept(targetPos);
        }
    }

    public void brokenByAnything(Level level, BlockPos blockPos, BlockState blockState, @Nullable Player player) {
        if (this.dropItems(level, blockPos, player)) {
            this.killSeatEntities(level, blockPos);
            this.forEach(level, blockPos, target -> level.m_7731_(target, Blocks.f_50016_.m_49966_(), 35));
        }
    }

    public void killSeatEntities(Level level, BlockPos blockPos) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity((BlockGetter)level, blockPos);
        if (blockEntity != null) {
            Vector3d seatPos = blockEntity.getSeatPos().add(0.5, 0.5, 0.5);
            this.killSeatEntity(level, blockEntity.getParentPos(), seatPos);
        }
    }

    public boolean dropItems(Level level, BlockPos blockPos, @Nullable Player player) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity((BlockGetter)level, blockPos);
        SkinnableBlockEntity parentBlockEntity = this.getParentBlockEntity((BlockGetter)level, blockPos);
        if (blockEntity == null || parentBlockEntity == null || parentBlockEntity.isDropped()) {
            return false;
        }
        ItemStack droppedStack = parentBlockEntity.getDescriptor().asItemStack();
        blockEntity.setDropped(droppedStack);
        parentBlockEntity.setDropped(droppedStack);
        if (parentBlockEntity.isInventory()) {
            DataSerializers.dropContents(level, blockPos, (Container)parentBlockEntity);
        }
        return true;
    }

    private SkinnableBlockEntity getBlockEntity(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SkinnableBlockEntity) {
            SkinnableBlockEntity blockEntity1 = (SkinnableBlockEntity)blockEntity;
            return blockEntity1;
        }
        return null;
    }

    private SkinnableBlockEntity getParentBlockEntity(BlockGetter level, BlockPos blockPos) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.getParent();
        }
        return null;
    }

    @Nullable
    private SeatEntity getSeatEntity(ServerLevel level, BlockPos blockPos, Vector3d pos) {
        AABB searchRect = new AABB(pos.x, pos.y, pos.z, pos.x + 1.0, pos.y + 1.0, pos.z + 1.0);
        for (SeatEntity entity : level.m_45976_(SeatEntity.class, searchRect)) {
            if (!entity.m_6084_() || !blockPos.equals((Object)entity.getBlockPos())) continue;
            if (entity.m_20197_().isEmpty()) {
                return entity;
            }
            return null;
        }
        SeatEntity entity = (SeatEntity)((Object)((IEntityType)ModEntityTypes.SEAT.get()).create(level, BlockPos.f_121853_, null, MobSpawnType.SPAWN_EGG));
        entity.m_6034_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
        entity.setBlockPos(blockPos);
        level.m_7967_((Entity)entity);
        return entity;
    }

    private void killSeatEntity(Level level, BlockPos blockPos, Vector3d pos) {
        AABB searchRect = new AABB(pos.x, pos.y, pos.z, pos.x + 1.0, pos.y + 1.0, pos.z + 1.0);
        for (SeatEntity entity : level.m_45976_(SeatEntity.class, searchRect)) {
            if (!entity.m_6084_() || !blockPos.equals((Object)entity.getBlockPos())) continue;
            entity.m_6074_();
        }
    }
}

