/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.blockentity;

import com.google.common.collect.ImmutableMap;
import moe.plushie.armourers_workshop.api.data.IDataSerializer;
import moe.plushie.armourers_workshop.core.block.HologramProjectorBlock;
import moe.plushie.armourers_workshop.core.blockentity.RotableContainerBlockEntity;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.utils.DataSerializerKey;
import moe.plushie.armourers_workshop.utils.DataTypeCodecs;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.NonNullItemList;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class HologramProjectorBlockEntity
extends RotableContainerBlockEntity {
    private static final DataSerializerKey<Vector3f> ANGLE_KEY = DataSerializerKey.create("Angle", DataTypeCodecs.VECTOR_3F, Vector3f.ZERO);
    private static final DataSerializerKey<Vector3f> OFFSET_KEY = DataSerializerKey.create("Offset", DataTypeCodecs.VECTOR_3F, Vector3f.ZERO);
    private static final DataSerializerKey<Vector3f> ROTATION_SPEED_KEY = DataSerializerKey.create("RotSpeed", DataTypeCodecs.VECTOR_3F, Vector3f.ZERO);
    private static final DataSerializerKey<Vector3f> ROTATION_OFFSET_KEY = DataSerializerKey.create("RotOffset", DataTypeCodecs.VECTOR_3F, Vector3f.ZERO);
    private static final DataSerializerKey<Boolean> IS_GLOWING_KEY = DataSerializerKey.create("Glowing", DataTypeCodecs.BOOL, true);
    private static final DataSerializerKey<Boolean> IS_POWERED_KEY = DataSerializerKey.create("Powered", DataTypeCodecs.BOOL, false);
    private static final DataSerializerKey<Float> SCALE_KEY = DataSerializerKey.create("Scale", DataTypeCodecs.FLOAT, Float.valueOf(1.0f));
    private static final DataSerializerKey<Integer> POWER_MODE_KEY = DataSerializerKey.create("PowerMode", DataTypeCodecs.INT, 0);
    private static final ImmutableMap<?, Vector3f> FACING_TO_ROT = new ImmutableMap.Builder().put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.EAST), (Object)new Vector3f(180.0f, 270.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.NORTH), (Object)new Vector3f(180.0f, 180.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.WEST), (Object)new Vector3f(180.0f, 90.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.SOUTH), (Object)new Vector3f(180.0f, 0.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.EAST), (Object)new Vector3f(270.0f, 0.0f, 270.0f)).put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.SOUTH), (Object)new Vector3f(270.0f, 0.0f, 180.0f)).put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.WEST), (Object)new Vector3f(270.0f, 0.0f, 90.0f)).put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.NORTH), (Object)new Vector3f(270.0f, 0.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.EAST), (Object)new Vector3f(0.0f, 270.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.SOUTH), (Object)new Vector3f(0.0f, 180.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.WEST), (Object)new Vector3f(0.0f, 90.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.NORTH), (Object)new Vector3f(0.0f, 0.0f, 0.0f)).build();
    private final NonNullItemList items = new NonNullItemList(1);
    private OpenQuaternionf renderRotations;
    private int powerMode = 0;
    private float modelScale = 1.0f;
    private boolean isGlowing = true;
    private boolean isPowered = false;
    private boolean showRotationPoint = false;
    private Vector3f modelAngle = Vector3f.ZERO;
    private Vector3f modelOffset = Vector3f.ZERO;
    private Vector3f rotationSpeed = Vector3f.ZERO;
    private Vector3f rotationOffset = Vector3f.ZERO;

    public HologramProjectorBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.items.deserialize(serializer);
        this.modelAngle = serializer.read(ANGLE_KEY);
        this.modelOffset = serializer.read(OFFSET_KEY);
        this.rotationSpeed = serializer.read(ROTATION_SPEED_KEY);
        this.rotationOffset = serializer.read(ROTATION_OFFSET_KEY);
        this.isGlowing = serializer.read(IS_GLOWING_KEY);
        this.isPowered = serializer.read(IS_POWERED_KEY);
        this.modelScale = serializer.read(SCALE_KEY).floatValue();
        this.powerMode = serializer.read(POWER_MODE_KEY);
        this.setRenderChanged();
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        this.items.serialize(serializer);
        serializer.write(ANGLE_KEY, this.modelAngle);
        serializer.write(OFFSET_KEY, this.modelOffset);
        serializer.write(ROTATION_SPEED_KEY, this.rotationSpeed);
        serializer.write(ROTATION_OFFSET_KEY, this.rotationOffset);
        serializer.write(IS_GLOWING_KEY, this.isGlowing);
        serializer.write(IS_POWERED_KEY, this.isPowered);
        serializer.write(SCALE_KEY, Float.valueOf(this.modelScale));
        serializer.write(POWER_MODE_KEY, this.powerMode);
    }

    public void updatePowerStats() {
        boolean newValue = this.isRunningForState(this.m_58900_());
        if (newValue != this.isPowered) {
            this.updateBlockStates();
        }
    }

    public void updateBlockStates() {
        BlockState state = this.m_58900_();
        this.isPowered = this.isRunningForState(state);
        this.m_6596_();
        this.setRenderChanged();
        boolean growing = this.isPowered && this.isGlowing;
        Level level = this.m_58904_();
        if (level != null && !level.m_5776_()) {
            if ((Boolean)state.m_61143_((Property)HologramProjectorBlock.LIT) != growing) {
                BlockState newState = (BlockState)state.m_61124_((Property)HologramProjectorBlock.LIT, (Comparable)Boolean.valueOf(growing));
                level.m_7731_(this.m_58899_(), newState, 2);
            } else {
                level.m_7260_(this.m_58899_(), state, state, 2);
            }
        }
    }

    public int getPowerMode() {
        return this.powerMode;
    }

    public void setPowerMode(int powerMode) {
        this.powerMode = powerMode;
        this.updateBlockStates();
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    protected boolean isRunningForState(BlockState state) {
        Level level = this.m_58904_();
        if (level != null && !SkinDescriptor.of((ItemStack)this.items.get(0)).isEmpty()) {
            return switch (this.powerMode) {
                case 1 -> level.m_276867_(this.m_58899_());
                case 2 -> {
                    if (!level.m_276867_(this.m_58899_())) {
                        yield true;
                    }
                    yield false;
                }
                default -> true;
            };
        }
        return false;
    }

    public boolean isOverrideLight() {
        return this.isGlowing;
    }

    public boolean isOverrideOrigin() {
        return true;
    }

    public boolean isGlowing() {
        return this.isGlowing;
    }

    public void setGlowing(boolean glowing) {
        this.isGlowing = glowing;
        this.updateBlockStates();
    }

    public void setShowRotationPoint(boolean showRotationPoint) {
        this.showRotationPoint = showRotationPoint;
    }

    public boolean shouldShowRotationPoint() {
        return this.showRotationPoint;
    }

    @Override
    protected NonNullItemList getItems() {
        return this.items;
    }

    @Override
    protected void setContainerChanged() {
        super.setContainerChanged();
        this.updateBlockStates();
    }

    public boolean m_7013_(int i, ItemStack itemStack) {
        return !SkinDescriptor.of(itemStack).isEmpty();
    }

    public int m_6643_() {
        return 1;
    }

    public Vector3f getRotationSpeed() {
        return this.rotationSpeed;
    }

    public void setRotationSpeed(Vector3f rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
        this.updateBlockStates();
    }

    public Vector3f getRotationOffset() {
        return this.rotationOffset;
    }

    public void setRotationOffset(Vector3f rotationOffset) {
        this.rotationOffset = rotationOffset;
        this.updateBlockStates();
    }

    public Vector3f getModelOffset() {
        return this.modelOffset;
    }

    public void setModelOffset(Vector3f modelOffset) {
        this.modelOffset = modelOffset;
        this.updateBlockStates();
    }

    public Vector3f getModelAngle() {
        return this.modelAngle;
    }

    public void setModelAngle(Vector3f modelAngle) {
        this.modelAngle = modelAngle;
        this.updateBlockStates();
    }

    public float getModelScale() {
        return this.modelScale;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public OpenQuaternionf getRenderRotations(BlockState blockState) {
        if (this.renderRotations != null) {
            return this.renderRotations;
        }
        AttachFace face = blockState.m_61145_((Property)HologramProjectorBlock.FACE).orElse(AttachFace.FLOOR);
        Direction facing = blockState.m_61145_((Property)HologramProjectorBlock.f_54117_).orElse(Direction.NORTH);
        Vector3f rot = (Vector3f)FACING_TO_ROT.getOrDefault((Object)Pair.of((Object)face, (Object)facing), (Object)Vector3f.ZERO);
        this.renderRotations = new OpenQuaternionf(rot.getX(), rot.getY(), rot.getZ(), true);
        return this.renderRotations;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Rectangle3f getRenderShape(BlockState blockState) {
        if (!this.isPowered()) {
            return null;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(this.m_8020_(0));
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.TEST);
        if (bakedSkin == null) {
            return null;
        }
        Rectangle3f rect = bakedSkin.getRenderBounds(SkinItemSource.EMPTY);
        float f = 0.0625f;
        float scale = this.getModelScale() * f;
        float modelRadius = 0.0f;
        float rotationRadius = 0.0f;
        if (!rect.equals(Rectangle3f.ZERO)) {
            double x = MathUtils.absMax(rect.getMinX(), rect.getMaxX());
            double y = MathUtils.absMax(rect.getMinY(), rect.getMaxY());
            double z = MathUtils.absMax(rect.getMinZ(), rect.getMaxZ());
            modelRadius = MathUtils.sqrt(x * x + y * y + z * z);
        }
        if (!this.rotationOffset.equals(Vector3f.ZERO)) {
            float x = Math.abs(this.rotationOffset.getX());
            float y = Math.abs(this.rotationOffset.getY());
            float z = Math.abs(this.rotationOffset.getZ());
            rotationRadius = MathUtils.sqrt(x * x + y * y + z * z);
        }
        float tr = (rotationRadius + modelRadius) * scale;
        float tx = this.modelOffset.getX() * scale;
        float ty = this.modelOffset.getY() * scale + 0.5f;
        float tz = this.modelOffset.getZ() * scale;
        if (this.isOverrideOrigin()) {
            ty += rect.getMaxY() * scale;
        }
        return new Rectangle3f(tx - tr, ty - tr, tz - tr, tr * 2.0f, tr * 2.0f, tr * 2.0f);
    }
}

