/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.capability;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.data.IDataSerializer;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractDataSerializer;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.utils.DataFixerUtils;
import moe.plushie.armourers_workshop.utils.DataSerializerKey;
import moe.plushie.armourers_workshop.utils.DataTypeCodecs;
import moe.plushie.armourers_workshop.utils.NonNullItemList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class SkinWardrobeStorage {
    private static final DataSerializerKey<Byte> VERSION_KEY = DataSerializerKey.create("DataVersion", DataTypeCodecs.BYTE, (byte)0);
    private static final DataSerializerKey<Integer> VISIBILITY_KEY = DataSerializerKey.create("Visibility", DataTypeCodecs.INT, 0);
    private static final DataSerializerKey<List<Short>> SLOTS_KEY = DataSerializerKey.create("Slots", DataTypeCodecs.SHORT.listOf(), Collections.emptyList());

    public static IDataSerializer reader(Entity entity, CompoundTag inputTag) {
        return AbstractDataSerializer.wrap(inputTag, entity);
    }

    public static IDataSerializer writer(Entity entity, CompoundTag outputTag) {
        return AbstractDataSerializer.wrap(outputTag, entity);
    }

    public static void saveDataFixer(SkinWardrobe wardrobe, IDataSerializer serializer) {
        serializer.write(VERSION_KEY, (byte)1);
    }

    public static void loadDataFixer(SkinWardrobe wardrobe, IDataSerializer serializer) {
        Byte version = serializer.read(VERSION_KEY);
        if (version.compareTo((byte)0) <= 0) {
            Container inventory = wardrobe.getInventory();
            DataFixerUtils.move(inventory, 67, SkinSlotType.DYE.getIndex(), 16, "align dye slots storage");
            DataFixerUtils.move(inventory, 57, SkinSlotType.OUTFIT.getIndex(), 10, "align outfit slots storage");
        }
    }

    public static void saveInventoryItems(Container inventory, IDataSerializer serializer) {
        NonNullItemList itemStacks = new NonNullItemList(inventory.m_6643_());
        for (int i = 0; i < itemStacks.size(); ++i) {
            itemStacks.set(i, inventory.m_8020_(i));
        }
        itemStacks.serialize(serializer);
    }

    public static void loadInventoryItems(Container inventory, IDataSerializer serializer) {
        NonNullItemList itemStacks = new NonNullItemList(inventory.m_6643_());
        itemStacks.deserialize(serializer);
        for (int i = 0; i < itemStacks.size(); ++i) {
            ItemStack oldItemStack;
            ItemStack newItemStack = (ItemStack)itemStacks.get(i);
            if (Objects.equals(newItemStack, oldItemStack = inventory.m_8020_(i))) continue;
            inventory.m_6836_(i, newItemStack);
        }
    }

    public static void saveFlags(BitSet flags, IDataSerializer serializer) {
        int value = 0;
        for (int i = 0; i < 32; ++i) {
            if (!flags.get(i)) continue;
            value |= 1 << i;
        }
        if (value != 0) {
            serializer.write(VISIBILITY_KEY, value);
        }
    }

    public static void loadFlags(BitSet flags, IDataSerializer serializer) {
        Integer value = serializer.read(VISIBILITY_KEY);
        flags.clear();
        for (int i = 0; i < 32; ++i) {
            int mask = 1 << i;
            if ((value & mask) == 0) continue;
            flags.set(i);
        }
    }

    public static void saveSkinSlots(HashMap<SkinSlotType, Integer> slots, IDataSerializer serializer) {
        if (slots.isEmpty()) {
            return;
        }
        ArrayList value = new ArrayList();
        slots.forEach((slotType, count) -> {
            int index = slotType.getId() & 0xFF;
            int encoded = index << 8 | count & 0xFF;
            value.add((short)encoded);
        });
        if (!value.isEmpty()) {
            serializer.write(SLOTS_KEY, value);
        }
    }

    public static void loadSkinSlots(HashMap<SkinSlotType, Integer> slots, IDataSerializer serializer) {
        List<Short> value = serializer.read(SLOTS_KEY);
        for (Short encoded : value) {
            SkinSlotType slotType = SkinSlotType.byId(encoded >> 8 & 0xFF);
            if (slotType == null) continue;
            slots.put(slotType, encoded & 0xFF);
        }
    }
}

