/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.animation;

import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class AnimatedPoint {
    protected final Vector3f translate = new Vector3f();
    protected final Vector3f rotation = new Vector3f();
    protected final Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    protected int dirty = 0;

    public void setTranslate(float x, float y, float z) {
        if (x != 0.0f || y != 0.0f || z != 0.0f) {
            this.translate.set(x, y, z);
            this.setDirty(16);
        }
    }

    public Vector3f getTranslate() {
        if ((this.dirty & 0x10) != 0) {
            return this.translate;
        }
        return Vector3f.ZERO;
    }

    public void setRotate(float x, float y, float z) {
        if (x != 0.0f || y != 0.0f || z != 0.0f) {
            this.rotation.set(x, y, z);
            this.setDirty(32);
        }
    }

    public Vector3f getRotation() {
        if ((this.dirty & 0x20) != 0) {
            return this.rotation;
        }
        return Vector3f.ZERO;
    }

    public void setScale(float x, float y, float z) {
        if (x != 1.0f || y != 1.0f || z != 1.0f) {
            this.scale.set(x, y, z);
            this.setDirty(64);
        }
    }

    public Vector3f getScale() {
        if ((this.dirty & 0x40) != 0) {
            return this.scale;
        }
        return Vector3f.ONE;
    }

    public void clear() {
        this.dirty = 0;
    }

    public void setDirty(int newFlags) {
        this.dirty |= newFlags;
    }
}

