/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.animation;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedPoint;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class AnimatedTransform
implements ISkinTransform {
    protected final Vector3f pivot;
    protected final Vector3f afterTranslate;
    protected final SkinTransform parent;
    protected final ArrayList<AnimatedPoint> points = new ArrayList();
    protected AnimatedPoint snapshot;
    protected int dirty = 0;

    public AnimatedTransform(SkinTransform parent) {
        this.parent = parent;
        this.pivot = parent.getPivot();
        this.afterTranslate = parent.getAfterTranslate();
    }

    public void link(AnimatedPoint point) {
        this.points.add(point);
    }

    @Override
    public void apply(IPoseStack poseStack) {
        Vector3f scale;
        Vector3f rotation;
        if (this.snapshot == null) {
            this.parent.apply(poseStack);
            return;
        }
        Vector3f translate = this.snapshot.getTranslate();
        if (translate != Vector3f.ZERO) {
            poseStack.translate(translate.getX(), translate.getY(), translate.getZ());
        }
        if ((rotation = this.snapshot.getRotation()) != Vector3f.ZERO) {
            if (this.pivot != Vector3f.ZERO) {
                poseStack.translate(this.pivot.getX(), this.pivot.getY(), this.pivot.getZ());
            }
            poseStack.rotate(OpenQuaternionf.fromZYX(rotation, true));
            if (this.pivot != Vector3f.ZERO) {
                poseStack.translate(-this.pivot.getX(), -this.pivot.getY(), -this.pivot.getZ());
            }
        }
        if ((scale = this.snapshot.getScale()) != Vector3f.ONE) {
            if (this.pivot != Vector3f.ZERO) {
                poseStack.translate(this.pivot.getX(), this.pivot.getY(), this.pivot.getZ());
            }
            poseStack.scale(scale.getX(), scale.getY(), scale.getZ());
            if (this.pivot != Vector3f.ZERO) {
                poseStack.translate(-this.pivot.getX(), -this.pivot.getY(), -this.pivot.getZ());
            }
        }
        if (this.afterTranslate != Vector3f.ZERO) {
            poseStack.translate(this.afterTranslate.getX(), this.afterTranslate.getY(), this.afterTranslate.getZ());
        }
    }

    public void export(AnimatedPoint value) {
        value.clear();
        this.exportTranslate(value);
        this.exportRotation(value);
        this.exportScale(value);
    }

    private void exportTranslate(AnimatedPoint result) {
        Vector3f base = this.parent.getTranslate();
        float x = base.getX();
        float y = base.getY();
        float z = base.getZ();
        for (AnimatedPoint point : this.points) {
            Vector3f value = point.getTranslate();
            x += value.getX();
            y += value.getY();
            z += value.getZ();
        }
        result.setTranslate(x, y, z);
    }

    private void exportRotation(AnimatedPoint result) {
        Vector3f base = this.parent.getRotation();
        float x = base.getX();
        float y = base.getY();
        float z = base.getZ();
        for (AnimatedPoint point : this.points) {
            Vector3f value = point.getRotation();
            x += value.getX();
            y += value.getY();
            z += value.getZ();
        }
        result.setRotate(x % 360.0f, y % 360.0f, z % 360.0f);
    }

    private void exportScale(AnimatedPoint result) {
        Vector3f base = this.parent.getScale();
        float x = base.getX();
        float y = base.getY();
        float z = base.getZ();
        for (AnimatedPoint point : this.points) {
            Vector3f value = point.getScale();
            x *= value.getX();
            y *= value.getY();
            z *= value.getZ();
        }
        result.setScale(x, y, z);
    }

    public void clear() {
        this.points.forEach(AnimatedPoint::clear);
        this.dirty = 0;
    }

    public void setDirty(int flags) {
        this.dirty |= flags;
    }
}

