/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.animation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedPoint;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedTransform;
import moe.plushie.armourers_workshop.core.client.animation.AnimationController;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import org.jetbrains.annotations.Nullable;

public class AnimationContext {
    protected final ArrayList<SimpleSnapshot> snapshots = new ArrayList();
    protected final HashMap<AnimationController, AnimationController.PlayState> playStates = new HashMap();

    public AnimationContext() {
    }

    public AnimationContext(AnimationContext context) {
        context.snapshots.forEach(snapshot -> this.snapshots.add(new ComplexSnapshot(snapshot.transform)));
    }

    public static AnimationContext from(List<BakedSkinPart> skinParts) {
        AnimationContext context = new AnimationContext();
        ObjectUtils.search(skinParts, BakedSkinPart::getChildren, part -> {
            for (ISkinTransform transform : part.getTransform().getChildren()) {
                if (!(transform instanceof AnimatedTransform)) continue;
                AnimatedTransform transform1 = (AnimatedTransform)transform;
                context.snapshots.add(new SimpleSnapshot(transform1));
            }
        });
        return context;
    }

    public void begin(float animationTicks) {
        for (SimpleSnapshot snapshot : this.snapshots) {
            snapshot.begin();
        }
    }

    public void commit() {
        for (SimpleSnapshot snapshot : this.snapshots) {
            snapshot.commit();
        }
    }

    @Nullable
    public AnimationController.PlayState getPlayState(AnimationController animationController) {
        return this.playStates.get(animationController);
    }

    public boolean isEmpty() {
        return this.snapshots.isEmpty();
    }

    public static class SimpleSnapshot {
        protected final AnimatedTransform transform;

        public SimpleSnapshot(AnimatedTransform transform) {
            this.transform = transform;
        }

        public void begin() {
            this.transform.snapshot = null;
        }

        public void commit() {
        }
    }

    public static class ComplexSnapshot
    extends SimpleSnapshot {
        protected final AnimatedPoint currentValue = new AnimatedPoint();
        protected AnimatedPoint startValue;

        public ComplexSnapshot(AnimatedTransform transform) {
            super(transform);
        }

        @Override
        public void begin() {
            this.transform.snapshot = null;
            this.transform.clear();
        }

        @Override
        public void commit() {
            if (this.startValue == null && this.transform.dirty == 0) {
                return;
            }
            this.transform.export(this.currentValue);
            this.transform.snapshot = this.currentValue;
        }
    }
}

