/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.animation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedPoint;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationFunction;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationLoop;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationValue;
import moe.plushie.armourers_workshop.core.skin.molang.MolangVirtualMachine;
import moe.plushie.armourers_workshop.core.skin.molang.core.Constant;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.ThreadUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import org.apache.commons.lang3.tuple.Pair;

public class AnimationController {
    private final int id = ThreadUtils.nextId(AnimationController.class);
    private final String name;
    private final SkinAnimation animation;
    private final float duration;
    private final SkinAnimationLoop loop;
    private final ArrayList<Bone> bones = new ArrayList();
    private final boolean isParallel;
    private final boolean isRequiresVirtualMachine;

    public AnimationController(SkinAnimation animation, Map<String, BakedSkinPart> bones) {
        this.name = animation.getName();
        this.animation = animation;
        this.loop = animation.getLoop();
        this.duration = animation.getDuration();
        animation.getValues().forEach((boneName, linkedValues) -> {
            BakedSkinPart bone = (BakedSkinPart)bones.get(boneName);
            if (bone != null) {
                this.bones.add(new Bone(bone, AnimationController.toTime(this.duration), (List<SkinAnimationValue>)linkedValues));
            }
        });
        this.isParallel = this.calcParallel();
        this.isRequiresVirtualMachine = this.calcRequiresVirtualMachine();
    }

    public static int toTime(float time) {
        return (int)(time * 1000.0f);
    }

    public void process(float animationTicks) {
        int time = AnimationController.toTime(animationTicks);
        for (Bone bone : this.bones) {
            for (Channel channel : bone.channels) {
                Fragment fragment = channel.getFragmentAtTime(time);
                if (fragment == null) continue;
                fragment.apply(channel.selector, bone.output, time - fragment.startTime);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnimationController)) {
            return false;
        }
        AnimationController that = (AnimationController)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return ObjectUtils.makeDescription(this, new Object[]{"name", this.name, "duration", Float.valueOf(this.duration), "loop", this.loop});
    }

    public String getName() {
        return this.name;
    }

    public SkinAnimationLoop getLoop() {
        return this.loop;
    }

    public float getDuration() {
        return this.duration;
    }

    public boolean isRequiresVirtualMachine() {
        return this.isRequiresVirtualMachine;
    }

    public boolean isParallel() {
        return this.isParallel;
    }

    public boolean isEmpty() {
        return this.bones.isEmpty();
    }

    private boolean calcParallel() {
        return this.name != null && this.name.matches("^(.+\\.)?parallel\\d+$");
    }

    private boolean calcRequiresVirtualMachine() {
        for (Bone bone : this.bones) {
            for (Channel channel : bone.channels) {
                for (Fragment fragment : channel.fragments) {
                    if (fragment.startValue.isConstant() && fragment.endValue.isConstant()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static class Bone {
        private final BakedSkinPart part;
        private final List<Channel> channels;
        private final Output output;

        public Bone(BakedSkinPart part, int duration, List<SkinAnimationValue> linkedValues) {
            this.channels = this.create(duration, linkedValues);
            this.part = part;
            this.output = this.linkTo(part);
        }

        private List<Channel> create(float duration, List<SkinAnimationValue> linkedValues) {
            LinkedHashMap<String, ArrayList> namedValues = new LinkedHashMap<String, ArrayList>();
            for (SkinAnimationValue value : linkedValues) {
                namedValues.computeIfAbsent(value.getKey(), key -> new ArrayList()).add(value);
            }
            return ObjectUtils.map(namedValues.entrySet(), it -> new Channel((String)it.getKey(), duration, (List)it.getValue()));
        }

        private Output linkTo(BakedSkinPart bone) {
            ISkinTransform transform2;
            for (ISkinTransform transform2 : bone.getTransform().getChildren()) {
                if (!(transform2 instanceof AnimatedTransform)) continue;
                AnimatedTransform animatedTransform = (AnimatedTransform)transform2;
                return new Output(animatedTransform);
            }
            transform2 = bone.getPart().getTransform();
            if (!(transform2 instanceof SkinTransform)) {
                return new Output(null);
            }
            SkinTransform parent = (SkinTransform)transform2;
            AnimatedTransform animatedTransform = new AnimatedTransform(parent);
            bone.getTransform().replaceChild(parent, animatedTransform);
            return new Output(animatedTransform);
        }
    }

    public static class Channel {
        private final Selector selector;
        private final Fragment[] fragments;
        private Fragment current;

        public Channel(String name, float duration, List<SkinAnimationValue> values) {
            this.selector = Selector.of(name);
            this.fragments = this.create(duration, values).toArray(new Fragment[0]);
        }

        public Fragment getFragmentAtTime(int time) {
            if (this.current != null && this.current.contains(time)) {
                return this.current;
            }
            Fragment[] fragmentArray = this.fragments;
            int n = fragmentArray.length;
            for (int i = 0; i < n; ++i) {
                Fragment fragment;
                this.current = fragment = fragmentArray[i];
                if (this.current.contains(time)) break;
            }
            return this.current;
        }

        public boolean isEmpty() {
            return this.fragments == null || this.fragments.length == 0;
        }

        private List<Fragment> create(float duration, List<SkinAnimationValue> values) {
            float defaultValue = this.calcDefaultValue();
            ArrayList<FragmentBuilder> builders = new ArrayList<FragmentBuilder>();
            for (SkinAnimationValue value : values) {
                int time = AnimationController.toTime(value.getTime());
                Pair<Value, Value> point = this.compile(value.getPoints(), defaultValue);
                builders.add(new FragmentBuilder(time, value.getFunction(), (Value)point.getLeft(), (Value)point.getRight()));
            }
            builders.sort(Comparator.comparingInt(it -> it.leftTime));
            if (!builders.isEmpty()) {
                builders.add(0, ((FragmentBuilder)builders.get(0)).copy(AnimationController.toTime(0.0f)));
                builders.add(((FragmentBuilder)builders.get(builders.size() - 1)).copy(AnimationController.toTime(duration)));
            }
            for (int i = 1; i < builders.size(); ++i) {
                FragmentBuilder left = (FragmentBuilder)builders.get(i - 1);
                FragmentBuilder right = (FragmentBuilder)builders.get(i);
                left.rightTime = right.leftTime;
                left.rightValue = right.leftValue;
            }
            builders.removeIf(it -> it.leftTime == it.rightTime);
            return ObjectUtils.map(builders, FragmentBuilder::build);
        }

        private Pair<Value, Value> compile(List<Object> points, float defaultValue) {
            Expression[] expressions = new Expression[6];
            for (int i = 0; i < expressions.length; ++i) {
                expressions[i] = i < points.size() ? this.compile(points.get(i), (double)defaultValue) : expressions[i % points.size()];
            }
            Value left = new Value(expressions[0], expressions[1], expressions[2]);
            Value right = new Value(expressions[3], expressions[4], expressions[5]);
            return Pair.of((Object)left, (Object)right);
        }

        private Expression compile(Object object, double defaultValue) {
            try {
                if (object instanceof Number) {
                    Number number = (Number)object;
                    return new Constant(number.doubleValue());
                }
                if (object instanceof String) {
                    String script = (String)object;
                    return MolangVirtualMachine.get().eval(script);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return new Constant(defaultValue);
        }

        private float calcDefaultValue() {
            if (this.selector instanceof Selector.Scale) {
                return 1.0f;
            }
            return 0.0f;
        }
    }

    public static class Fragment {
        private final int startTime;
        private final Value startValue;
        private final int endTime;
        private final Value endValue;
        private final int length;
        private final SkinAnimationFunction function;

        public Fragment(int startTime, Value startValue, int endTime, Value endValue, SkinAnimationFunction function) {
            this.startTime = startTime;
            this.startValue = startValue;
            this.endTime = endTime;
            this.endValue = endValue;
            this.length = endTime - startTime;
            this.function = function;
        }

        public void apply(Selector selector, Output output, int time) {
            if (time <= 0) {
                selector.apply(output, this.startValue.get());
            } else if (time >= this.length) {
                selector.apply(output, this.endValue.get());
            } else {
                Vector3f from = this.startValue.get();
                Vector3f to = this.endValue.get();
                float t = this.function.apply((float)time / (float)this.length);
                float tx = this.lerp(from.getX(), to.getX(), t);
                float ty = this.lerp(from.getY(), to.getY(), t);
                float tz = this.lerp(from.getZ(), to.getZ(), t);
                selector.apply(output, tx, ty, tz);
            }
        }

        public float lerp(float start, float end, float t) {
            return start + (end - start) * t;
        }

        public boolean contains(int time) {
            return this.startTime <= time && time < this.endTime;
        }
    }

    public static class Selector {
        public static Selector of(String channel) {
            return switch (channel) {
                case "position" -> new Translation();
                case "rotation" -> new Rotation();
                case "scale" -> new Scale();
                default -> new Selector();
            };
        }

        protected void apply(Output output, float x, float y, float z) {
        }

        protected void apply(Output snapshot, Vector3f value) {
            this.apply(snapshot, value.getX(), value.getY(), value.getZ());
        }

        public static class Translation
        extends Selector {
            @Override
            protected void apply(Output output, float x, float y, float z) {
                output.setTranslate(x, y, z);
            }
        }

        public static class Rotation
        extends Selector {
            @Override
            protected void apply(Output output, float x, float y, float z) {
                output.setRotate(x, y, z);
            }
        }

        public static class Scale
        extends Selector {
            @Override
            protected void apply(Output output, float x, float y, float z) {
                output.setScale(x, y, z);
            }
        }
    }

    public static class Output
    extends AnimatedPoint {
        private final AnimatedTransform transform;

        public Output(AnimatedTransform transform) {
            this.transform = transform;
            if (transform != null) {
                transform.link(this);
            }
        }

        @Override
        public void setDirty(int newFlags) {
            super.setDirty(newFlags);
            if (this.transform != null) {
                this.transform.setDirty(newFlags);
            }
        }
    }

    public static class Value {
        private final Runnable updater;
        private final Vector3f variable = new Vector3f();

        public Value(Expression x, Expression y, Expression z) {
            this.updater = this.build(x, y, z);
        }

        public Vector3f get() {
            if (this.updater != null) {
                this.updater.run();
            }
            return this.variable;
        }

        public boolean isConstant() {
            return this.updater == null;
        }

        private Runnable build(Expression x, Expression y, Expression z) {
            if (x.isMutable() || y.isMutable() || z.isMutable()) {
                return () -> this.variable.set(x.getAsFloat(), y.getAsFloat(), z.getAsFloat());
            }
            this.variable.set(x.getAsFloat(), y.getAsFloat(), z.getAsFloat());
            return null;
        }
    }

    public static class PlayState {
        private float startTime0;
        private final float startTime;
        private final float duration;
        private int playCount;
        private float adjustedTicks = 0.0f;

        public PlayState(AnimationController animationController, float atTime, int playCount) {
            this.duration = animationController.getDuration();
            this.startTime = atTime;
            this.startTime0 = atTime;
            this.playCount = this.calcPlayCount(playCount, animationController.getLoop());
        }

        public void tick(float animationTicks) {
            this.adjustedTicks = animationTicks - this.startTime0;
            if (this.playCount == 0 || this.adjustedTicks < this.duration) {
                return;
            }
            if (this.playCount > 0) {
                --this.playCount;
            }
            if (this.playCount != 0) {
                this.adjustedTicks -= this.duration;
                this.startTime0 = animationTicks - this.adjustedTicks;
            }
        }

        public float getStartTicks() {
            return this.startTime;
        }

        public float getAdjustedTicks(float animationTicks) {
            this.tick(animationTicks);
            return this.adjustedTicks;
        }

        public int getPlayCount() {
            return this.playCount;
        }

        public boolean isCompleted() {
            return this.playCount == 0 && this.adjustedTicks > this.duration;
        }

        private int calcPlayCount(int playCount, SkinAnimationLoop loop) {
            if (playCount == 0) {
                return switch (loop) {
                    default -> throw new IncompatibleClassChangeError();
                    case SkinAnimationLoop.NONE -> 1;
                    case SkinAnimationLoop.LAST_FRAME -> 0;
                    case SkinAnimationLoop.LOOP -> -1;
                };
            }
            return playCount;
        }
    }

    public static class FragmentBuilder {
        private final SkinAnimationFunction function;
        private final int leftTime;
        private final Value leftValue;
        private int rightTime;
        private Value rightValue;

        FragmentBuilder(int time, SkinAnimationFunction function, Value leftValue, Value rightValue) {
            this.function = function;
            this.leftTime = time;
            this.leftValue = leftValue;
            this.rightTime = time;
            this.rightValue = rightValue;
        }

        public FragmentBuilder copy(int time) {
            if (time > 0) {
                return new FragmentBuilder(time, SkinAnimationFunction.linear(), this.rightValue, this.rightValue);
            }
            return new FragmentBuilder(time, SkinAnimationFunction.linear(), this.leftValue, this.leftValue);
        }

        public Fragment build() {
            return new Fragment(this.leftTime, this.leftValue, this.rightTime, this.rightValue, this.function);
        }
    }
}

