/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.animation;

import moe.plushie.armourers_workshop.core.client.animation.AnimationContext;
import moe.plushie.armourers_workshop.core.client.animation.AnimationController;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.skin.molang.MolangVirtualMachine;
import moe.plushie.armourers_workshop.core.skin.molang.core.Variable;
import moe.plushie.armourers_workshop.utils.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnimationEngine {
    private static final MolangVirtualMachine VM = MolangVirtualMachine.get();
    private static final Variable ANIM_TIME = AnimationEngine.VM.animTime;
    private static final Variable LIFE_TIME = AnimationEngine.VM.lifeTime;
    private static final Variable ACTOR_COUNT = AnimationEngine.VM.actorCount;
    private static final Variable TIME_OF_DAY = AnimationEngine.VM.timeOfDay;
    private static final Variable MOON_PHASE = AnimationEngine.VM.moonPhase;
    private static final Variable DISTANCE_FROM_CAMERA = AnimationEngine.VM.distanceFromCamera;
    private static final Variable IS_ON_GROUND = AnimationEngine.VM.isOnGround;
    private static final Variable IS_IN_WATER = AnimationEngine.VM.isInWater;
    private static final Variable IS_IN_WATER_OR_RAIN = AnimationEngine.VM.isInWaterOrRain;
    private static final Variable HEALTH = AnimationEngine.VM.health;
    private static final Variable MAX_HEALTH = AnimationEngine.VM.maxHealth;
    private static final Variable IS_ON_FIRE = AnimationEngine.VM.isOnFire;
    private static final Variable GROUND_SPEED = AnimationEngine.VM.groundSpeed;
    private static final Variable YAW_SPEED = AnimationEngine.VM.yawSpeed;

    public static void start() {
    }

    public static void stop() {
        VM.getVariables().forEach((name, variable) -> variable.set(0.0));
    }

    public static void apply(Object source, BakedSkin skin, float animationTicks, AnimationContext context) {
        context.begin(animationTicks);
        for (AnimationController animationController : skin.getAnimationControllers()) {
            AnimationController.PlayState playState = context.getPlayState(animationController);
            if (playState == null) continue;
            float adjustedTicks = playState.getAdjustedTicks(animationTicks);
            if (animationController.isRequiresVirtualMachine()) {
                AnimationEngine.upload(source, adjustedTicks, playState.getStartTicks());
            }
            animationController.process(adjustedTicks);
        }
        context.commit();
    }

    public static void upload(Object source, double animTime, double startAnimTime) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        ANIM_TIME.set(animTime);
        LIFE_TIME.set(startAnimTime);
        TIME_OF_DAY.set((double)level.m_46468_() / 24000.0);
        ACTOR_COUNT.set(level.m_104813_());
        MOON_PHASE.set(level.m_46941_());
        if (source instanceof Entity) {
            Entity entity = (Entity)source;
            AnimationEngine.uploadEntity(entity, animTime, startAnimTime);
        }
        if (source instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)source;
            AnimationEngine.uploadLivingEntity(livingEntity, animTime, startAnimTime);
        }
    }

    private static void uploadEntity(Entity entity, double animTime, double startAnimTime) {
        DISTANCE_FROM_CAMERA.set(() -> Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82554_(entity.m_20182_()));
        IS_ON_GROUND.set(entity.m_20096_());
        IS_IN_WATER.set(entity.m_20069_());
        IS_IN_WATER_OR_RAIN.set(entity.m_20071_());
    }

    private static void uploadLivingEntity(LivingEntity livingEntity, double animTime, double startAnimTime) {
        HEALTH.set(livingEntity.m_21223_());
        MAX_HEALTH.set(livingEntity.m_21233_());
        IS_ON_FIRE.set(livingEntity.m_6060_());
        GROUND_SPEED.set(() -> {
            Vec3 velocity = livingEntity.m_20184_();
            return MathUtils.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_);
        });
        YAW_SPEED.set(() -> {
            float a = livingEntity.m_5675_((float)animTime - 0.1f);
            return livingEntity.m_5675_((float)animTime - a);
        });
    }
}

